/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.res2.ValueResourceNameValidator;
import com.android.resources.ResourceType;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ValueResourceParser2 {
    @NonNull
    private final File mFile;

    ValueResourceParser2(@NonNull File file) {
        this.mFile = file;
    }

    @NonNull
    List<ResourceItem> parseFile() throws MergingException {
        Document document = ValueResourceParser2.parseDocument(this.mFile);
        Element rootNode = document.getDocumentElement();
        if (rootNode == null) {
            return Collections.emptyList();
        }
        NodeList nodes = rootNode.getChildNodes();
        int count = nodes.getLength();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)count);
        EnumMap map = Maps.newEnumMap(ResourceType.class);
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            ResourceItem resource;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node, this.mFile)) == null) continue;
            ValueResourceParser2.checkDuplicate(resource, map, this.mFile);
            resources.add(resource);
            if (resource.getType() != ResourceType.DECLARE_STYLEABLE) continue;
            ValueResourceParser2.addStyleableItems(node, resources, map, this.mFile);
        }
        return resources;
    }

    static ResourceItem getResource(@NonNull Node node, @Nullable File from) throws MergingException {
        ResourceType type = ValueResourceParser2.getType(node, from);
        String name = ValueResourceParser2.getName(node);
        if (name != null) {
            if (type != null) {
                ValueResourceNameValidator.validate(name, type, from);
                return new ResourceItem(name, type, node);
            }
        } else if (type == ResourceType.PUBLIC) {
            return new ResourceItem("", type, node);
        }
        return null;
    }

    static ResourceType getType(@NonNull Node node, @Nullable File from) throws MergingException {
        String nodeName = node.getLocalName();
        String typeString = null;
        if ("item".equals(nodeName)) {
            Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "type");
            if (attribute != null) {
                typeString = attribute.getValue();
            }
        } else {
            if ("eat-comment".equals(nodeName) || "skip".equals(nodeName)) {
                return null;
            }
            typeString = nodeName;
        }
        if (typeString != null) {
            ResourceType type = ResourceType.getEnum((String)typeString);
            if (type != null) {
                return type;
            }
            throw MergingException.withMessage("Unsupported type '%s'", typeString).withFile(from).build();
        }
        throw MergingException.withMessage("Unsupported node '%s'", nodeName).withFile(from).build();
    }

    static String getName(@NonNull Node node) {
        Attr attribute = (Attr)node.getAttributes().getNamedItemNS(null, "name");
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    @NonNull
    static Document parseDocument(@NonNull File file) throws MergingException {
        try {
            return XmlUtils.parseUtfXmlFile((File)file, (boolean)true);
        }
        catch (SAXParseException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (ParserConfigurationException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (SAXException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
        catch (IOException e) {
            throw MergingException.wrapException(e).withFile(file).build();
        }
    }

    static void addStyleableItems(@NonNull Node styleableNode, @NonNull List<ResourceItem> list, @Nullable Map<ResourceType, Set<String>> map, @Nullable File from) throws MergingException {
        assert (styleableNode.getNodeName().equals(ResourceType.DECLARE_STYLEABLE.getName()));
        NodeList nodes = styleableNode.getChildNodes();
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            ResourceItem resource;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || (resource = ValueResourceParser2.getResource(node, from)) == null) continue;
            assert (resource.getType() == ResourceType.ATTR);
            if (resource.getName().startsWith("android:") || !ValueResourceParser2.hasFormatAttribute(node) && !XmlUtils.hasElementChildren((Node)node)) continue;
            ValueResourceParser2.checkDuplicate(resource, map, from);
            resource.setIgnoredFromDiskMerge(true);
            list.add(resource);
        }
    }

    private static void checkDuplicate(@NonNull ResourceItem resource, @Nullable Map<ResourceType, Set<String>> map, @Nullable File from) throws MergingException {
        if (map == null) {
            return;
        }
        String name = resource.getName();
        HashSet set = map.get(resource.getType());
        if (set == null) {
            set = Sets.newHashSet((Object[])new String[]{name});
            map.put(resource.getType(), set);
        } else {
            if (set.contains(name) && resource.getType() != ResourceType.PUBLIC) {
                throw MergingException.withMessage("Found item %s/%s more than one time", resource.getType().getDisplayName(), name).withFile(from).build();
            }
            set.add((String)name);
        }
    }

    private static boolean hasFormatAttribute(Node node) {
        return node.getAttributes().getNamedItemNS(null, "format") != null;
    }
}

