/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.annotations;

import com.android.build.gradle.tasks.annotations.ApiDatabase;
import com.android.build.gradle.tasks.annotations.Extractor;
import com.android.tools.lint.EcjParser;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ExtractAnnotationsDriver {
    public static void main(String[] args) {
        new ExtractAnnotationsDriver().run(args);
    }

    private static void usage(PrintStream output) {
        output.println("Usage: " + ExtractAnnotationsDriver.class.getSimpleName() + " <flags>");
        output.println(" --sources <paths>       : Source directories to extract annotations from. ");
        output.println("                           Separate paths with " + File.pathSeparator + ", and you can use @ ");
        output.println("                           as a filename prefix to have the filenames fed from a file");
        output.println("--classpath <paths>      : Directories and .jar files to resolve symbols from");
        output.println("--output <zip path>      : The .zip file to write the extracted annotations to, if any");
        output.println("--proguard <path>        : The proguard.cfg file to write the keep rules to, if any");
        output.println();
        output.println("Optional flags:");
        output.println("--merge-zips <paths>     : Existing external annotation files to merge in");
        output.println("--quiet                  : Don't print summary information");
        output.println("--rmtypedefs <folder>    : Remove typedef classes found in the given folder");
        output.println("--allow-missing-types    : Don't fail even if some types can't be resolved");
        output.println("--allow-errors           : Don't fail even if there are some compiler errors");
        output.println("--encoding <encoding>    : Encoding (defaults to utf-8)");
        output.println("--language-level <level> : Java source language level, typically 1.6 (default) or 1.7");
        output.println("--api-filter <api.txt>   : A framework API definition to restrict included APIs to");
        output.println("--hide-filtered          : If filtering out non-APIs, supply this flag to hide listing matches");
        output.println("--skip-class-retention   : Don't extract annotations that have class retention");
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        List<Object> classpath = Lists.newArrayList();
        List<Object> sources = Lists.newArrayList();
        List<Object> mergePaths = Lists.newArrayList();
        List apiFilters = null;
        File rmTypeDefs = null;
        boolean verbose = true;
        boolean allowMissingTypes = false;
        boolean allowErrors = false;
        boolean listFiltered = true;
        boolean skipClassRetention = false;
        String encoding = Charsets.UTF_8.name();
        File output = null;
        File proguard = null;
        long languageLevel = EcjParser.getLanguageLevel((int)1, (int)7);
        if (args.length == 1 && "--help".equals(args[0])) {
            ExtractAnnotationsDriver.usage(System.out);
        }
        if (args.length < 2) {
            ExtractAnnotationsDriver.usage(System.err);
        }
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            String flag = args[i];
            if (flag.equals("--quiet")) {
                verbose = false;
                continue;
            }
            if (flag.equals("--allow-missing-types")) {
                allowMissingTypes = true;
                continue;
            }
            if (flag.equals("--allow-errors")) {
                allowErrors = true;
                continue;
            }
            if (flag.equals("--hide-filtered")) {
                listFiltered = false;
                continue;
            }
            if (flag.equals("--skip-class-retention")) {
                skipClassRetention = true;
                continue;
            }
            if (i == n - 1) {
                ExtractAnnotationsDriver.usage(System.err);
            }
            String value = args[i + 1];
            ++i;
            if (flag.equals("--sources")) {
                sources = ExtractAnnotationsDriver.getFiles(value);
                continue;
            }
            if (flag.equals("--classpath")) {
                classpath = ExtractAnnotationsDriver.getPaths(value);
                continue;
            }
            if (flag.equals("--merge-zips")) {
                mergePaths = ExtractAnnotationsDriver.getFiles(value);
                continue;
            }
            if (flag.equals("--output")) {
                output = new File(value);
                if (output.exists()) {
                    boolean deleted;
                    if (output.isDirectory()) {
                        ExtractAnnotationsDriver.abort(output + " is a directory");
                    }
                    if (deleted = output.delete()) continue;
                    ExtractAnnotationsDriver.abort("Could not delete previous version of " + output);
                    continue;
                }
                if (output.getParentFile() == null || output.getParentFile().exists()) continue;
                ExtractAnnotationsDriver.abort(output.getParentFile() + " does not exist");
                continue;
            }
            if (flag.equals("--proguard")) {
                proguard = new File(value);
                if (proguard.exists()) {
                    boolean deleted;
                    if (proguard.isDirectory()) {
                        ExtractAnnotationsDriver.abort(proguard + " is a directory");
                    }
                    if (deleted = proguard.delete()) continue;
                    ExtractAnnotationsDriver.abort("Could not delete previous version of " + proguard);
                    continue;
                }
                if (proguard.getParentFile() == null || proguard.getParentFile().exists()) continue;
                ExtractAnnotationsDriver.abort(proguard.getParentFile() + " does not exist");
                continue;
            }
            if (flag.equals("--encoding")) {
                encoding = value;
                continue;
            }
            if (flag.equals("--api-filter")) {
                if (apiFilters == null) {
                    apiFilters = Lists.newArrayList();
                }
                for (String path : Splitter.on((String)",").omitEmptyStrings().split((CharSequence)value)) {
                    File apiFilter = new File(path);
                    if (!apiFilter.isFile()) {
                        String string = apiFilter + " does not exist or is not a file";
                        ExtractAnnotationsDriver.abort(string);
                    }
                    apiFilters.add(apiFilter);
                }
                continue;
            }
            if (flag.equals("--language-level")) {
                if ("1.6".equals(value)) {
                    languageLevel = EcjParser.getLanguageLevel((int)1, (int)6);
                    continue;
                }
                if ("1.7".equals(value)) {
                    languageLevel = EcjParser.getLanguageLevel((int)1, (int)7);
                    continue;
                }
                ExtractAnnotationsDriver.abort("Unsupported language level " + value);
                continue;
            }
            if (flag.equals("--rmtypedefs")) {
                rmTypeDefs = new File(value);
                if (rmTypeDefs.isDirectory()) continue;
                ExtractAnnotationsDriver.abort(rmTypeDefs + " is not a directory");
                continue;
            }
            System.err.println("Unknown flag " + flag + ": Use --help for usage information");
        }
        if (sources.isEmpty()) {
            ExtractAnnotationsDriver.abort("Must specify at least one source path");
        }
        if (classpath.isEmpty()) {
            ExtractAnnotationsDriver.abort("Must specify classpath pointing to at least android.jar or the framework");
        }
        if (output == null && proguard == null) {
            ExtractAnnotationsDriver.abort("Must specify output path with --output or a proguard path with --proguard");
        }
        ApiDatabase database = null;
        if (apiFilters != null && !apiFilters.isEmpty()) {
            try {
                ArrayList lines = Lists.newArrayList();
                for (File file : apiFilters) {
                    lines.addAll(Files.readLines((File)file, (Charset)Charsets.UTF_8));
                }
                database = new ApiDatabase(lines);
            }
            catch (IOException e) {
                ExtractAnnotationsDriver.abort("Could not open API database " + apiFilters + ": " + e.getLocalizedMessage());
            }
        }
        Extractor extractor = new Extractor(database, rmTypeDefs, verbose, !skipClassRetention, true);
        extractor.setListIgnored(listFiltered);
        EcjParser.EcjResult result = null;
        try {
            result = ExtractAnnotationsDriver.parseSources(sources, classpath, encoding, languageLevel);
            Collection units = result.getCompilationUnits();
            boolean abort = false;
            int errorCount = 0;
            for (CompilationUnitDeclaration compilationUnitDeclaration : units) {
                CategorizedProblem[] problems = compilationUnitDeclaration.compilationResult().getAllProblems();
                if (problems == null) continue;
                for (CategorizedProblem problem : problems) {
                    if (!problem.isError()) continue;
                    ++errorCount;
                    String message = problem.getMessage();
                    if (allowMissingTypes && message.contains("cannot be resolved")) continue;
                    System.out.println("Error: " + new String(problem.getOriginatingFileName()) + ":" + problem.getSourceLineNumber() + ": " + message);
                    abort = !allowErrors;
                }
            }
            if (errorCount > 0) {
                System.err.println("Found " + errorCount + " errors");
            }
            if (abort) {
                ExtractAnnotationsDriver.abort("Not extracting annotations (compilation problems encountered)");
            }
            extractor.extractFromProjectSource(units);
            if (mergePaths != null) {
                for (File file : mergePaths) {
                    extractor.mergeExisting(file);
                }
            }
            extractor.export(output, proguard);
            if (rmTypeDefs != null) {
                extractor.removeTypedefClasses();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                result.dispose();
            }
        }
    }

    private static void abort(String message) {
        System.err.println(message);
        System.exit(-1);
    }

    private static List<File> getFiles(String value) {
        ArrayList files = Lists.newArrayList();
        Splitter splitter = Splitter.on((char)File.pathSeparatorChar).omitEmptyStrings().trimResults();
        for (String path : splitter.split((CharSequence)value)) {
            File file;
            if (path.startsWith("@")) {
                File sourcePath = new File(path.substring(1));
                if (!sourcePath.exists()) {
                    ExtractAnnotationsDriver.abort(sourcePath + " does not exist");
                }
                try {
                    for (String line : Files.readLines((File)sourcePath, (Charset)Charsets.UTF_8)) {
                        if ((line = line.trim()).isEmpty()) continue;
                        File file2 = new File(line);
                        if (!file2.exists()) {
                            System.err.println("Warning: Could not find file " + line + " listed in " + sourcePath);
                        }
                        files.add(file2);
                    }
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            if (!(file = new File(path)).exists()) {
                ExtractAnnotationsDriver.abort(file + " does not exist");
            }
            files.add(file);
        }
        return files;
    }

    private static List<String> getPaths(String value) {
        List<File> files = ExtractAnnotationsDriver.getFiles(value);
        ArrayList paths = Lists.newArrayListWithExpectedSize((int)files.size());
        for (File file : files) {
            paths.add(file.getPath());
        }
        return paths;
    }

    private static void addJavaSources(List<File> list, File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    ExtractAnnotationsDriver.addJavaSources(list, child);
                }
            }
        } else if (file.isFile() && file.getName().endsWith(".java")) {
            list.add(file);
        }
    }

    private static List<File> gatherJavaSources(List<File> sourcePath) {
        ArrayList sources = Lists.newArrayList();
        for (File file : sourcePath) {
            ExtractAnnotationsDriver.addJavaSources(sources, file);
        }
        return sources;
    }

    private static EcjParser.EcjResult parseSources(List<File> sourcePaths, List<String> classpath, String encoding, long languageLevel) throws IOException {
        ArrayList sourceUnits = Lists.newArrayListWithExpectedSize((int)100);
        for (File source : ExtractAnnotationsDriver.gatherJavaSources(sourcePaths)) {
            char[] contents = Util.getFileCharContent((File)source, (String)encoding);
            CompilationUnit unit = new CompilationUnit(contents, source.getPath(), encoding);
            sourceUnits.add(unit);
        }
        CompilerOptions options = EcjParser.createCompilerOptions();
        options.docCommentSupport = true;
        options.complianceLevel = options.sourceLevel = languageLevel;
        options.targetJDK = options.sourceLevel;
        options.originalComplianceLevel = options.sourceLevel;
        options.originalSourceLevel = options.sourceLevel;
        options.inlineJsrBytecode = true;
        return EcjParser.parse((CompilerOptions)options, (List)sourceUnits, classpath, null);
    }
}

