/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.transforms.BaseProguardAction;
import com.android.ide.common.process.ProcessException;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import proguard.ParseException;

public class MultiDexTransform
extends BaseProguardAction {
    private final File manifestKeepListFile;
    private final VariantScope variantScope;
    private final File includeInMainDexJarFile;
    private final File configFileOut;
    private final File mainDexListFile;

    public MultiDexTransform(File manifestKeepListFile, VariantScope variantScope, File includeInMainDexJarFile) {
        this.manifestKeepListFile = manifestKeepListFile;
        this.variantScope = variantScope;
        this.includeInMainDexJarFile = includeInMainDexJarFile;
        this.configFileOut = new File(variantScope.getGlobalScope().getBuildDir() + "/" + "intermediates" + "/multi-dex/" + variantScope.getVariantConfiguration().getDirName() + "/components.flags");
        this.mainDexListFile = variantScope.getMainDexListFile();
    }

    public String getName() {
        return "multidexlist";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return ImmutableSet.of((Object)QualifiedContent.DefaultContentType.CLASSES);
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<File> getSecondaryFileInputs() {
        if (this.includeInMainDexJarFile != null) {
            return ImmutableList.of((Object)this.includeInMainDexJarFile);
        }
        return ImmutableList.of();
    }

    public Collection<File> getSecondaryFileOutputs() {
        return Lists.newArrayList((Object[])new File[]{this.mainDexListFile, this.configFileOut});
    }

    public boolean isIncremental() {
        return false;
    }

    public void transform(Context context, Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider outputProvider, boolean isIncremental) throws IOException, TransformException, InterruptedException {
        try {
            File input = MultiDexTransform.verifyInputs(referencedInputs);
            this.shrinkWithProguard(input);
            this.computeList(input);
        }
        catch (ParseException e) {
            throw new TransformException((Throwable)e);
        }
        catch (ProcessException e) {
            throw new TransformException((Throwable)e);
        }
    }

    private static File verifyInputs(Collection<TransformInput> inputs) {
        ArrayList inputFiles = Lists.newArrayList();
        for (TransformInput transformInput : inputs) {
            for (JarInput jarInput : transformInput.getJarInputs()) {
                inputFiles.add(jarInput.getFile());
            }
            for (DirectoryInput directoryInput : transformInput.getDirectoryInputs()) {
                inputFiles.add(directoryInput.getFile());
            }
        }
        return (File)Iterables.getOnlyElement((Iterable)inputFiles);
    }

    private void shrinkWithProguard(File input) throws IOException, ParseException {
        this.dontobfuscate();
        this.dontoptimize();
        this.dontpreverify();
        this.dontwarn();
        this.forceprocessing();
        this.applyConfigurationFile(this.manifestKeepListFile);
        this.libraryJar(this.findShrinkedAndroidJar());
        this.inJar(input);
        this.outJar(this.variantScope.getProguardComponentsJarFile());
        this.printconfiguration(this.configFileOut);
        this.runProguard();
    }

    private File findShrinkedAndroidJar() {
        Preconditions.checkNotNull((Object)this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo());
        File shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "lib" + File.separatorChar + "shrinkedAndroid.jar");
        if (!shrinkedAndroid.isFile()) {
            shrinkedAndroid = new File(this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getLocation(), "multidex" + File.separatorChar + "shrinkedAndroid.jar");
        }
        return shrinkedAndroid;
    }

    private void computeList(File _allClassesJarFile) throws ProcessException, IOException {
        Set<String> mainDexClasses = this.callDx(_allClassesJarFile, this.variantScope.getProguardComponentsJarFile());
        if (this.includeInMainDexJarFile != null) {
            mainDexClasses.addAll(this.callDx(_allClassesJarFile, this.includeInMainDexJarFile));
        }
        String fileContent = Joiner.on((String)System.getProperty("line.separator")).join(mainDexClasses);
        Files.write((CharSequence)fileContent, (File)this.mainDexListFile, (Charset)Charsets.UTF_8);
    }

    private Set<String> callDx(File allClassesJarFile, File jarOfRoots) throws ProcessException {
        return this.variantScope.getGlobalScope().getAndroidBuilder().createMainDexList(allClassesJarFile, jarOfRoots);
    }
}

