/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.internal.LoggedErrorException;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.logging.Logger;

public class DexTransform
extends Transform {
    private final DexOptions dexOptions;
    private final boolean debugMode;
    private final boolean multiDex;
    private final File intermediateFolder;
    private final File mainDexListFile;
    private final AndroidBuilder androidBuilder;
    private final ILogger logger;

    public DexTransform(DexOptions dexOptions, boolean debugMode, boolean multiDex, File mainDexListFile, File intermediateFolder, AndroidBuilder androidBuilder, Logger logger) {
        this.dexOptions = dexOptions;
        this.debugMode = debugMode;
        this.multiDex = multiDex;
        this.mainDexListFile = mainDexListFile;
        this.intermediateFolder = intermediateFolder;
        this.androidBuilder = androidBuilder;
        this.logger = new LoggerWrapper(logger);
    }

    public String getName() {
        return "dex";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return TransformManager.CONTENT_DEX;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.SCOPE_FULL_PROJECT;
    }

    public Collection<File> getSecondaryFileInputs() {
        if (this.mainDexListFile != null) {
            return ImmutableList.of((Object)this.mainDexListFile);
        }
        return ImmutableList.of();
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        if (this.dexOptions.getPreDexLibraries() && (!this.multiDex || this.mainDexListFile != null)) {
            return ImmutableList.of((Object)this.intermediateFolder);
        }
        return ImmutableList.of();
    }

    public Map<String, Object> getParameterInputs() {
        try {
            HashMap params = Maps.newHashMapWithExpectedSize((int)4);
            params.put("debugMode", this.debugMode);
            params.put("predex", this.dexOptions.getPreDexLibraries());
            params.put("incremental", this.dexOptions.getIncremental());
            params.put("jumbo", this.dexOptions.getJumboMode());
            params.put("multidex", this.multiDex);
            params.put("multidex-legacy", this.multiDex && this.mainDexListFile != null);
            TargetInfo targetInfo = this.androidBuilder.getTargetInfo();
            Preconditions.checkState((targetInfo != null ? 1 : 0) != 0, (String)"androidBuilder.targetInfo required for task '%s'.", (Object[])new Object[]{this.getName()});
            BuildToolInfo buildTools = targetInfo.getBuildTools();
            params.put("build-tools", buildTools.getRevision().toString());
            return params;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isIncremental() {
        return true;
    }

    public void transform(Context context, Collection<TransformInput> inputs, Collection<TransformInput> referencedInputs, TransformOutputProvider outputProvider, boolean isIncremental) throws TransformException, IOException, InterruptedException {
        Preconditions.checkNotNull((Object)outputProvider, (Object)("Missing output object for transform " + this.getName()));
        ArrayList jarInputs = Lists.newArrayList();
        ArrayList directoryInputs = Lists.newArrayList();
        for (TransformInput input : inputs) {
            jarInputs.addAll(input.getJarInputs());
            directoryInputs.addAll(input.getDirectoryInputs());
        }
        try {
            if (jarInputs.size() + directoryInputs.size() == 1 || !this.dexOptions.getPreDexLibraries()) {
                File outputDir = outputProvider.getContentLocation("main", this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                FileUtils.mkdirs((File)outputDir);
                FileUtils.emptyFolder((File)outputDir);
                ArrayList inputFiles = Lists.newArrayList();
                for (JarInput jarInput : jarInputs) {
                    inputFiles.add(jarInput.getFile());
                }
                for (DirectoryInput directoryInput : directoryInputs) {
                    inputFiles.add(directoryInput.getFile());
                }
                this.androidBuilder.convertByteCode((Collection)inputFiles, outputDir, this.multiDex, this.mainDexListFile, this.dexOptions, null, false, true, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.logger));
            } else {
                boolean needMerge = !this.multiDex || this.mainDexListFile != null;
                File perStreamDexFolder = null;
                if (needMerge) {
                    perStreamDexFolder = this.intermediateFolder;
                    if (!isIncremental) {
                        FileUtils.deleteFolder((File)perStreamDexFolder);
                    }
                } else if (!isIncremental) {
                    outputProvider.deleteAll();
                }
                HashSet hashs = Sets.newHashSet();
                HashMap inputFiles = Maps.newHashMap();
                ArrayList deletedFiles = Lists.newArrayList();
                for (DirectoryInput directoryInput : directoryInputs) {
                    File rootFolder = directoryInput.getFile();
                    if (!rootFolder.exists()) {
                        File preDexedFile = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)directoryInput);
                        if (!preDexedFile.exists()) continue;
                        deletedFiles.add(preDexedFile);
                        continue;
                    }
                    if (isIncremental && directoryInput.getChangedFiles().isEmpty()) continue;
                    File preDexFile = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)directoryInput);
                    inputFiles.put(rootFolder, preDexFile);
                }
                for (JarInput jarInput : jarInputs) {
                    switch (jarInput.getStatus()) {
                        case NOTCHANGED: {
                            if (isIncremental) break;
                        }
                        case CHANGED: 
                        case ADDED: {
                            File preDexFile = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)jarInput);
                            inputFiles.put(jarInput.getFile(), preDexFile);
                            break;
                        }
                        case REMOVED: {
                            File preDexedFile = this.getPreDexFile(outputProvider, needMerge, perStreamDexFolder, (QualifiedContent)jarInput);
                            if (!preDexedFile.exists()) break;
                            deletedFiles.add(preDexedFile);
                            break;
                        }
                    }
                }
                WaitableExecutor executor = new WaitableExecutor();
                LoggedProcessOutputHandler outputHandler = new LoggedProcessOutputHandler(this.logger);
                for (Map.Entry entry : inputFiles.entrySet()) {
                    PreDexTask action = new PreDexTask((File)entry.getKey(), (File)entry.getValue(), hashs, (ProcessOutputHandler)outputHandler);
                    executor.execute((Callable)action);
                }
                for (final File file : deletedFiles) {
                    executor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            FileUtils.deleteFolder((File)file);
                            return null;
                        }
                    });
                }
                executor.waitForTasksWithQuickFail(false);
                if (needMerge) {
                    File outputDir = outputProvider.getContentLocation("main", TransformManager.CONTENT_DEX, this.getScopes(), Format.DIRECTORY);
                    FileUtils.mkdirs((File)outputDir);
                    FileUtils.emptyFolder((File)outputDir);
                    FileUtils.mkdirs((File)outputDir);
                    List<File> outputs = null;
                    if (!this.multiDex) {
                        File[] files = this.intermediateFolder.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File file, String name) {
                                return name.endsWith(".jar");
                            }
                        });
                        if (files != null) {
                            outputs = Arrays.asList(files);
                        }
                    } else {
                        File[] directories = this.intermediateFolder.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                return file.isDirectory();
                            }
                        });
                        if (directories != null) {
                            outputs = Arrays.asList(directories);
                        }
                    }
                    if (outputs == null) {
                        throw new RuntimeException("No dex files to merge!");
                    }
                    this.androidBuilder.convertByteCode(outputs, outputDir, this.multiDex, this.mainDexListFile, this.dexOptions, null, false, true, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.logger));
                }
            }
        }
        catch (LoggedErrorException e) {
            throw new TransformException((Throwable)e);
        }
        catch (ProcessException e) {
            throw new TransformException((Throwable)e);
        }
    }

    private static String getFileHash(File file) throws IOException {
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = file.isDirectory() ? hashFunction.hashString((CharSequence)file.getPath(), Charsets.UTF_16LE) : Files.hash((File)file, (HashFunction)hashFunction);
        return hashCode.toString();
    }

    private File getPreDexFile(TransformOutputProvider output, boolean needMerge, File outFolder, QualifiedContent qualifiedContent) {
        if (needMerge) {
            Preconditions.checkNotNull((Object)outFolder);
            return new File(outFolder, this.getFilename(qualifiedContent.getFile()));
        }
        return this.getOutputLocation(output, qualifiedContent, qualifiedContent.getFile());
    }

    private File getOutputLocation(TransformOutputProvider output, QualifiedContent qualifiedContent, File file) {
        File contentLocation = output.getContentLocation(this.getFilename(file), TransformManager.CONTENT_DEX, qualifiedContent.getScopes(), this.multiDex ? Format.DIRECTORY : Format.JAR);
        if (this.multiDex) {
            FileUtils.mkdirs((File)contentLocation);
        } else {
            FileUtils.mkdirs((File)contentLocation.getParentFile());
        }
        return contentLocation;
    }

    private String getFilename(File inputFile) {
        String suffix;
        String name = Files.getNameWithoutExtension((String)inputFile.getName());
        String input = inputFile.getAbsolutePath();
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = hashFunction.hashString((CharSequence)input, Charsets.UTF_16LE);
        String string = suffix = this.multiDex ? "" : ".jar";
        if (name.equals("classes") && inputFile.getAbsolutePath().contains("exploded-aar")) {
            File versionDir = inputFile.getParentFile().getParentFile();
            File artifactDir = versionDir.getParentFile();
            File groupDir = artifactDir.getParentFile();
            name = Joiner.on((char)'-').join((Object)groupDir.getName(), (Object)artifactDir.getName(), new Object[]{versionDir.getName()});
        }
        return name + "_" + hashCode.toString() + suffix;
    }

    private final class PreDexTask
    implements Callable<Void> {
        private final File from;
        private final File to;
        private final Set<String> hashs;
        private final ProcessOutputHandler mOutputHandler;

        private PreDexTask(File from, File to, Set<String> hashs, ProcessOutputHandler outputHandler) {
            this.from = from;
            this.to = to;
            this.hashs = hashs;
            this.mOutputHandler = outputHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            String hash = DexTransform.getFileHash(this.from);
            Set<String> set = this.hashs;
            synchronized (set) {
                if (this.hashs.contains(hash)) {
                    return null;
                }
                this.hashs.add(hash);
            }
            if (this.to.isDirectory()) {
                FileUtils.emptyFolder((File)this.to);
            } else if (this.to.isFile()) {
                FileUtils.delete((File)this.to);
            } else if (DexTransform.this.multiDex) {
                FileUtils.mkdirs((File)this.to);
            } else {
                FileUtils.mkdirs((File)this.to.getParentFile());
            }
            DexTransform.this.androidBuilder.preDexLibrary(this.from, this.to, DexTransform.this.multiDex, DexTransform.this.dexOptions, this.mOutputHandler);
            return null;
        }
    }
}

