/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.core;

public enum Abi {
    ARMEABI("armeabi", "arm", "arm-linux-androideabi", "arm-linux-androideabi", false),
    ARMEABI_V7A("armeabi-v7a", "arm", "arm-linux-androideabi", "arm-linux-androideabi", false),
    ARM64_V8A("arm64-v8a", "arm64", "aarch64-linux-android", "aarch64-linux-android", true),
    X86("x86", "x86", "x86", "i686-linux-android", false),
    X86_64("x86_64", "x86_64", "x86_64", "x86_64-linux-android", true),
    MIPS("mips", "mips", "mipsel-linux-android", "mipsel-linux-android", false),
    MIPS64("mips64", "mips64", "mips64el-linux-android", "mips64el-linux-android", true);

    private String name;
    String architecture;
    private String gccToolchainPrefix;
    private String gccExecutablePrefix;
    private boolean supports64Bits;

    private Abi(String name, String architecture, String gccToolchainPrefix, String gccExecutablePrefix, boolean supports64Bits) {
        this.name = name;
        this.architecture = architecture;
        this.gccToolchainPrefix = gccToolchainPrefix;
        this.gccExecutablePrefix = gccExecutablePrefix;
        this.supports64Bits = supports64Bits;
    }

    public static Abi getByName(String name) {
        for (Abi abi : Abi.values()) {
            if (!abi.name.equals(name)) continue;
            return abi;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getGccToolchainPrefix() {
        return this.gccToolchainPrefix;
    }

    public String getGccExecutablePrefix() {
        return this.gccExecutablePrefix;
    }

    public boolean supports64Bits() {
        return this.supports64Bits;
    }
}

