/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.TestAndroidConfig;
import com.android.build.gradle.internal.ApplicationTaskManager;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.scope.AndroidTask;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DeviceProviderInstrumentTestTask;
import com.android.build.gradle.internal.test.TestApplicationTestData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.testing.ConnectedDeviceProvider;
import com.android.builder.testing.api.DeviceProvider;
import com.android.utils.ILogger;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class TestApplicationTaskManager
extends ApplicationTaskManager {
    public TestApplicationTaskManager(Project project, AndroidBuilder androidBuilder, DataBindingBuilder dataBindingBuilder, AndroidConfig extension, SdkHandler sdkHandler, DependencyManager dependencyManager, ToolingModelBuilderRegistry toolingRegistry) {
        super(project, androidBuilder, dataBindingBuilder, extension, sdkHandler, dependencyManager, toolingRegistry);
    }

    @Override
    public void createTasksForVariantData(TaskFactory tasks, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        super.createTasksForVariantData(tasks, variantData);
        Configuration testTarget = (Configuration)this.project.getConfigurations().create("testTarget");
        DependencyHandler dependencyHandler = this.project.getDependencies();
        TestAndroidConfig testExtension = (TestAndroidConfig)this.extension;
        dependencyHandler.add("testTarget", (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)testExtension.getTargetVariant())));
        Configuration testTargetMetadata = (Configuration)this.project.getConfigurations().create("testTargetMetadata");
        dependencyHandler.add("testTargetMetadata", (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)(testExtension.getTargetVariant() + "-metadata"))));
        TestApplicationTestData testData = new TestApplicationTestData(variantData, testTarget, testTargetMetadata, this.androidBuilder);
        AndroidTask<DeviceProviderInstrumentTestTask> instrumentTestTask = this.getAndroidTasks().create(tasks, new DeviceProviderInstrumentTestTask.ConfigAction(variantData.getScope(), (DeviceProvider)new ConnectedDeviceProvider(this.sdkHandler.getSdkInfo().getAdb(), this.getGlobalScope().getExtension().getAdbOptions().getTimeOutInMs(), (ILogger)new LoggerWrapper(this.getLogger())), testData){

            @Override
            public String getName() {
                return super.getName() + VariantType.ANDROID_TEST.getSuffix();
            }
        });
        instrumentTestTask.dependsOn(tasks, testTarget, testTargetMetadata, variantData.assembleVariantTask);
        Task connectedAndroidTest = tasks.named("connected" + VariantType.ANDROID_TEST.getSuffix());
        if (connectedAndroidTest != null) {
            connectedAndroidTest.dependsOn(new Object[]{instrumentTestTask.getName()});
        }
    }

    @Override
    protected void createMinifyTransform(TaskFactory taskFactory, VariantScope variantScope, boolean createJarFile) {
        DependencyHandler dependencyHandler = this.project.getDependencies();
        TestAndroidConfig testExtension = (TestAndroidConfig)this.extension;
        Configuration testTargetMapping = (Configuration)this.project.getConfigurations().create("testTargetMapping");
        dependencyHandler.add("testTargetMapping", (Object)dependencyHandler.project((Map)ImmutableMap.of((Object)"path", (Object)testExtension.getTargetProjectPath(), (Object)"configuration", (Object)(testExtension.getTargetVariant() + "-mapping"))));
        if (testTargetMapping.getFiles().isEmpty() || variantScope.getVariantConfiguration().getProvidedOnlyJars().isEmpty()) {
            return;
        }
        this.doCreateMinifyTransform(taskFactory, variantScope, testTargetMapping, false);
    }
}

