/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.packages.BrokenPackage;
import com.android.sdklib.internal.repository.packages.IAndroidVersionProvider;
import com.android.sdklib.internal.repository.packages.IExactApiLevelDependency;
import com.android.sdklib.internal.repository.packages.ILayoutlibVersion;
import com.android.sdklib.internal.repository.packages.IPlatformDependency;
import com.android.sdklib.internal.repository.packages.LayoutlibVersionMixin;
import com.android.sdklib.internal.repository.packages.MajorRevisionPackage;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalAddonPkgInfo;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

@Deprecated
public class AddonPackage
extends MajorRevisionPackage
implements IAndroidVersionProvider,
IPlatformDependency,
IExactApiLevelDependency,
ILayoutlibVersion {
    private final String mVendorId;
    private final String mVendorDisplay;
    private final String mNameId;
    private final String mDisplayName;
    private final AndroidVersion mVersion;
    private final IPkgDesc mPkgDesc;
    private final LayoutlibVersionMixin mLayoutlibVersion;
    private final Lib[] mLibs;

    public AddonPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        String nameId = PackageParserUtils.getXmlString(packageNode, "name-id");
        String nameDisp = PackageParserUtils.getXmlString(packageNode, "name-display");
        String name = PackageParserUtils.getXmlString(packageNode, "name");
        if (nameDisp.isEmpty()) {
            nameDisp = name;
        }
        if (nameId.isEmpty()) {
            nameId = LocalAddonPkgInfo.sanitizeDisplayToNameId(!name.isEmpty() ? name : nameDisp);
        }
        assert (!nameId.isEmpty());
        assert (!nameDisp.isEmpty());
        this.mNameId = nameId.trim();
        this.mDisplayName = nameDisp.trim();
        String vendorId = PackageParserUtils.getXmlString(packageNode, "vendor-id");
        String vendorDisp = PackageParserUtils.getXmlString(packageNode, "vendor-display");
        String vendor = PackageParserUtils.getXmlString(packageNode, "vendor");
        if (vendorDisp.isEmpty()) {
            vendorDisp = vendor;
        }
        if (vendorId.isEmpty()) {
            boolean hasVendor = !vendor.isEmpty();
            vendorId = LocalAddonPkgInfo.sanitizeDisplayToNameId(hasVendor ? vendor : vendorDisp);
        }
        assert (!vendorId.isEmpty());
        assert (!vendorDisp.isEmpty());
        this.mVendorId = vendorId.trim();
        this.mVendorDisplay = vendorDisp.trim();
        int apiLevel = PackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        this.mVersion = new AndroidVersion(apiLevel, null);
        this.mLibs = this.parseLibs(PackageParserUtils.findChildElement(packageNode, "libs"));
        this.mLayoutlibVersion = new LayoutlibVersionMixin(packageNode);
        this.mPkgDesc = this.setDescriptions(PkgDesc.Builder.newAddon(this.mVersion, (MajorRevision)this.getRevision(), new IdDisplay(this.mVendorId, this.mVendorDisplay), new IdDisplay(this.mNameId, this.mDisplayName))).create();
    }

    public static Package create(IAndroidTarget target, Properties props) {
        return new AddonPackage(target, props);
    }

    protected AddonPackage(IAndroidTarget target, Properties props) {
        this(null, target, props);
    }

    protected AddonPackage(SdkSource source, IAndroidTarget target, Properties props) {
        super(source, props, target.getRevision(), null, target.getDescription(), null, target.getLocation());
        String nameId = AddonPackage.getProperty(props, "Addon.NameId", "");
        String nameDisp = AddonPackage.getProperty(props, "Addon.NameDisplay", "");
        String name = AddonPackage.getProperty(props, "Addon.Name", target.getName());
        if (nameDisp.isEmpty()) {
            nameDisp = name;
        }
        if (nameId.isEmpty()) {
            nameId = LocalAddonPkgInfo.sanitizeDisplayToNameId(!name.isEmpty() ? name : nameDisp);
        }
        assert (!nameId.isEmpty());
        assert (!nameDisp.isEmpty());
        this.mNameId = nameId.trim();
        this.mDisplayName = nameDisp.trim();
        String vendorId = AddonPackage.getProperty(props, "Addon.VendorId", "");
        String vendorDisp = AddonPackage.getProperty(props, "Addon.VendorDisplay", "");
        String vendor = AddonPackage.getProperty(props, "Addon.Vendor", target.getVendor());
        if (vendorDisp.isEmpty()) {
            vendorDisp = vendor;
        }
        if (vendorId.isEmpty()) {
            boolean hasVendor = !vendor.isEmpty();
            vendorId = LocalAddonPkgInfo.sanitizeDisplayToNameId(hasVendor ? vendor : vendorDisp);
        }
        assert (!vendorId.isEmpty());
        assert (!vendorDisp.isEmpty());
        this.mVendorId = vendorId.trim();
        this.mVendorDisplay = vendorDisp.trim();
        this.mVersion = target.getVersion();
        this.mLayoutlibVersion = new LayoutlibVersionMixin(props);
        List<IAndroidTarget.OptionalLibrary> optLibs = target.getAdditionalLibraries();
        if (optLibs.isEmpty()) {
            this.mLibs = new Lib[0];
        } else {
            this.mLibs = new Lib[optLibs.size()];
            for (int i = 0; i < optLibs.size(); ++i) {
                IAndroidTarget.OptionalLibrary optionalLibrary = optLibs.get(i);
                this.mLibs[i] = new Lib(optionalLibrary.getName(), optionalLibrary.getDescription());
            }
        }
        this.mPkgDesc = this.setDescriptions(PkgDesc.Builder.newAddon(this.mVersion, (MajorRevision)this.getRevision(), new IdDisplay(this.mVendorId, this.mVendorDisplay), new IdDisplay(this.mNameId, this.mDisplayName))).create();
    }

    @Override
    public IPkgDesc getPkgDesc() {
        return this.mPkgDesc;
    }

    public static Package createBroken(String archiveOsPath, Properties sourceProps, Map<String, String> addonProps, String error) {
        String nameId = AddonPackage.getProperty(sourceProps, "Addon.NameId", null);
        String nameDisp = AddonPackage.getProperty(sourceProps, "Addon.NameDisplay", null);
        if (nameDisp == null) {
            nameDisp = AddonPackage.getProperty(sourceProps, "Addon.NameDisplay", null);
        }
        if (nameDisp == null) {
            nameDisp = addonProps.get("name");
        }
        if (nameDisp == null) {
            nameDisp = "Unknown";
        }
        if (nameId == null) {
            nameId = LocalAddonPkgInfo.sanitizeDisplayToNameId(nameDisp);
        }
        String vendorId = AddonPackage.getProperty(sourceProps, "Addon.VendorId", null);
        String vendorDisp = AddonPackage.getProperty(sourceProps, "Addon.VendorDisplay", null);
        if (vendorDisp == null) {
            vendorDisp = AddonPackage.getProperty(sourceProps, "Addon.VendorDisplay", null);
        }
        if (vendorDisp == null) {
            vendorDisp = addonProps.get("vendor");
        }
        if (vendorDisp == null) {
            vendorDisp = "Unknown";
        }
        if (vendorId == null) {
            vendorId = LocalAddonPkgInfo.sanitizeDisplayToNameId(vendorDisp);
        }
        String api = addonProps.get("api");
        String revision = addonProps.get("revision");
        String shortDesc = String.format("%1$s by %2$s, Android API %3$s, revision %4$s [*]", nameDisp, vendorDisp, api, revision);
        String longDesc = String.format("%1$s\n[*] Addon failed to load: %2$s", shortDesc, error);
        int apiLevel = 0;
        try {
            apiLevel = Integer.parseInt(api);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        int intRevision = 0;
        try {
            intRevision = Integer.parseInt(revision);
        }
        catch (NumberFormatException ignore) {
            // empty catch block
        }
        IPkgDesc desc = PkgDesc.Builder.newAddon(new AndroidVersion(apiLevel, null), new MajorRevision(intRevision), new IdDisplay(vendorId, vendorDisp), new IdDisplay(nameId, nameDisp)).setDescriptionShort(shortDesc).create();
        return new BrokenPackage(null, shortDesc, longDesc, 0, apiLevel, archiveOsPath, desc);
    }

    @Override
    public int getExactApiLevel() {
        return this.mVersion.getApiLevel();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.mVersion.saveProperties(props);
        this.mLayoutlibVersion.saveProperties(props);
        props.setProperty("Addon.NameId", this.mNameId);
        props.setProperty("Addon.NameDisplay", this.mDisplayName);
        props.setProperty("Addon.VendorId", this.mVendorId);
        props.setProperty("Addon.VendorDisplay", this.mVendorDisplay);
    }

    private Lib[] parseLibs(Node libsNode) {
        ArrayList<Lib> libs = new ArrayList<Lib>();
        if (libsNode != null) {
            String nsUri = libsNode.getNamespaceURI();
            for (Node child = libsNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1 || !nsUri.equals(child.getNamespaceURI()) || !"lib".equals(child.getLocalName())) continue;
                libs.add(this.parseLib(child));
            }
        }
        return libs.toArray(new Lib[libs.size()]);
    }

    private Lib parseLib(Node libNode) {
        return new Lib(PackageParserUtils.getXmlString(libNode, "name"), PackageParserUtils.getXmlString(libNode, "description"));
    }

    public String getVendorId() {
        return this.mVendorId;
    }

    public String getDisplayVendor() {
        return this.mVendorDisplay;
    }

    public String getNameId() {
        return this.mNameId;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    @Override
    public AndroidVersion getAndroidVersion() {
        return this.mVersion;
    }

    public Lib[] getLibs() {
        return this.mLibs;
    }

    @Override
    public Pair<Integer, Integer> getLayoutlibVersion() {
        return this.mLayoutlibVersion.getLayoutlibVersion();
    }

    @Override
    public String installId() {
        return this.encodeAddonName();
    }

    @Override
    public String getListDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s%2$s", ld, this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("%1$s%2$s", this.getDisplayName(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getShortDescription() {
        String ld = this.getListDisplay();
        if (!ld.isEmpty()) {
            return String.format("%1$s, revision %2$s%3$s", ld, this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
        }
        return String.format("%1$s, Android API %2$s, revision %3$s%4$s", this.getDisplayName(), this.mVersion.getApiString(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "");
    }

    @Override
    public String getLongDescription() {
        String s = String.format("%1$s, Android API %2$s, revision %3$s%4$s\nBy %5$s", this.getDisplayName(), this.mVersion.getApiString(), this.getRevision().toShortString(), this.isObsolete() ? " (Obsolete)" : "", this.getDisplayVendor());
        String d = this.getDescription();
        if (d != null && !d.isEmpty()) {
            s = s + '\n' + d;
        }
        s = s + String.format("\nRequires SDK Platform Android API %1$s", this.mVersion.getApiString());
        return s;
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File addons = new File(osSdkRoot, "add-ons");
        for (IAndroidTarget target : sdkManager.getTargets()) {
            if (target.isPlatform() || !target.getVersion().equals(this.mVersion) || (!target.getName().equals(this.getNameId()) || !target.getVendor().equals(this.getVendorId())) && (!target.getName().equals(this.getDisplayName()) || !target.getVendor().equals(this.getDisplayVendor()))) continue;
            return new File(target.getLocation());
        }
        String name = this.encodeAddonName();
        for (int i = 0; i < 100; ++i) {
            String name2 = i == 0 ? name : String.format("%s-%d", name, i);
            File folder = new File(addons, name2);
            if (folder.exists()) continue;
            return folder;
        }
        return null;
    }

    private String encodeAddonName() {
        String name = String.format("addon-%s-%s-%s", this.getNameId(), this.getVendorId(), this.mVersion.getApiString());
        name = name.toLowerCase(Locale.US);
        name = name.replaceAll("[^a-z0-9_-]+", "_");
        name = name.replaceAll("_+", "_");
        return name;
    }

    @Override
    public boolean sameItemAs(Package pkg) {
        if (pkg instanceof AddonPackage) {
            AddonPackage newPkg = (AddonPackage)pkg;
            if (this.getNameId().equals(newPkg.getNameId()) && this.getAndroidVersion().equals(newPkg.getAndroidVersion())) {
                if (this.getVendorId().equals(newPkg.getVendorId())) {
                    return true;
                }
                return this.getDisplayVendor().equals(newPkg.getDisplayVendor());
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mLayoutlibVersion == null ? 0 : this.mLayoutlibVersion.hashCode());
        result = 31 * result + Arrays.hashCode(this.mLibs);
        result = 31 * result + (this.mDisplayName == null ? 0 : this.mDisplayName.hashCode());
        result = 31 * result + (this.mVendorDisplay == null ? 0 : this.mVendorDisplay.hashCode());
        result = 31 * result + (this.mVersion == null ? 0 : this.mVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AddonPackage)) {
            return false;
        }
        AddonPackage other = (AddonPackage)obj;
        if (this.mLayoutlibVersion == null ? other.mLayoutlibVersion != null : !this.mLayoutlibVersion.equals(other.mLayoutlibVersion)) {
            return false;
        }
        if (!Arrays.equals(this.mLibs, other.mLibs)) {
            return false;
        }
        if (this.mNameId == null ? other.mNameId != null : !this.mNameId.equals(other.mNameId)) {
            return false;
        }
        if (this.mVendorId == null ? other.mVendorId != null : !this.mVendorId.equals(other.mVendorId)) {
            return false;
        }
        return !(this.mVersion == null ? other.mVersion != null : !this.mVersion.equals(other.mVersion));
    }

    @Override
    protected String comparisonKey() {
        String s = super.comparisonKey();
        int pos = s.indexOf("|r:");
        assert (pos > 0);
        s = s.substring(0, pos) + "|vid:" + this.getVendorId() + "|nid:" + this.getNameId() + s.substring(pos);
        return s;
    }

    public static class Lib {
        private final String mName;
        private final String mDescription;

        public Lib(String name, String description) {
            this.mName = name;
            this.mDescription = description;
        }

        public String getName() {
            return this.mName;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mDescription == null ? 0 : this.mDescription.hashCode());
            result = 31 * result + (this.mName == null ? 0 : this.mName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Lib)) {
                return false;
            }
            Lib other = (Lib)obj;
            if (this.mDescription == null ? other.mDescription != null : !this.mDescription.equals(other.mDescription)) {
                return false;
            }
            return !(this.mName == null ? other.mName != null : !this.mName.equals(other.mName));
        }
    }
}

