/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.processing.ScopedException;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.JavaFileWriter;
import com.google.repacked.apache.commons.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DataBindingBuilder {
    Versions mVersions;
    private static final String EXCLUDE_PATTERN = "android/databinding/layouts/*.*";

    public String getCompilerVersion() {
        return this.getVersions().compiler;
    }

    public String getBaseLibraryVersion(String compilerVersion) {
        return this.getVersions().baseLibrary;
    }

    public String getLibraryVersion(String compilerVersion) {
        return this.getVersions().extensions;
    }

    public String getBaseAdaptersVersion(String compilerVersion) {
        return this.getVersions().extensions;
    }

    public void setPrintMachineReadableOutput(boolean machineReadableOutput) {
        ScopedException.encodeOutput(machineReadableOutput);
    }

    public boolean getPrintMachineReadableOutput() {
        return ScopedException.issEncodeOutput();
    }

    public void setDebugLogEnabled(boolean enableDebugLogs) {
        L.setDebugLog(enableDebugLogs);
    }

    public boolean isDebugLogEnabled() {
        return L.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Versions getVersions() {
        if (this.mVersions != null) {
            return this.mVersions;
        }
        try {
            Properties props = new Properties();
            InputStream stream = this.getClass().getResourceAsStream("/data_binding_version_info.properties");
            try {
                props.load(stream);
                this.mVersions = new Versions(props);
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        catch (IOException exception) {
            L.e(exception, "Cannot read data binding version", new Object[0]);
        }
        return this.mVersions;
    }

    public List<String> getJarExcludeList(LayoutXmlProcessor layoutXmlProcessor, File generatedClassListFile) {
        ArrayList<String> excludes = new ArrayList<String>();
        String appPkgAsClass = layoutXmlProcessor.getPackage().replace('.', '/');
        String infoClassAsClass = layoutXmlProcessor.getInfoClassFullName().replace('.', '/');
        excludes.add(infoClassAsClass + ".class");
        excludes.add(EXCLUDE_PATTERN);
        excludes.add(appPkgAsClass + "/BR.*");
        excludes.add("android/databinding/DynamicUtil.class");
        if (generatedClassListFile != null) {
            List<String> generatedClasses = this.readGeneratedClasses(generatedClassListFile);
            for (String klass2 : generatedClasses) {
                excludes.add(klass2.replace('.', '/') + ".class");
            }
        }
        Scope.assertNoError();
        return excludes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> readGeneratedClasses(File generatedClassListFile) {
        List<String> list;
        Preconditions.checkNotNull(generatedClassListFile, "Data binding exclude generated task is not configured properly", new Object[0]);
        Preconditions.check(generatedClassListFile.exists(), "Generated class list does not exist %s", generatedClassListFile.getAbsolutePath());
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(generatedClassListFile);
            list = IOUtils.readLines(fis);
        }
        catch (FileNotFoundException e) {
            L.e(e, "Unable to read generated class list from %s", generatedClassListFile.getAbsoluteFile());
            IOUtils.closeQuietly(fis);
        }
        catch (IOException e2) {
            L.e(e2, "Unexpected exception while reading %s", generatedClassListFile.getAbsoluteFile());
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fis);
        }
        IOUtils.closeQuietly(fis);
        return list;
        L.e("Could not read data binding generated class list", new Object[0]);
        return null;
    }

    public JavaFileWriter createJavaFileWriter(File outFolder) {
        return new GradleFileWriter(outFolder.getAbsolutePath());
    }

    private static class Versions {
        final String compilerCommon;
        final String compiler;
        final String baseLibrary;
        final String extensions;

        public Versions(Properties properties) {
            this.compilerCommon = properties.getProperty("compilerCommon");
            this.compiler = properties.getProperty("compiler");
            this.baseLibrary = properties.getProperty("baseLibrary");
            this.extensions = properties.getProperty("extensions");
            Preconditions.checkNotNull(this.compilerCommon, "cannot read compiler common version", new Object[0]);
            Preconditions.checkNotNull(this.compiler, "cannot read compiler version", new Object[0]);
            Preconditions.checkNotNull(this.baseLibrary, "cannot read baseLibrary version", new Object[0]);
            Preconditions.checkNotNull(this.extensions, "cannot read extensions version", new Object[0]);
        }
    }

    static class GradleFileWriter
    extends JavaFileWriter {
        private final String outputBase;

        public GradleFileWriter(String outputBase) {
            this.outputBase = outputBase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeToFile(String canonicalName, String contents) {
            String asPath = canonicalName.replace('.', '/');
            File f = new File(this.outputBase + "/" + asPath + ".java");
            f.getParentFile().mkdirs();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                IOUtils.write(contents, (OutputStream)fos);
            }
            catch (IOException e) {
                try {
                    L.e(e, "cannot write file " + f.getAbsolutePath(), new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly(fos);
            }
            IOUtils.closeQuietly(fos);
        }
    }
}

