/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TemplateParamsParser;
import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MapTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private final String myContainerName;

    public MapTypeNameFormatter(@NotNull String containerName) {
        if (containerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerName", "com/android/tools/ndk/run/lldb/renderers/formatters/libstdcpp/MapTypeNameFormatter", "<init>"));
        }
        this.myContainerName = containerName;
    }

    @Override
    public String format(@NotNull String input) {
        int numParams;
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/android/tools/ndk/run/lldb/renderers/formatters/libstdcpp/MapTypeNameFormatter", "format"));
        }
        ArrayList<String> templateParams = TemplateParamsParser.getTemplateParams(input);
        int n = numParams = templateParams == null ? 0 : templateParams.size();
        if (numParams < 2 || numParams > 4) {
            return input;
        }
        String keyType = templateParams.get(0);
        String keyTypeAngleBracketSpace = TemplateParamsParser.spaceBetweenAngleBracket(keyType);
        String elementType = templateParams.get(1);
        String elementTypeAngleBracketSpace = TemplateParamsParser.spaceBetweenAngleBracket(elementType);
        if (numParams >= 3 && !templateParams.get(2).contentEquals(String.format("std::less<%s%s>", keyType, keyTypeAngleBracketSpace))) {
            return input;
        }
        if (numParams == 4 && !templateParams.get(3).contentEquals(String.format("std::allocator<std::pair<const %s, %s%s> >", keyType, elementType, elementTypeAngleBracketSpace))) {
            return input;
        }
        TypeNameFormatterCategory.TypeNameFormatter keyTypeFormatter = TypeNameFormatterCategory.lookupTypeNameFormatter(keyType);
        TypeNameFormatterCategory.TypeNameFormatter elementTypeFormatter = TypeNameFormatterCategory.lookupTypeNameFormatter(elementType);
        return String.format("%s<%s, %s%s>", this.myContainerName, keyTypeFormatter != null ? keyTypeFormatter.format(keyType) : keyType, elementTypeFormatter != null ? elementTypeFormatter.format(elementType) : elementType, elementTypeAngleBracketSpace);
    }
}

