/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateParamsParser {
    @NotNull
    public static String spaceBetweenAngleBracket(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/android/tools/ndk/run/lldb/renderers/TemplateParamsParser", "spaceBetweenAngleBracket"));
        }
        if (typeName.endsWith(">")) {
            if (" " == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/renderers/TemplateParamsParser", "spaceBetweenAngleBracket"));
            }
            return " ";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/renderers/TemplateParamsParser", "spaceBetweenAngleBracket"));
        }
        return "";
    }

    @Nullable
    public static ArrayList<String> getTemplateParams(@NotNull String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/android/tools/ndk/run/lldb/renderers/TemplateParamsParser", "getTemplateParams"));
        }
        if (!typeName.endsWith(">")) {
            return null;
        }
        int l = typeName.length();
        int angleBracketCount = 0;
        int paramStart = l - 2;
        for (int i = l - 1; i >= 0; --i) {
            char c = typeName.charAt(i);
            if (c == '>') {
                ++angleBracketCount;
            }
            if (c == '<') {
                --angleBracketCount;
            }
            if (angleBracketCount != 0) continue;
            paramStart = i + 1;
            break;
        }
        if (angleBracketCount != 0) {
            return null;
        }
        String paramString = typeName.substring(paramStart, l - 1);
        ArrayList<String> list = new ArrayList<String>();
        String param = "";
        angleBracketCount = 0;
        int parenCount = 0;
        for (int i = 0; i < paramString.length(); ++i) {
            char c = paramString.charAt(i);
            switch (c) {
                case '<': {
                    ++angleBracketCount;
                    break;
                }
                case '>': {
                    --angleBracketCount;
                    break;
                }
                case '(': {
                    ++parenCount;
                    break;
                }
                case ')': {
                    --parenCount;
                    break;
                }
            }
            if (angleBracketCount == 0 && parenCount == 0 && c == ',') {
                list.add(param.trim());
                param = "";
                continue;
            }
            param = param + c;
        }
        if (param.length() > 0) {
            list.add(param.trim());
        }
        return list;
    }
}

