/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.FutureResult;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public abstract class SessionStarter {
    private static final Logger LOG = Logger.getInstance(SessionStarter.class);
    protected final JdwpConnector myJdwpConnector;
    protected final Client myClient;
    protected final NativeAndroidDebuggerState myDebuggerState;
    private final String myPlatformSocketName;
    protected final AttachProgressReporter myProgressReporter;
    protected final ProcessHandlerLaunchStatus myLaunchStatus;
    protected final ConsolePrinter myPrinter;
    protected final File myLocalServerFile;
    protected final File myLocalStartScriptFile;
    protected FileStat myServerTempFile;
    protected FileStat myStartScriptTempFile;

    protected SessionStarter(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AttachProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws com.intellij.execution.ExecutionException {
        if (jdwpConnector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdwpConnector", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        if (localServerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localServerFile", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        if (localStartScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localStartScriptFile", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        if (progressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressReporter", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/SessionStarter", "<init>"));
        }
        this.myJdwpConnector = jdwpConnector;
        this.myClient = client;
        this.myDebuggerState = debuggerState;
        this.myPlatformSocketName = String.format("platform-%d.sock", System.currentTimeMillis());
        this.myProgressReporter = progressReporter;
        this.myLaunchStatus = launchStatus;
        this.myPrinter = printer;
        this.myLocalServerFile = localServerFile;
        this.myLocalStartScriptFile = localStartScriptFile;
    }

    public void pushFilesToDevice() throws com.intellij.execution.ExecutionException {
        SyncService syncService = null;
        try {
            syncService = this.myClient.getDevice().getSyncService();
            if (syncService == null) {
                throw new com.intellij.execution.ExecutionException("Failed to get SyncService");
            }
            this.myServerTempFile = this.pushDebuggerFile(syncService, this.myLocalServerFile);
            this.myStartScriptTempFile = this.pushDebuggerFile(syncService, this.myLocalStartScriptFile);
        }
        catch (Exception e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        finally {
            if (syncService != null) {
                syncService.close();
            }
        }
    }

    protected void connectJdwp() throws com.intellij.execution.ExecutionException {
        final FutureResult connectResult = new FutureResult();
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    SessionStarter.this.myJdwpConnector.Connect();
                    connectResult.set(null);
                }
                catch (com.intellij.execution.ExecutionException e) {
                    connectResult.setException((Throwable)e);
                }
            }
        }, ModalityState.defaultModalityState());
        try {
            connectResult.get();
        }
        catch (InterruptedException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof com.intellij.execution.ExecutionException) {
                throw (com.intellij.execution.ExecutionException)cause;
            }
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }

    public String startServer() throws com.intellij.execution.ExecutionException {
        String startCmd = this.getStartCommandLine();
        LOG.info("Starting LLDB server: " + startCmd);
        this.myProgressReporter.step("Starting LLDB server");
        this.myPrinter.stdout("Starting LLDB server: " + startCmd);
        this.internalStartServer();
        return this.getConnectUrl();
    }

    protected abstract void internalStartServer() throws com.intellij.execution.ExecutionException;

    public abstract void resumeVm() throws com.intellij.execution.ExecutionException;

    @NotNull
    protected String getStartCommandLine() {
        String string = String.format("%s %s %s %s %s \"%s\"", this.getStartScriptTargetPath(), this.getTargetRootDirectory(), "unix-abstract", this.getTargetSocketDirectory(), this.myPlatformSocketName, this.myDebuggerState.getTargetLoggingChannels());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getStartCommandLine"));
        }
        return string;
    }

    @NotNull
    protected String getConnectUrl() {
        String string = String.format("%s-connect://[%s]%s/%s", "unix-abstract", this.myClient.getDevice().getSerialNumber(), this.getTargetSocketDirectory(), this.myPlatformSocketName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getConnectUrl"));
        }
        return string;
    }

    @NotNull
    protected String getTargetDataDir() {
        String string = this.myClient.getClientData().getDataDir();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getTargetDataDir"));
        }
        return string;
    }

    @NotNull
    protected String getTargetRootDirectory() {
        String string = SessionStarter.joinPaths(this.getTargetDataDir(), "lldb");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getTargetRootDirectory"));
        }
        return string;
    }

    @NotNull
    protected String getTargetBinDirectory() {
        String string = SessionStarter.joinPaths(this.getTargetRootDirectory(), "bin");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getTargetBinDirectory"));
        }
        return string;
    }

    @NotNull
    protected String getTargetBinFilePath(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/ndk/run/lldb/SessionStarter", "getTargetBinFilePath"));
        }
        String string = SessionStarter.joinPaths(this.getTargetBinDirectory(), filePath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getTargetBinFilePath"));
        }
        return string;
    }

    @NotNull
    protected String getStartScriptTargetPath() {
        String string = this.getTargetBinFilePath("start_lldb_server.sh");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getStartScriptTargetPath"));
        }
        return string;
    }

    @NotNull
    protected String getTargetSocketDirectory() {
        String string = SessionStarter.joinPaths(this.getTargetRootDirectory(), "tmp");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getTargetSocketDirectory"));
        }
        return string;
    }

    @NotNull
    protected static String joinPaths(String ... paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/android/tools/ndk/run/lldb/SessionStarter", "joinPaths"));
        }
        String string = StringUtil.join((String[])paths, (String)"/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "joinPaths"));
        }
        return string;
    }

    @NotNull
    private FileStat pushDebuggerFile(@NotNull SyncService syncService, @NotNull File localFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        if (syncService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncService", "com/android/tools/ndk/run/lldb/SessionStarter", "pushDebuggerFile"));
        }
        if (localFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localFile", "com/android/tools/ndk/run/lldb/SessionStarter", "pushDebuggerFile"));
        }
        IDevice device = this.myClient.getDevice();
        String fileName = localFile.getName();
        String tmpDestFile = SessionStarter.joinPaths("/data/local/tmp", fileName);
        Date localFileLmt = new Date(localFile.lastModified() / 1000L * 1000L);
        SyncService.FileStat destFileStat = syncService.statFile(tmpDestFile);
        if (destFileStat == null || destFileStat.getMode() == 0 || !localFileLmt.equals(destFileStat.getLastModified()) || localFile.length() != (long)destFileStat.getSize()) {
            LOG.info("Pushing to the device: " + localFile + " => " + tmpDestFile);
            device.pushFile(localFile.getAbsolutePath(), tmpDestFile);
        } else {
            LOG.info("Remote file " + tmpDestFile + " is up-to-date.");
        }
        FileStat fileStat = new FileStat(tmpDestFile, destFileStat == null ? 0L : destFileStat.getLastModified().getTime());
        if (fileStat == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "pushDebuggerFile"));
        }
        return fileStat;
    }

    @NotNull
    public JdwpConnector getJdwpConnector() {
        JdwpConnector jdwpConnector = this.myJdwpConnector;
        if (jdwpConnector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter", "getJdwpConnector"));
        }
        return jdwpConnector;
    }

    protected static class FileStat {
        private final String myFilePath;
        private final long myLastModified;

        public FileStat(@NotNull String filePath, long lastModified) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/android/tools/ndk/run/lldb/SessionStarter$FileStat", "<init>"));
            }
            this.myFilePath = filePath;
            this.myLastModified = lastModified;
        }

        @NotNull
        public String getFilePath() {
            String string = this.myFilePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/SessionStarter$FileStat", "getFilePath"));
            }
            return string;
        }

        public long getLastModified() {
            return this.myLastModified;
        }
    }
}

