/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class RootSessionStarterImpl
extends SessionStarter {
    private static final Logger LOG = Logger.getInstance(RootSessionStarterImpl.class);

    public RootSessionStarterImpl(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AttachProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (jdwpConnector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdwpConnector", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        if (localServerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localServerFile", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        if (localStartScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localStartScriptFile", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        if (progressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressReporter", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "<init>"));
        }
        super(jdwpConnector, client, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
    }

    @Override
    public void internalStartServer() throws ExecutionException {
        try {
            this.executeCommand(this.getClientCommand("mkdir " + this.getTargetRootDirectory() + " " + this.getTargetBinDirectory()), 5L, TimeUnit.SECONDS);
            this.copyFileToTargetBinDirectory(this.myServerTempFile.getFilePath());
            this.copyFileToTargetBinDirectory(this.myStartScriptTempFile.getFilePath());
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String output = RootSessionStarterImpl.this.executeCommand(RootSessionStarterImpl.this.getClientCommand(RootSessionStarterImpl.this.getStartCommandLine()), 0L, TimeUnit.DAYS);
                        LOG.info("LLDB server has exited: " + output);
                    }
                    catch (Exception e) {
                        LOG.error("LLDB server has failed: ", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String executeCommand(@NotNull String command, long maxTimeToOutputResponse, TimeUnit timeUnit) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException, AndroidNativeDeviceException {
        void maxTimeUnits;
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "executeCommand"));
        }
        ErrorMatchingReceiver receiver = new ErrorMatchingReceiver((LaunchStatus)this.myLaunchStatus);
        this.myClient.getDevice().executeShellCommand(command, (IShellOutputReceiver)receiver, maxTimeToOutputResponse, (TimeUnit)maxTimeUnits);
        String string = receiver.getOutput().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "executeCommand"));
        }
        return string;
    }

    @NotNull
    protected String getClientCommand(@NotNull String command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "getClientCommand"));
        }
        String string = command;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "getClientCommand"));
        }
        return string;
    }

    private void copyFileToTargetBinDirectory(@NotNull String tmpDeviceFile) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        if (tmpDeviceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tmpDeviceFile", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "copyFileToTargetBinDirectory"));
        }
        String fileName = new File(tmpDeviceFile).getName();
        String destFile = RootSessionStarterImpl.joinPaths(this.getTargetBinDirectory(), fileName);
        String copyChmodCommand = "cat " + tmpDeviceFile + " | " + this.getClientCommand(String.format("sh -c 'cat > %s && chmod 700 %s'", destFile, destFile));
        LOG.info("Copying to app folder: " + tmpDeviceFile + " => " + destFile);
        LOG.info("Command: " + copyChmodCommand);
        if (!ShellCommandLauncher.execute((String)copyChmodCommand, (IDevice)this.myClient.getDevice(), (LaunchStatus)this.myLaunchStatus, (ConsolePrinter)this.myPrinter, (long)60L, (TimeUnit)TimeUnit.SECONDS)) {
            throw new IOException("Command failed: " + copyChmodCommand);
        }
    }

    @Override
    public void resumeVm() throws ExecutionException {
        this.connectJdwp();
    }

    @Override
    @NotNull
    protected String getTargetDataDir() {
        if ("/data/local/tmp" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/RootSessionStarterImpl", "getTargetDataDir"));
        }
        return "/data/local/tmp";
    }
}

