/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.tools.idea.stats.UsageTracker;
import com.android.tools.ndk.run.AndroidNativeDeviceException;
import com.google.common.collect.ImmutableSet;
import com.intellij.internal.statistic.analytics.AnalyticsUploader;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEntityNotValidException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBUsageTracker {
    private static final ImmutableSet<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableSet.of(AndroidNativeDeviceException.class, LLDBEntityNotValidException.class);

    private static void trackEvent(@NotNull String eventAction, @Nullable String eventLabel) {
        if (eventAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventAction", "com/android/tools/ndk/run/lldb/LLDBUsageTracker", "trackEvent"));
        }
        UsageTracker.getInstance().trackEvent("lldb", eventAction, eventLabel, null);
    }

    @Nullable
    private static String getExceptionDescription(@Nullable Throwable e) {
        if (e == null) {
            return null;
        }
        Throwable cause = e.getCause();
        Throwable throwable = cause = cause != null ? cause : e;
        if (THROWABLE_CLASSES_TO_TRACK_MESSAGES.contains(cause.getClass())) {
            return cause.getMessage();
        }
        return AnalyticsUploader.getDescription((Throwable)cause);
    }

    public static void trackDeviceModel(@NotNull String deviceModel) {
        if (deviceModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceModel", "com/android/tools/ndk/run/lldb/LLDBUsageTracker", "trackDeviceModel"));
        }
        LLDBUsageTracker.trackEvent("ro.product.model", deviceModel);
    }

    public static void trackDeviceAPILevel(@NotNull String deviceAPILevel) {
        if (deviceAPILevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceAPILevel", "com/android/tools/ndk/run/lldb/LLDBUsageTracker", "trackDeviceAPILevel"));
        }
        LLDBUsageTracker.trackEvent("ro.build.version.sdk", deviceAPILevel);
    }

    public static void trackSessionStarted(@NotNull String configName) {
        if (configName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configName", "com/android/tools/ndk/run/lldb/LLDBUsageTracker", "trackSessionStarted"));
        }
        LLDBUsageTracker.trackEvent("sessionStarted", configName);
    }

    public static void trackSessionFailed(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/ndk/run/lldb/LLDBUsageTracker", "trackSessionFailed"));
        }
        LLDBUsageTracker.trackEvent("sessionFailed", LLDBUsageTracker.getExceptionDescription(e));
    }

    public static void trackInstallStarted() {
        LLDBUsageTracker.trackEvent("installStarted", null);
    }

    public static void trackInstallFailed(@Nullable Throwable e) {
        LLDBUsageTracker.trackEvent("installFailed", LLDBUsageTracker.getExceptionDescription(e));
    }

    public static void trackSessionUsedWatchpoints() {
        LLDBUsageTracker.trackEvent("sessionUsedWatchpoints", null);
    }
}

