/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.CodeInjection;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class InjectorSessionStarterImpl
extends SessionStarter {
    private CodeInjection myCodeInjection;

    public InjectorSessionStarterImpl(@NotNull JdwpConnector jdwpConnector, @NotNull Client client, @NotNull File localServerFile, @NotNull File localStartScriptFile, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AttachProgressReporter progressReporter, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (jdwpConnector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdwpConnector", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        if (localServerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localServerFile", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        if (localStartScriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localStartScriptFile", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        if (progressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressReporter", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/InjectorSessionStarterImpl", "<init>"));
        }
        super(jdwpConnector, client, localServerFile, localStartScriptFile, debuggerState, progressReporter, launchStatus, printer);
    }

    @Override
    public void pushFilesToDevice() throws ExecutionException {
        super.pushFilesToDevice();
        String lldbServerTempPath = this.myServerTempFile.getFilePath();
        String lldbServerAppPath = this.getTargetBinFilePath(this.myLocalServerFile.getName());
        String startLldbServerTempPath = this.myStartScriptTempFile.getFilePath();
        String startLldbServerAppPath = this.getStartScriptTargetPath();
        StringBuilder codeFragment = new StringBuilder().append("java.io.File lldbBinDir = new java.io.File(\"" + this.getTargetBinDirectory() + "\");\n").append("lldbBinDir.mkdirs();\n").append("java.io.File serverFile = new java.io.File(\"").append(lldbServerAppPath).append("\");");
        if (this.myServerTempFile.getLastModified() > 0L) {
            codeFragment.append("if (!(serverFile.exists() && serverFile.lastModified()>=").append(this.myServerTempFile.getLastModified()).append("L))");
        }
        codeFragment.append("{\n").append("java.lang.ProcessBuilder pb1 = new java.lang.ProcessBuilder(\"sh\", \"-c\",\"cat " + lldbServerTempPath + ">" + lldbServerAppPath + " && chmod 700 " + lldbServerAppPath + ";\");\n").append("pb1.directory(lldbBinDir);\n").append("pb1.start().waitFor();\n").append("}\n").append("java.io.File startScriptFile = new java.io.File(\"").append(startLldbServerAppPath).append("\");");
        if (this.myStartScriptTempFile.getLastModified() > 0L) {
            codeFragment.append("if (!(startScriptFile.exists() && startScriptFile.lastModified()>=").append(this.myStartScriptTempFile.getLastModified()).append("L))");
        }
        codeFragment.append("{\n").append("java.lang.ProcessBuilder pb2 = new java.lang.ProcessBuilder(\"sh\", \"-c\",\"cat " + startLldbServerTempPath + ">" + startLldbServerAppPath + " && chmod 700 " + startLldbServerAppPath + ";\");\n").append("pb2.directory(lldbBinDir);\n").append("pb2.start().waitFor();\n").append("}\n").append("java.lang.ProcessBuilder pb3 = new java.lang.ProcessBuilder(\"sh\", \"-c\",\"" + StringUtil.escapeQuotes((String)this.getStartCommandLine()) + "\");\n").append("pb3.directory(lldbBinDir);\n").append("pb3.start();\n");
        this.myCodeInjection = this.myJdwpConnector.injectCodeFragment(codeFragment.toString());
    }

    @Override
    protected void internalStartServer() throws ExecutionException {
        this.connectJdwp();
        ProcessHandler processHandler = this.myLaunchStatus.getProcessHandler();
        ProcessAdapter processListener = new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                super.processTerminated(event);
                InjectorSessionStarterImpl.this.myCodeInjection.cancel();
            }
        };
        try {
            processHandler.addProcessListener((ProcessListener)processListener);
            this.myCodeInjection.waitForInjection();
        }
        finally {
            processHandler.removeProcessListener((ProcessListener)processListener);
        }
    }

    @Override
    public void resumeVm() {
        this.myCodeInjection.resume();
    }
}

