/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.InjectorSessionStarterImpl;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.RootSessionStarterImpl;
import com.android.tools.ndk.run.lldb.RunAsSessionStarterImpl;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.Lists;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunner;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectLLDBTask
extends ConnectDebuggerTask {
    private static final Logger LOG = Logger.getInstance(ConnectLLDBTask.class);
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    protected final NativeAndroidDebuggerState myDebuggerState;
    @NotNull
    private final String myRunConfigTypeId;
    @NotNull
    private final NativeAndroidDebugger myNativeDebugger;
    protected AttachProgressReporter myAttachProgressReporter;
    protected JdwpConnector myJdwpConnector;
    private SessionStarter mySessionStarter;

    public ConnectLLDBTask(@NotNull ExecutionEnvironment env, @NotNull Set<String> applicationIds, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState state, @NotNull NativeAndroidDebugger debugger, @NotNull String runConfigTypeId) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "<init>"));
        }
        if (applicationIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationIds", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "<init>"));
        }
        if (debugger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugger", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "<init>"));
        }
        if (runConfigTypeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfigTypeId", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "<init>"));
        }
        super(applicationIds, (AndroidDebugger)debugger, facet.getModule().getProject());
        this.myEnv = env;
        this.myFacet = facet;
        this.myDebuggerState = state;
        this.myRunConfigTypeId = runConfigTypeId;
        this.myNativeDebugger = debugger;
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "isReadyForDebugging"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "isReadyForDebugging"));
        }
        return super.isReadyForDebugging(client, printer) && client.isDdmAware();
    }

    protected boolean isDetachOnStop() {
        return false;
    }

    @Nullable
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        if (currentLaunchInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentLaunchInfo", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "launchDebugger"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "launchDebugger"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "launchDebugger"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "launchDebugger"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myAttachProgressReporter = new AttachProgressReporter(this.myEnv.getProject());
        LLDBUsageTracker.trackSessionStarted(this.getPrettyConfigurationName());
        IDevice device = client.getDevice();
        String deviceModel = device.getProperty("ro.product.model");
        String deviceAPILevel = device.getProperty("ro.build.version.sdk");
        String deviceCodename = device.getProperty("ro.build.version.codename");
        String deviceManufacturer = device.getProperty("ro.product.manufacturer");
        LLDBUsageTracker.trackDeviceAPILevel(deviceAPILevel);
        LLDBUsageTracker.trackDeviceModel(deviceModel);
        LOG.info(String.format("Launching native debug session on device: manufacturer=%s, model=%s, API=%s, codename=%s, ABIs=%s", deviceManufacturer, deviceModel, deviceAPILevel, deviceCodename, device.getAbis().toString()));
        try {
            this.myJdwpConnector = new JdwpConnector(currentLaunchInfo, client);
            this.prepareSessionStarter(client, launchStatus, (ConsolePrinter)printer);
        }
        catch (Throwable e) {
            this.onLaunchFailure((LaunchStatus)launchStatus, client, "Error while launching debug server on device: " + e.toString(), e);
            return null;
        }
        try {
            return this.launchCidrDebugger(client, launchStatus, printer);
        }
        catch (Throwable e) {
            this.onLaunchFailure((LaunchStatus)launchStatus, client, "Error while starting native debug session: " + e.toString(), e);
            return null;
        }
    }

    private void prepareSessionStarter(@NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException, ExecutionException {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "prepareSessionStarter"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "prepareSessionStarter"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "prepareSessionStarter"));
        }
        List<Abi> abis = ConnectLLDBTask.getClientABIs(client);
        AndroidNativeDebugProcess.verifyNativeModel(this.myFacet, abis, printer);
        File lldbServer = ConnectLLDBTask.findLLDBServer(this.myFacet, this.myDebuggerState, abis);
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            throw new IllegalStateException("LLDB server not found");
        }
        LOG.info(String.format("Found LLDB server: \"%s\"", lldbServer.getAbsolutePath()));
        File startServerScript = ModulePathManager.getSdkLLDBAndroidFile("start_lldb_server.sh");
        this.mySessionStarter = this.newSessionStarter(client, lldbServer, startServerScript, launchStatus, printer);
    }

    @NotNull
    protected SessionStarter newSessionStarter(@NotNull Client client, @NotNull File serverPath, @NotNull File startScriptPath, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ConsolePrinter printer) throws ExecutionException {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
        }
        if (serverPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverPath", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
        }
        if (startScriptPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startScriptPath", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
        }
        if (ConnectLLDBTask.isRootedDevice(client.getDevice())) {
            RootSessionStarterImpl rootSessionStarterImpl = new RootSessionStarterImpl(this.myJdwpConnector, client, serverPath, startScriptPath, this.myDebuggerState, this.myAttachProgressReporter, launchStatus, printer);
            if (rootSessionStarterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
            }
            return rootSessionStarterImpl;
        }
        if (ConnectLLDBTask.isRunAsOK(client)) {
            RunAsSessionStarterImpl runAsSessionStarterImpl = new RunAsSessionStarterImpl(this.myJdwpConnector, client, serverPath, startScriptPath, this.myDebuggerState, this.myAttachProgressReporter, launchStatus, printer);
            if (runAsSessionStarterImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
            }
            return runAsSessionStarterImpl;
        }
        InjectorSessionStarterImpl injectorSessionStarterImpl = new InjectorSessionStarterImpl(this.myJdwpConnector, client, serverPath, startScriptPath, this.myDebuggerState, this.myAttachProgressReporter, launchStatus, printer);
        if (injectorSessionStarterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "newSessionStarter"));
        }
        return injectorSessionStarterImpl;
    }

    private static boolean isRunAsOK(@NotNull Client client) throws ExecutionException {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "isRunAsOK"));
        }
        try {
            ClientShellHelper shellHelper = new ClientShellHelper(client);
            IDevice device = client.getDevice();
            String deviceModel = device.getProperty("ro.product.model");
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            client.getDevice().executeShellCommand(shellHelper.getRunAsCommand(String.format("getprop %s", "ro.product.model")), (IShellOutputReceiver)receiver);
            return receiver.getOutput().trim().equals(deviceModel);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    protected static boolean isRootedDevice(@NotNull IDevice device) throws ExecutionException {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "isRootedDevice"));
        }
        try {
            return device.isRoot();
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private static int getClientAddressByteSize(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getClientAddressByteSize"));
        }
        String abi = client.getClientData().getAbi();
        if (abi != null && abi.startsWith("64-bit")) {
            return 8;
        }
        return 4;
    }

    @Nullable
    private static File findLLDBServer(@NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "findLLDBServer"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "findLLDBServer"));
        }
        if (abis == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abis", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "findLLDBServer"));
        }
        File foundServerFile = null;
        for (Abi abi : abis) {
            File serverFile = ConnectLLDBTask.getServerFileByAbi(abi);
            if (serverFile != null) {
                foundServerFile = serverFile;
            }
            if (AndroidNativeDebugProcess.getSymbolsDir(facet, debuggerState, Collections.singletonList(abi)).isEmpty()) continue;
            return serverFile;
        }
        return foundServerFile;
    }

    @Nullable
    private static File getServerFileByAbi(@NotNull Abi abi) {
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getServerFileByAbi"));
        }
        File lldbServerFile = ConnectLLDBTask.getAndroidLLDBBinFile(abi);
        if (lldbServerFile.exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = ConnectLLDBTask.getAndroidLLDBBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    @NotNull
    private static File getAndroidLLDBBinFile(Abi abi) {
        File file = ModulePathManager.getSdkLLDBAndroidFile(new File(abi.toString(), "lldb-server").getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getAndroidLLDBBinFile"));
        }
        return file;
    }

    @NotNull
    private static List<Abi> getClientABIs(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getClientABIs"));
        }
        int clientAddrByteSize = ConnectLLDBTask.getClientAddressByteSize(client);
        if (clientAddrByteSize <= 0) {
            LOG.warn("Failed to get client address byte size from ABI: " + client.getClientData().getAbi());
        }
        LinkedList abis = Lists.newLinkedList();
        IDevice device = client.getDevice();
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null) {
                LOG.warn("Failed to get abi by name: " + abiStr);
                continue;
            }
            if (clientAddrByteSize > 0) {
                if (abi.getAddressSizeInBytes() != clientAddrByteSize) continue;
                abis.add(abi);
                continue;
            }
            abis.add(abi);
        }
        LOG.info("ABIs supported by app: " + ((Object)abis).toString());
        LinkedList linkedList = abis;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getClientABIs"));
        }
        return linkedList;
    }

    private ProcessHandler launchCidrDebugger(final @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, final @NotNull ProcessHandlerConsolePrinter printer) throws ExecutionException {
        XDebugSessionImpl xDebugSession;
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "launchCidrDebugger"));
        }
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "launchCidrDebugger"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "launchCidrDebugger"));
        }
        final IDevice device = client.getDevice();
        final RunParameters runParameters = new RunParameters(){

            @NotNull
            public Installer getInstaller() {
                TrivialInstaller trivialInstaller = new TrivialInstaller(new GeneralCommandLine());
                if (trivialInstaller == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$1", "getInstaller"));
                }
                return trivialInstaller;
            }

            @NotNull
            public DebuggerDriverConfiguration getDebuggerDriverConfiguration() {
                AndroidLLDBDriverConfiguration androidLLDBDriverConfiguration = new AndroidLLDBDriverConfiguration(ConnectLLDBTask.this.myEnv.getProject(), ConnectLLDBTask.this.myFacet, ConnectLLDBTask.this.myDebuggerState, (ConsolePrinter)printer, device, ConnectLLDBTask.this.mySessionStarter, null, ConnectLLDBTask.this.getPostAttachCommands(client, printer), ConnectLLDBTask.this.myAttachProgressReporter);
                if (androidLLDBDriverConfiguration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$1", "getDebuggerDriverConfiguration"));
                }
                return androidLLDBDriverConfiguration;
            }

            public boolean isWaitFor() {
                return false;
            }

            @NotNull
            public String getArchitectureId() {
                String string = NdkHelper.getArchitectureId(NdkHelper.getAbi(device));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$1", "getArchitectureId"));
                }
                return string;
            }
        };
        CidrCommandLineState cidrState = new CidrCommandLineState(this.myEnv, new CidrLauncher(){

            public ProcessHandler startProcess(@NotNull CommandLineState state) throws ExecutionException {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$2", "startProcess"));
                }
                throw new RuntimeException("start process not implemented");
            }

            public XDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$2", "startDebugProcess"));
                }
                if (session == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$2", "startDebugProcess"));
                }
                AndroidNativeDebugProcess result = ConnectLLDBTask.this.myNativeDebugger.getAndroidNativeDebugProcess(device.getVersion(), ConnectLLDBTask.this.myEnv.getProject(), runParameters, session, state.getConsoleBuilder(), (ConsolePrinter)printer, ConnectLLDBTask.this.mySessionStarter, client, ConnectLLDBTask.this.myAttachProgressReporter, ConnectLLDBTask.this.isDetachOnStop());
                ProcessTerminatedListener.attach((ProcessHandler)result.getProcessHandler(), (Project)ConnectLLDBTask.this.myEnv.getProject());
                result.start();
                return result;
            }

            public ExecutionResult execute(@NotNull CommandLineState state, @NotNull Executor executor, @NotNull ProgramRunner runner, DefaultExecutionResult result) throws ExecutionException {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$2", "execute"));
                }
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$2", "execute"));
                }
                if (runner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$2", "execute"));
                }
                throw new RuntimeException("execute not implemented");
            }
        });
        printer.stdout("Now Launching Native Debug Session");
        this.myAttachProgressReporter.step("Launching debug session");
        CidrRunner cidrRunner = new CidrRunner(){

            @NotNull
            public String getRunnerId() {
                if ("AndroidNativeDebugRunner2" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask$3", "getRunnerId"));
                }
                return "AndroidNativeDebugRunner2";
            }
        };
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myEnv).executor(this.myEnv.getExecutor()).runner((ProgramRunner)cidrRunner).build();
        try {
            xDebugSession = (XDebugSessionImpl)cidrRunner.startDebugSession(cidrState, env, false, new XDebugSessionListener[0]);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
        xDebugSession.showSessionTab();
        ProcessHandler processHandler = launchStatus.getProcessHandler();
        assert (processHandler != null);
        ProcessHandler newProcessHandler = xDebugSession.getRunContentDescriptor().getProcessHandler();
        if (newProcessHandler == null) {
            throw new ExecutionException("Cannot start debugging - null process handler.");
        }
        launchStatus.setProcessHandler(newProcessHandler);
        processHandler.detachProcess();
        AndroidProcessText oldText = AndroidProcessText.get((ProcessHandler)processHandler);
        if (oldText != null) {
            oldText.printTo(newProcessHandler);
        }
        AndroidProcessText.attach((ProcessHandler)newProcessHandler);
        return newProcessHandler;
    }

    @NotNull
    private String getPrettyConfigurationName() {
        String string = this.myRunConfigTypeId + ":" + this.myDebugger.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getPrettyConfigurationName"));
        }
        return string;
    }

    private void onLaunchFailure(@NotNull LaunchStatus launchStatus, @NotNull Client client, @NotNull String message, @NotNull Throwable e) {
        if (launchStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchStatus", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "onLaunchFailure"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "onLaunchFailure"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "onLaunchFailure"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "onLaunchFailure"));
        }
        LOG.warn(message, e);
        launchStatus.terminateLaunch(message);
        LLDBUsageTracker.trackSessionFailed(e);
        this.myAttachProgressReporter.finish();
        ConnectLLDBTask.forceStopActivity(client);
    }

    private static void forceStopActivity(@NotNull Client client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "forceStopActivity"));
        }
        String packageName = client.getClientData().getClientDescription();
        try {
            IDevice device = client.getDevice();
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            device.executeShellCommand("am force-stop " + packageName, (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            LOG.info("Failed to force-stop activity " + packageName, (Throwable)e);
        }
    }

    @NotNull
    private List<String> getPostAttachCommands(@NotNull Client client, @NotNull ProcessHandlerConsolePrinter printer) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getPostAttachCommands"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getPostAttachCommands"));
        }
        List<String> list = this.myNativeDebugger.getPostAttachCommands(client, this.myFacet, printer);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/ConnectLLDBTask", "getPostAttachCommands"));
        }
        return list;
    }
}

