/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.editors.navigation.NavigationEditorUtils;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.crash.AndroidLLDBBreakpadIntegration;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.JavaCallSignature;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.LibStdCppTypeNameFormatters;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBEntityNotValidException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLLDBDriver
extends LLDBDriver {
    private static final String PLATFORM_NAME = "remote-android";
    private static final String ENV_VAR_PREFIX = "ANDROIDSTUDIO_LLDB_EXTRA_CMD_";
    private static final String[] STARTUP_SCRIPTS = new String[]{ModulePathManager.getRepoLLDBStlPrintersBinFile("load_script").getPath()};
    private static final int CONNECT_PLATFORM_NUM_RETRIES = 10;
    private static final int CONNECT_PLATFORM_TIMEOUT_MSECS = 500;
    private final List<File> mySymDirs;
    private final SessionStarter mySessionStarter;
    private String myPlatformConnectURL;
    private final List<String> myStartupCommands;
    @NotNull
    private final List<String> myPostAttachCommands;
    private final AttachProgressReporter myAttachProgressReporter;
    private final AndroidFacet myFacet;
    private boolean myCrashed;
    private final List<Abi> myDeviceABIs;
    private final boolean myDeviceSupportsWatchpoints;
    private static final Set<String> WATCHPOINT_WHITELISTED_MODELS = Sets.newHashSet((Object[])new String[]{"Nexus 9"});
    private static final Set<Abi> WATCHPOINT_WHITELISTED_ABIS = ImmutableSet.of((Object)Abi.X86, (Object)Abi.X86_64);
    private static final Set<Abi> ARM_ABIS = ImmutableSet.of((Object)Abi.ARMEABI, (Object)Abi.ARMEABI_V7A, (Object)Abi.ARM64_V8A);
    private boolean myReportedWatchpointsUsage;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDriver.class);

    public AndroidLLDBDriver(@NotNull DebuggerDriver.Handler handler, @NotNull AndroidFacet facet, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull AndroidLLDBDriverConfiguration configuration, @NotNull ConsolePrinter printer) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "<init>"));
        }
        if (debuggerState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerState", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "<init>"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "<init>"));
        }
        super(handler, (DebuggerDriverConfiguration)configuration);
        this.myCrashed = false;
        this.myReportedWatchpointsUsage = false;
        this.myFacet = facet;
        IDevice device = configuration.getDevice();
        this.mySessionStarter = configuration.getSessionStarter();
        this.myStartupCommands = configuration.getStartupCommands();
        this.myPostAttachCommands = configuration.getPostAttachCommands();
        this.myAttachProgressReporter = configuration.getAttachProgressReporter();
        this.myDeviceABIs = Lists.newArrayListWithExpectedSize((int)device.getAbis().size());
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi != null) {
                this.myDeviceABIs.add(abi);
                continue;
            }
            LOG.error("Failed to find ABI by name " + abiStr);
        }
        this.mySymDirs = AndroidNativeDebugProcess.getSymbolsDir(facet, debuggerState, this.myDeviceABIs);
        if (this.mySymDirs.isEmpty()) {
            LOG.warn("No symbol directories found");
            printer.stderr("Attention! No symbol directories found - please check your native debug configuration");
        }
        this.myDeviceSupportsWatchpoints = AndroidLLDBDriver.deviceSupportsWatchpoints(device);
    }

    protected void handleModulesLoaded(List<String> modules) {
        for (String module : modules) {
            this.myAttachProgressReporter.step("Loaded module: " + module);
        }
    }

    private static boolean deviceSupportsWatchpoints(@NotNull IDevice device) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "deviceSupportsWatchpoints"));
        }
        String model = device.getProperty("ro.product.model");
        if (WATCHPOINT_WHITELISTED_MODELS.contains(model)) {
            return true;
        }
        for (String abiStr : device.getAbis()) {
            Abi abi = Abi.getEnum((String)abiStr);
            if (abi == null || !WATCHPOINT_WHITELISTED_ABIS.contains(abi)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String getWatchpointWhitelist() {
        String string = String.format("%s based devices/emulators, %s", WATCHPOINT_WHITELISTED_ABIS, WATCHPOINT_WHITELISTED_MODELS);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "getWatchpointWhitelist"));
        }
        return string;
    }

    @Nullable
    Long getValueAddress(int threadId, int frameNumber, LLValue value) {
        String addrExpr = String.format("&%s", value.getReferenceExpression());
        try {
            LLValue addrValue = this.evaluate(threadId, frameNumber, addrExpr);
            return Long.decode(addrValue.getValue());
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to get address of %s: %s", value, e));
            return null;
        }
    }

    public void loadForRemote(File deviceSupport) throws ExecutionException {
        LOG.debug("Load startup scripts");
        this.loadStartupScripts();
        LOG.debug("run console commands from environment");
        this.runEnvCommands();
        this.runStartupCommands();
        LOG.debug("createEmptyTarget");
        this.createEmptyTarget();
        LOG.debug("connectPlatform");
        LLDBEntityNotValidException lastException = null;
        for (int i = 0; i < 10; ++i) {
            try {
                this.connectPlatform();
                lastException = null;
                break;
            }
            catch (LLDBEntityNotValidException e2) {
                lastException = e2;
                LOG.warn("failed to connect platform - retrying");
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        if (!this.mySymDirs.isEmpty()) {
            ArrayList searchPaths = Lists.newArrayListWithExpectedSize((int)this.mySymDirs.size());
            for (File symDir : this.mySymDirs) {
                searchPaths.add("\"" + symDir.getAbsolutePath() + "\"");
            }
            String searchPathsStr = StringUtil.join((Collection)searchPaths, (String)" ");
            LOG.info("Set target.exec-search-paths: " + searchPathsStr);
            this.executeConsoleCommand("settings set target.exec-search-paths " + searchPathsStr);
        }
    }

    private void runStartupCommands() throws ExecutionException {
        if (this.myStartupCommands == null) {
            return;
        }
        for (String cmd : this.myStartupCommands) {
            LOG.info("Startup command: " + cmd);
            this.executeConsoleCommand(cmd);
        }
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    private void runEnvCommands() throws ExecutionException {
        String envCommand;
        int i = 0;
        while ((envCommand = System.getenv(ENV_VAR_PREFIX + i)) != null) {
            LOG.info("Environment command: " + envCommand);
            this.executeConsoleCommand(envCommand);
            ++i;
        }
    }

    private void loadStartupScripts() throws ExecutionException {
        for (String script : STARTUP_SCRIPTS) {
            LOG.info("Loading startup script: " + script);
            this.executeConsoleCommand("command source \"" + script + "\"");
        }
    }

    private void createEmptyTarget() throws ExecutionException {
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't create target");
        Protocol.CompositeRequest createTargetReq = ProtobufMessageFactory.createTarget((String)"", (String)"");
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)createTargetReq, Protocol.CreateTarget_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    private void connectPlatform() throws ExecutionException {
        if (this.myPlatformConnectURL == null) {
            this.myPlatformConnectURL = this.mySessionStarter.startServer();
        }
        LOG.info("Connecting to LLDB server: " + this.myPlatformConnectURL);
        LLDBDriver.ThrowIfNotValid responseHandler = new LLDBDriver.ThrowIfNotValid("Couldn't connect platform");
        Protocol.CompositeRequest connectPlatformReq = ProtobufMessageFactory.connectPlatform((String)PLATFORM_NAME, (String)this.myPlatformConnectURL);
        this.getProtobufClient().sendMessageAndWaitForReply((GeneratedMessage)connectPlatformReq, Protocol.ConnectPlatform_Res.class, (Consumer)responseHandler);
        responseHandler.throwIfNeeded();
    }

    public void start(@NotNull Installer installer, @NotNull String architecture, boolean isRemote) throws ExecutionException {
        if (installer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installer", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "start"));
        }
        if (architecture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "architecture", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "start"));
        }
        super.start(installer, architecture, isRemote);
        AndroidLLDBBreakpadIntegration.monitorForCrashes(this);
    }

    @NotNull
    protected File getSourceFile(final @NotNull Model.LLDBFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "getSourceFile"));
        }
        String sourceFile = frame.getFile();
        File sf = new File(frame.getFile());
        if (sf.isAbsolute()) {
            File file = sf;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "getSourceFile"));
            }
            return file;
        }
        IdeaSourceProvider srcProvider = this.myFacet.getMainIdeaSourceProvider();
        for (Collection srcDirs : Lists.newArrayList((Object[])new Collection[]{srcProvider.getJavaDirectories(), srcProvider.getJniDirectories()})) {
            File foundSrcFile = AndroidLLDBDriver.findSourceFile(srcDirs, sourceFile);
            if (foundSrcFile == null) continue;
            File file = foundSrcFile;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "getSourceFile"));
            }
            return file;
        }
        String psiMethodFilePath = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiMethod psiMethod = AndroidLLDBDriver.this.parseJavaCallSignature(frame.getFunction());
                if (psiMethod == null) {
                    return null;
                }
                try {
                    VirtualFile srcFile = psiMethod.getContainingFile().getVirtualFile();
                    if (srcFile != null) {
                        return srcFile.getCanonicalPath();
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                return null;
            }
        });
        if (psiMethodFilePath != null) {
            File file = new File(psiMethodFilePath);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "getSourceFile"));
            }
            return file;
        }
        File file = sf;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "getSourceFile"));
        }
        return file;
    }

    @Nullable
    private static File findSourceFile(@NotNull Collection<VirtualFile> srcDirs, @NotNull String relPath) {
        if (srcDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDirs", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "findSourceFile"));
        }
        if (relPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relPath", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "findSourceFile"));
        }
        for (VirtualFile srcDir : srcDirs) {
            VirtualFile childFile = srcDir.findFileByRelativePath(relPath);
            if (childFile == null) continue;
            return new File(childFile.getCanonicalPath());
        }
        return null;
    }

    @NotNull
    protected LLFrame newLLFrame(final @NotNull Model.LLDBFrame frame) {
        Pair location;
        int line;
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "newLLFrame"));
        }
        String sourceFile = frame.getFile();
        if (sourceFile != null && !sourceFile.isEmpty()) {
            sourceFile = this.getSourceFile(frame).getAbsolutePath();
        }
        if ((line = frame.getLine() - 1) < 0 && sourceFile != null && (location = (Pair)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Pair<String, Integer>>(){

            public Pair<String, Integer> compute() {
                PsiMethod psiMethod = AndroidLLDBDriver.this.parseJavaCallSignature(frame.getFunction());
                if (psiMethod == null) {
                    return null;
                }
                try {
                    VirtualFile srcFile = psiMethod.getContainingFile().getVirtualFile();
                    if (srcFile == null) {
                        return null;
                    }
                    Document document = FileDocumentManager.getInstance().getDocument(srcFile);
                    if (document == null) {
                        return null;
                    }
                    return Pair.create((Object)srcFile.getCanonicalPath(), (Object)document.getLineNumber(psiMethod.getTextOffset()));
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            }
        })) != null) {
            sourceFile = (String)location.getFirst();
            line = (Integer)location.getSecond();
        }
        LLFrame lLFrame = new LLFrame(frame.getNumber(), frame.getFunction(), sourceFile, line, frame.getPc(), AndroidLLDBDriver.convertLanguage((Model.Language)frame.getLanguage()));
        if (lLFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "newLLFrame"));
        }
        return lLFrame;
    }

    @Nullable
    private PsiMethod parseJavaCallSignature(@NotNull String callSignature) {
        if (callSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callSignature", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "parseJavaCallSignature"));
        }
        JavaCallSignature signature = JavaCallSignature.Parse(callSignature);
        if (signature == null) {
            return null;
        }
        PsiClass psiClass = NavigationEditorUtils.getPsiClass((Module)this.myFacet.getModule(), (String)signature.getClassName());
        if (psiClass == null) {
            return null;
        }
        for (PsiMethod psiMethod : psiClass.findMethodsByName(signature.getMethodName(), true)) {
            PsiParameterList paramList;
            if (!psiMethod.getReturnType().equalsToText(signature.getReturnType()) || (paramList = psiMethod.getParameterList()).getParametersCount() != signature.getParameterList().size()) continue;
            PsiParameter[] psiParams = paramList.getParameters();
            boolean equalParameterTypes = true;
            for (int i = 0; i < psiParams.length && equalParameterTypes; ++i) {
                equalParameterTypes = psiParams[i].getType().equalsToText(signature.getParameterList().get(i));
            }
            if (!equalParameterTypes) continue;
            return psiMethod;
        }
        return null;
    }

    public boolean isCrashed() {
        return this.myCrashed;
    }

    public void setCrashed(boolean crashed) {
        this.myCrashed = crashed;
    }

    @NotNull
    public LLWatchpoint addWatchpoint(int threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws ExecutionException, DBCannotSetBreakpointException {
        LLWatchpoint lLWatchpoint;
        if (!this.myDeviceSupportsWatchpoints) {
            throw new DBCannotSetBreakpointException("You are debugging on a device that is not known to support watchpoints - supported devices include " + AndroidLLDBDriver.getWatchpointWhitelist());
        }
        if (!this.myReportedWatchpointsUsage) {
            this.myReportedWatchpointsUsage = true;
            LLDBUsageTracker.trackSessionUsedWatchpoints();
        }
        try {
            lLWatchpoint = super.addWatchpoint(threadId, frameNumber, value, expr, lifetime, accessType);
        }
        catch (DBCannotSetBreakpointException e) {
            Long valueAddr;
            Abi abi;
            if (!this.myDeviceABIs.isEmpty() && ARM_ABIS.contains(abi = this.myDeviceABIs.get(0)) && (valueAddr = this.getValueAddress(threadId, frameNumber, value)) != null && valueAddr % (long)abi.getAddressSizeInBytes() != 0L) {
                throw new DBCannotSetBreakpointException(String.format("%s - unaligned watchpoints are not supported on ARM yet, try __attribute__((aligned(%d))) %s;", e.getMessage(), abi.getAddressSizeInBytes(), value.getName()));
            }
            throw e;
        }
        if (lLWatchpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/lldb/AndroidLLDBDriver", "addWatchpoint"));
        }
        return lLWatchpoint;
    }

    private boolean isTargetDead() {
        DebuggerDriver.TargetState targetState = this.getState();
        return targetState.equals((Object)DebuggerDriver.TargetState.EXITED) || targetState.equals((Object)DebuggerDriver.TargetState.FINISHED);
    }

    public void attachTo(int pid) throws ExecutionException {
        super.attachTo(pid);
        if (this.myPostAttachCommands != null) {
            LOG.info("Post attach commands: " + this.myPostAttachCommands);
            for (String cmd : this.myPostAttachCommands) {
                this.executeConsoleCommand(cmd);
            }
        }
    }

    public void detach() throws ExecutionException {
        if (this.isTargetDead()) {
            LOG.warn("Target is dead - skip detach request");
            return;
        }
        super.detach();
    }

    public boolean abort() throws ExecutionException {
        if (this.isTargetDead()) {
            LOG.warn("Target is dead - skip abort request");
            return false;
        }
        return super.abort();
    }

    static {
        LibStdCppTypeNameFormatters.register();
    }
}

