/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.jdwp;

import com.android.ddmlib.Client;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.ndk.run.jdwp.CodeInjection;
import com.android.tools.ndk.run.jdwp.CodeInjectionImpl;
import com.android.tools.ndk.run.jdwp.InstrumentationStopRequestor;
import com.google.common.collect.Lists;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JdwpConnector {
    private final LaunchInfo myLaunchInfo;
    private final Client myClient;
    private final List<CodeInjectionImpl> myCodeInjections;
    List<SessionListener> mySessionListeners;
    private static final Logger LOG = Logger.getInstance(JdwpConnector.class);

    public JdwpConnector(@NotNull LaunchInfo launchInfo, @NotNull Client client) {
        if (launchInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "launchInfo", "com/android/tools/ndk/run/jdwp/JdwpConnector", "<init>"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/jdwp/JdwpConnector", "<init>"));
        }
        this.myCodeInjections = Lists.newLinkedList();
        this.mySessionListeners = Lists.newLinkedList();
        this.myLaunchInfo = launchInfo;
        this.myClient = client;
    }

    public void Connect() throws ExecutionException {
        String debugPort = Integer.toString(this.myClient.getDebuggerListenPort());
        Project project = this.myLaunchInfo.env.getProject();
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        RemoteDebugProcessHandler debugProcessHandler = new RemoteDebugProcessHandler(project);
        AndroidDebugState st = new AndroidDebugState(project, (ProcessHandler)debugProcessHandler, connection, this.myLaunchInfo.consoleProvider);
        ExecutionEnvironment env = new ExecutionEnvironmentBuilder(this.myLaunchInfo.env).executor(this.myLaunchInfo.env.getExecutor()).build();
        DefaultDebugUIEnvironment debugUIEnv = new DefaultDebugUIEnvironment(env, (RunProfileState)st, st.getRemoteConnection(), false);
        DebugEnvironment modelEnvironment = debugUIEnv.getEnvironment();
        DebuggerManagerEx debuggerManager = DebuggerManagerEx.getInstanceEx((Project)project);
        DebuggerSession debuggerSession = debuggerManager.attachVirtualMachine(modelEnvironment);
        DebugProcessImpl debugProcess = debuggerSession.getProcess();
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            debuggerSession.dispose();
            throw new ExecutionException("Debug process has been detached");
        }
        if (!this.myCodeInjections.isEmpty()) {
            debugProcess.addDebugProcessListener((DebugProcessListener)new DebugProcessAdapterImplEx());
        }
        for (SessionListener sessionListener : this.getSessionListenersCopy()) {
            sessionListener.sessionCreated(debuggerSession, (DebugUIEnvironment)debugUIEnv);
        }
        if (!debugProcessHandler.isStartNotified()) {
            debugProcessHandler.startNotify();
        }
    }

    public CodeInjection injectCodeFragment(@NotNull String codeFragment) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/android/tools/ndk/run/jdwp/JdwpConnector", "injectCodeFragment"));
        }
        CodeInjectionImpl codeInjection = new CodeInjectionImpl(codeFragment);
        this.myCodeInjections.add(codeInjection);
        return codeInjection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCodeInjections(SuspendContextImpl suspendContext) {
        DebugProcessImpl dbgProcess = suspendContext.getDebugProcess();
        ThreadReferenceProxyImpl threadRefProxy = suspendContext.getThread();
        for (CodeInjectionImpl codeInjection : this.myCodeInjections) {
            FutureResult<Void> resultFuture = codeInjection.getResultFuture();
            LOG.info("Evaluating expression: " + codeInjection.getCodeFragment());
            Date startTime = new Date();
            XExpressionImpl expr = XExpressionImpl.fromText((String)codeInjection.getCodeFragment(), (EvaluationMode)EvaluationMode.CODE_FRAGMENT);
            TextWithImports text = TextWithImportsImpl.fromXExpression((XExpression)expr);
            WatchItemDescriptor descriptor = new WatchItemDescriptor(dbgProcess.getProject(), text);
            try {
                StackFrameProxyImpl stackFrameProxy = threadRefProxy.frame(0);
                EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, stackFrameProxy, null);
                descriptor.setContext(evaluationContext);
                LOG.info("Evaluation took " + (new Date().getTime() - startTime.getTime()) + " ms");
                EvaluateException exception = descriptor.getEvaluateException();
                if (exception != null && descriptor.getValue() == null) {
                    LOG.error("Failed to evaluate expression: " + exception.getMessage());
                    resultFuture.setException((Throwable)exception);
                    continue;
                }
                resultFuture.set(null);
            }
            catch (EvaluateException e) {
                LOG.error((Throwable)e);
                resultFuture.setException((Throwable)e);
            }
            finally {
                codeInjection.waitForResume();
            }
        }
    }

    @NotNull
    private synchronized List<SessionListener> getSessionListenersCopy() {
        ArrayList arrayList = Lists.newArrayList(this.mySessionListeners);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/jdwp/JdwpConnector", "getSessionListenersCopy"));
        }
        return arrayList;
    }

    public synchronized void addSessionListener(@NotNull SessionListener sessionListener) {
        if (sessionListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionListener", "com/android/tools/ndk/run/jdwp/JdwpConnector", "addSessionListener"));
        }
        this.mySessionListeners.add(sessionListener);
    }

    public synchronized void removeSessionListener(@NotNull SessionListener sessionListener) {
        if (sessionListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionListener", "com/android/tools/ndk/run/jdwp/JdwpConnector", "removeSessionListener"));
        }
        this.mySessionListeners.remove(sessionListener);
    }

    private class DebugProcessAdapterImplEx
    extends DebugProcessAdapterImpl {
        private DebugProcessAdapterImplEx() {
        }

        public void paused(SuspendContextImpl suspendContext) {
            LOG.info("Process is paused");
            DebugProcessImpl dbgProcess = suspendContext.getDebugProcess();
            dbgProcess.removeDebugProcessListener((DebugProcessListener)this);
            JdwpConnector.this.runCodeInjections(suspendContext);
            dbgProcess.getManagerThread().schedule((DebuggerCommandImpl)dbgProcess.createResumeCommand(suspendContext));
        }

        public void processAttached(DebugProcessImpl process) {
            LOG.info("Attached to process");
            List refs = process.getVirtualMachineProxy().classesByName(InstrumentationStopRequestor.CLASS_FILTER);
            if (refs.isEmpty()) {
                this.fail("Failed to find Instrumentation class in VM");
                return;
            }
            ClassType classClassType = (ClassType)refs.get(0);
            Method ctor = DebuggerUtils.findMethod((ReferenceType)classClassType, (String)"<init>", (String)"()V");
            if (ctor == null) {
                this.fail("Failed to find Instrumentation default constructor");
                return;
            }
            RequestManagerImpl requestManager = process.getRequestsManager();
            BreakpointRequest br = requestManager.createBreakpointRequest((FilteredRequestor)new InstrumentationStopRequestor(), ctor.location());
            requestManager.enableRequest((EventRequest)br);
        }

        private void fail(@NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/ndk/run/jdwp/JdwpConnector$DebugProcessAdapterImplEx", "fail"));
            }
            ExecutionException e = new ExecutionException(errorMessage);
            for (CodeInjectionImpl codeInjection : JdwpConnector.this.myCodeInjections) {
                FutureResult<Void> resultFuture = codeInjection.getResultFuture();
                resultFuture.setException((Throwable)e);
            }
        }
    }

    public static interface SessionListener {
        public void sessionCreated(@NotNull DebuggerSession var1, @NotNull DebugUIEnvironment var2);
    }
}

