/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.jdwp;

import com.android.tools.ndk.run.jdwp.CodeInjection;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.concurrency.Semaphore;
import org.jetbrains.annotations.NotNull;

class CodeInjectionImpl
implements CodeInjection {
    private final String myCodeFragment;
    private final FutureResult<Void> myResultFuture;
    private final Semaphore myResumeSemaphore;

    public FutureResult<Void> getResultFuture() {
        return this.myResultFuture;
    }

    CodeInjectionImpl(@NotNull String codeFragment) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/android/tools/ndk/run/jdwp/CodeInjectionImpl", "<init>"));
        }
        this.myResultFuture = new FutureResult();
        this.myResumeSemaphore = new Semaphore();
        this.myResumeSemaphore.down();
        this.myCodeFragment = codeFragment;
    }

    @NotNull
    String getCodeFragment() {
        String string = this.myCodeFragment;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/jdwp/CodeInjectionImpl", "getCodeFragment"));
        }
        return string;
    }

    @Override
    public void waitForInjection() throws ExecutionException {
        try {
            this.myResultFuture.get();
        }
        catch (Exception e) {
            ProcessCanceledException canceledException = (ProcessCanceledException)ExceptionUtil.findCause((Throwable)e, ProcessCanceledException.class);
            if (canceledException != null) {
                throw canceledException;
            }
            throw new ExecutionException("Code injection has failed", (Throwable)e);
        }
    }

    @Override
    public void resume() {
        this.myResumeSemaphore.up();
    }

    @Override
    public void cancel() {
        this.myResultFuture.setException((Throwable)new ProcessCanceledException());
    }

    public void waitForResume() {
        this.myResumeSemaphore.waitFor();
    }
}

