/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.javaawarecpp;

import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaAwareNativeDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    private final CidrDebuggerTypesHelper myCppTypesHelper;

    public AndroidJavaAwareNativeDebuggerTypesHelper(@NotNull AndroidNativeDebugProcess process, @NotNull CidrDebuggerTypesHelper cppTypesHelper) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebuggerTypesHelper", "<init>"));
        }
        if (cppTypesHelper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cppTypesHelper", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebuggerTypesHelper", "<init>"));
        }
        super((CidrDebugProcess)process);
        this.myCppTypesHelper = cppTypesHelper;
    }

    public XSourcePosition computeSourcePosition(CidrMemberValue value) {
        CidrPhysicalValue parent;
        XSourcePosition position = value.getSourcePosition();
        if (position == null && (position = (parent = value.getParent()).getSourcePosition()) == null) {
            return null;
        }
        if (AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return position;
        }
        return this.myCppTypesHelper.computeSourcePosition(value);
    }

    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        CidrPhysicalValue parent;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebuggerTypesHelper", "resolveProperty"));
        }
        XSourcePosition position = value.getSourcePosition();
        if (position == null && (position = (parent = value.getParent()).getSourcePosition()) == null) {
            return null;
        }
        if (AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return position;
        }
        return this.myCppTypesHelper.resolveProperty(value, dynamicTypeName);
    }

    public PsiElement resolveToDeclaration(XSourcePosition position, LLValue var) {
        if (AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return this.getContextElement(position);
        }
        return this.myCppTypesHelper.resolveToDeclaration(position, var);
    }

    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebuggerTypesHelper", "isImplicitContextVariable"));
        }
        if (var == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebuggerTypesHelper", "isImplicitContextVariable"));
        }
        if (!AndroidJavaAwareNativeDebuggerTypesHelper.isJavaSourcePosition(position)) {
            return this.myCppTypesHelper.isImplicitContextVariable(position, var);
        }
        return var.getName().equals((Object)this);
    }

    private static boolean isJavaSourcePosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/android/tools/ndk/run/javaawarecpp/AndroidJavaAwareNativeDebuggerTypesHelper", "isJavaSourcePosition"));
        }
        return position.getFile().getFileType().equals(StdFileTypes.JAVA);
    }
}

