/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.hybrid;

import com.android.tools.ndk.jni.JniNameMangler;
import com.android.tools.ndk.run.hybrid.MethodCollector;
import com.android.tools.ndk.run.hybrid.NativeDebugProcess;
import com.android.tools.ndk.run.hybrid.StepIntoNativeBreakpointType;
import com.google.common.collect.Lists;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.intellij.xdebugger.stepping.XSmartStepIntoVariant;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidJavaDebugProcess
extends JavaDebugProcess {
    private static final Logger LOG = Logger.getInstance(AndroidJavaDebugProcess.class);
    private static final String TID_EXPRESSION = "android.os.Process.myTid()";
    private final DebuggerSession myJavaSession;
    private final Project myProject;
    private final NativeDebugProcess myNativeDebugProcess;
    private final XSmartStepIntoHandler<?> mySmartStepIntoHandler;
    private XSourcePosition myPauseSourcePosition;
    private Future<Integer> myCurrentTidFuture;

    public static JavaDebugProcess create(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession, @NotNull NativeDebugProcess nativeDebugProcess) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "create"));
        }
        if (javaSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSession", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "create"));
        }
        if (nativeDebugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeDebugProcess", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "create"));
        }
        AndroidJavaDebugProcess res = new AndroidJavaDebugProcess(session, javaSession, nativeDebugProcess);
        javaSession.getProcess().setXDebugProcess((JavaDebugProcess)res);
        nativeDebugProcess.setJavaSession(session);
        return res;
    }

    protected AndroidJavaDebugProcess(@NotNull XDebugSession session, @NotNull DebuggerSession javaSession, @NotNull NativeDebugProcess nativeDebugProcess) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "<init>"));
        }
        if (javaSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaSession", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "<init>"));
        }
        if (nativeDebugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeDebugProcess", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "<init>"));
        }
        super(session, javaSession);
        this.mySmartStepIntoHandler = new SmartStepIntoHandlerImpl();
        this.myJavaSession = javaSession;
        this.myNativeDebugProcess = nativeDebugProcess;
        this.myProject = javaSession.getProject();
        session.addSessionListener((XDebugSessionListener)new XDebugSessionAdapter(){

            public void sessionPaused() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }

            public void stackFrameChanged() {
                AndroidJavaDebugProcess.this.updateSourcePosition();
            }
        });
    }

    private Future<Integer> getCurrentThreadIdFuture(XSourcePosition sourcePosition) {
        final FutureResult futureResult = new FutureResult();
        XDebuggerEvaluator.XEvaluationCallback evaluationCallback = new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$2", "evaluated"));
                }
                if (result instanceof JavaValue) {
                    JavaValue jValue = (JavaValue)result;
                    futureResult.set((Object)Integer.parseInt(jValue.getDescriptor().getValue().toString()));
                } else {
                    futureResult.setException((Throwable)new EvaluateException("Unexpected value type: " + result.toString()));
                }
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$2", "errorOccurred"));
                }
                futureResult.setException((Throwable)new EvaluateException("Evaluation failed: " + errorMessage));
            }
        };
        this.getEvaluator().evaluate(TID_EXPRESSION, evaluationCallback, sourcePosition);
        return futureResult;
    }

    void updateSourcePosition() {
        XStackFrame frame;
        if (this.myCurrentTidFuture != null) {
            this.myCurrentTidFuture.cancel(true);
            this.myCurrentTidFuture = null;
        }
        if ((frame = this.getSession().getCurrentStackFrame()) != null) {
            this.myPauseSourcePosition = frame.getSourcePosition();
            this.myCurrentTidFuture = this.getCurrentThreadIdFuture(this.myPauseSourcePosition);
        } else {
            this.myPauseSourcePosition = null;
        }
    }

    private void setupNativeBreakpoints(int tid) {
        final LinkedList jniMethodNames = Lists.newLinkedList();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                jniMethodNames.addAll(AndroidJavaDebugProcess.this.findNativeMethodsInCurrentSourcePosition());
            }
        });
        for (String jniMethodName : jniMethodNames) {
            this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(jniMethodName, tid);
        }
    }

    @NotNull
    private List<PsiMethod> findMethodsBySourcePosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "findMethodsBySourcePosition"));
        }
        MethodCollector methodCollector = new MethodCollector(this.myProject, position);
        List<PsiMethod> list = methodCollector.getMethods();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "findMethodsBySourcePosition"));
        }
        return list;
    }

    @NotNull
    private List<String> findNativeMethodsInCurrentSourcePosition() {
        List<PsiMethod> methods = this.findMethodsBySourcePosition(this.myPauseSourcePosition);
        LinkedList jniMethodNames = Lists.newLinkedList();
        for (PsiMethod method : methods) {
            if (!AndroidJavaDebugProcess.isNativeMethod(method)) continue;
            jniMethodNames.add(AndroidJavaDebugProcess.formatJniMethodPattern(method));
        }
        LinkedList linkedList = jniMethodNames;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "findNativeMethodsInCurrentSourcePosition"));
        }
        return linkedList;
    }

    private static boolean isNativeMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "isNativeMethod"));
        }
        return method.getModifierList().hasExplicitModifier("native");
    }

    @NotNull
    private static String formatJniMethodPattern(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "formatJniMethodPattern"));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Java_");
        sb.append(".*");
        sb.append(JniNameMangler.jniEncodeUnderscore(method.getName(), false));
        sb.append(".*");
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "formatJniMethodPattern"));
        }
        return string;
    }

    private void initNativeSteppingInto() {
        if (this.myPauseSourcePosition == null || this.myCurrentTidFuture == null) {
            return;
        }
        try {
            int currentTid = this.myCurrentTidFuture.get();
            this.setupNativeBreakpoints(currentTid);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private void removeAllStepIntoNativeMethodBreakpoints() {
        this.myNativeDebugProcess.removeAllStepIntoNativeBreakpoints();
    }

    public void startStepInto() {
        this.initNativeSteppingInto();
        super.startStepInto();
    }

    public void startForceStepInto() {
        this.initNativeSteppingInto();
        super.startForceStepInto();
    }

    public void startStepOver() {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.startStepOver();
    }

    public void runToPosition(@NotNull XSourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess", "runToPosition"));
        }
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.runToPosition(position);
    }

    public void resume() {
        this.removeAllStepIntoNativeMethodBreakpoints();
        super.resume();
    }

    public void stop() {
        super.stop();
        this.myNativeDebugProcess.getSession().stop();
    }

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return this.mySmartStepIntoHandler;
    }

    private class SmartStepIntoHandlerImpl
    extends XSmartStepIntoHandler<XSmartStepIntoVariantImpl> {
        private SmartStepIntoHandlerImpl() {
        }

        @NotNull
        public List<XSmartStepIntoVariantImpl> computeSmartStepVariants(@NotNull XSourcePosition position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$SmartStepIntoHandlerImpl", "computeSmartStepVariants"));
            }
            MethodCollector methodCollector = new MethodCollector(AndroidJavaDebugProcess.this.myProject, position);
            List<PsiMethod> methods = methodCollector.getMethods();
            ArrayList variants = Lists.newArrayListWithExpectedSize((int)methods.size());
            Range<Integer> lineRange = methodCollector.getLineRange();
            if (lineRange != null) {
                for (PsiMethod method : methods) {
                    variants.add(new XSmartStepIntoVariantImpl(method, lineRange));
                }
            }
            ArrayList arrayList = variants;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$SmartStepIntoHandlerImpl", "computeSmartStepVariants"));
            }
            return arrayList;
        }

        public void startStepInto(@NotNull XSmartStepIntoVariantImpl variant) {
            if (variant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variant", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$SmartStepIntoHandlerImpl", "startStepInto"));
            }
            PsiMethod method = variant.getMethod();
            if (!AndroidJavaDebugProcess.isNativeMethod(method)) {
                AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new BasicStepMethodFilter(method, variant.getLineRange()));
                return;
            }
            try {
                XBreakpoint<StepIntoNativeBreakpointType.Properties> bp = AndroidJavaDebugProcess.this.myNativeDebugProcess.registerStepIntoNativeBreakpoint(AndroidJavaDebugProcess.formatJniMethodPattern(method), (Integer)AndroidJavaDebugProcess.this.myCurrentTidFuture.get());
                AndroidJavaDebugProcess.this.myJavaSession.stepInto(true, (MethodFilter)new NativeMethodFilter(bp, variant.getLineRange()));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }

        public String getPopupTitle(@NotNull XSourcePosition position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$SmartStepIntoHandlerImpl", "getPopupTitle"));
            }
            return "Method to Step Into";
        }
    }

    private class XSmartStepIntoVariantImpl
    extends XSmartStepIntoVariant {
        private final PsiMethod myMethod;
        private final Range<Integer> myLineRange;

        public XSmartStepIntoVariantImpl(@NotNull PsiMethod method, Range<Integer> lineRange) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$XSmartStepIntoVariantImpl", "<init>"));
            }
            if (lineRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineRange", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$XSmartStepIntoVariantImpl", "<init>"));
            }
            this.myMethod = method;
            this.myLineRange = lineRange;
        }

        @Nullable
        public Icon getIcon() {
            return this.myMethod.getIcon(2);
        }

        public String getText() {
            return this.myMethod.getText();
        }

        @NotNull
        public Range<Integer> getLineRange() {
            Range<Integer> range = this.myLineRange;
            if (range == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$XSmartStepIntoVariantImpl", "getLineRange"));
            }
            return range;
        }

        @NotNull
        public PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$XSmartStepIntoVariantImpl", "getMethod"));
            }
            return psiMethod;
        }
    }

    private static class NativeMethodFilter
    implements MethodFilter {
        private final XBreakpoint<StepIntoNativeBreakpointType.Properties> myBp;
        private final Range<Integer> myLineRange;

        public NativeMethodFilter(@NotNull XBreakpoint<StepIntoNativeBreakpointType.Properties> bp, @NotNull Range<Integer> lineRange) {
            if (bp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bp", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$NativeMethodFilter", "<init>"));
            }
            if (lineRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineRange", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$NativeMethodFilter", "<init>"));
            }
            this.myBp = bp;
            this.myLineRange = lineRange;
        }

        public boolean locationMatches(@NotNull DebugProcessImpl process, @NotNull Location location) throws EvaluateException {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$NativeMethodFilter", "locationMatches"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/android/tools/ndk/run/hybrid/AndroidJavaDebugProcess$NativeMethodFilter", "locationMatches"));
            }
            return ((StepIntoNativeBreakpointType.Properties)this.myBp.getProperties()).isCalled();
        }

        @Nullable
        public Range<Integer> getCallingExpressionLines() {
            return this.myLineRange;
        }
    }
}

