/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.editor.AndroidJavaDebugger;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AttachProgressReporter;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.hybrid.AndroidJavaDebugProcess;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.google.common.collect.Sets;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.jetbrains.cidr.execution.RunParameters;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HybridAndroidDebugger
extends NativeAndroidDebugger {
    public static final String ID = "Hybrid";
    private static final Logger LOG = Logger.getInstance(HybridAndroidDebugger.class);

    public HybridAndroidDebugger() {
        super(HybridAndroidDebugger.getAllBreakpointTypes());
    }

    private static Set<Class<? extends XBreakpointType<?, ?>>> getAllBreakpointTypes() {
        HashSet breakpointTypeCls = Sets.newHashSet();
        breakpointTypeCls.addAll(AndroidJavaDebugger.JAVA_BREAKPOINT_TYPES);
        breakpointTypeCls.addAll(NativeAndroidDebugger.NATIVE_BREAKPOINT_TYPES);
        return breakpointTypeCls;
    }

    @Override
    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getId"));
        }
        return ID;
    }

    @Override
    public boolean supportsJavaAwareNativeDebugging(@NotNull AndroidVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "supportsJavaAwareNativeDebugging"));
        }
        return false;
    }

    @Override
    protected boolean hasExistingSession(@NotNull Project project, @NotNull Client client) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "hasExistingSession"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "hasExistingSession"));
        }
        XDebugSession nativeDebugSession = HybridAndroidDebugger.findNativeDebugSession(project, client);
        if (nativeDebugSession == null) {
            return false;
        }
        final String debugPort = HybridAndroidDebugger.getClientDebugPort((Client)client);
        XDebugSession javaDebugSession = HybridAndroidDebugger.findXDebugSession(project, new NotNullFunction<XDebugProcess, Boolean>(){

            @NotNull
            public Boolean fun(XDebugProcess debugProcess) {
                if (!(debugProcess instanceof AndroidJavaDebugProcess)) {
                    Boolean bl = false;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/HybridAndroidDebugger$1", "fun"));
                    }
                    return bl;
                }
                AndroidJavaDebugProcess javaDebugProcess = (AndroidJavaDebugProcess)debugProcess;
                Boolean bl = debugPort.equals(javaDebugProcess.getDebuggerSession().getProcess().getConnection().getAddress().trim());
                if (bl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/HybridAndroidDebugger$1", "fun"));
                }
                return bl;
            }
        });
        if (nativeDebugSession == null || javaDebugSession == null) {
            HybridAndroidDebugger.detachDebugSessions(nativeDebugSession, javaDebugSession);
            return false;
        }
        boolean result = HybridAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor());
        if (!result) {
            HybridAndroidDebugger.detachDebugSessions(nativeDebugSession, javaDebugSession);
        }
        return true;
    }

    private static void detachDebugSessions(@Nullable XDebugSession nativeDebugSession, @Nullable XDebugSession javaDebugSession) {
        if (nativeDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(nativeDebugSession);
        }
        if (javaDebugSession != null) {
            HybridAndroidDebugger.detachXDebugSession(javaDebugSession);
        }
    }

    @Override
    public boolean supportsHybridDebugging() {
        return true;
    }

    @Override
    @NotNull
    public AndroidNativeDebugProcess getAndroidNativeDebugProcess(@NotNull AndroidVersion version, final @NotNull Project project, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull ConsolePrinter printer, @NotNull SessionStarter sessionStarter, @NotNull Client client, @NotNull AttachProgressReporter attachProgressReporter, boolean detachOnStop) throws ExecutionException {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (consoleBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleBuilder", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (printer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printer", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (sessionStarter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionStarter", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        if (attachProgressReporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attachProgressReporter", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        final AndroidNativeDebugProcess result = new AndroidNativeDebugProcess(project, parameters, session, consoleBuilder, printer, sessionStarter, client, attachProgressReporter, detachOnStop);
        final JdwpConnector jdwpConnector = sessionStarter.getJdwpConnector();
        jdwpConnector.addSessionListener(new JdwpConnector.SessionListener(){

            @Override
            public void sessionCreated(final @NotNull DebuggerSession debuggerSession, @NotNull DebugUIEnvironment debugUIEnv) {
                if (debuggerSession == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerSession", "com/android/tools/ndk/run/editor/HybridAndroidDebugger$2", "sessionCreated"));
                }
                if (debugUIEnv == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugUIEnv", "com/android/tools/ndk/run/editor/HybridAndroidDebugger$2", "sessionCreated"));
                }
                jdwpConnector.removeSessionListener(this);
                try {
                    XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(debugUIEnv.getRunProfile().getName() + "-java", debugUIEnv.getReuseContent(), new XDebugProcessStarter(){

                        @NotNull
                        public XDebugProcess start(@NotNull XDebugSession session) {
                            if (session == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/android/tools/ndk/run/editor/HybridAndroidDebugger$2$1", "start"));
                            }
                            JavaDebugProcess javaDebugProcess = AndroidJavaDebugProcess.create(session, debuggerSession, result);
                            if (javaDebugProcess == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/HybridAndroidDebugger$2$1", "start"));
                            }
                            return javaDebugProcess;
                        }
                    });
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
        AndroidNativeDebugProcess androidNativeDebugProcess = result;
        if (androidNativeDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/editor/HybridAndroidDebugger", "getAndroidNativeDebugProcess"));
        }
        return androidNativeDebugProcess;
    }
}

