/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NativeClientCrashReportingTask
extends Task.Backgroundable {
    private final ErrorBean myBean;
    private final Consumer<String> myCallback;
    private final Consumer<Exception> myErrorCallback;

    public NativeClientCrashReportingTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull ErrorBean bean, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/ndk/run/crash/NativeClientCrashReportingTask", "<init>"));
        }
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/android/tools/ndk/run/crash/NativeClientCrashReportingTask", "<init>"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/ndk/run/crash/NativeClientCrashReportingTask", "<init>"));
        }
        if (errorCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCallback", "com/android/tools/ndk/run/crash/NativeClientCrashReportingTask", "<init>"));
        }
        super(project, title, canBeCancelled);
        this.myBean = bean;
        this.myCallback = callback;
        this.myErrorCallback = errorCallback;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/ndk/run/crash/NativeClientCrashReportingTask", "run"));
        }
        indicator.setIndeterminate(true);
        try {
            Attachment attachment;
            CloseableHttpClient client = HttpClients.createDefault();
            HttpPost post = new HttpPost("https://clients2.google.com/cr/report");
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.addTextBody("product", "AndroidStudioNative");
            ApplicationInfoEx application = (ApplicationInfoEx)ApplicationInfo.getInstance();
            builder.addTextBody("version", application.getFullVersion());
            if (this.myBean.getLastAction() != null) {
                builder.addTextBody("last_action", this.myBean.getLastAction());
            }
            if (this.myBean.getDescription() != null) {
                builder.addTextBody("comments", this.myBean.getDescription());
            }
            Attachment attachment2 = attachment = this.myBean.getAttachments().isEmpty() ? null : (Attachment)this.myBean.getAttachments().get(0);
            if (attachment != null && attachment.isIncluded()) {
                builder.addBinaryBody("upload_file_minidump", attachment.getBytes(), ContentType.APPLICATION_OCTET_STREAM, attachment.getName());
            }
            post.setEntity((HttpEntity)new GzipCompressingEntity(builder.build()));
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Unable to submit error report. Error code: " + response.getStatusLine().getStatusCode());
            }
            this.myCallback.consume((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (IOException e) {
            this.myErrorCallback.consume((Object)e);
        }
    }
}

