/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.crash.NativeClientCrashReportingTask;
import com.google.common.io.Files;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.LogMessage;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeClientCrashException
extends Exception {
    public static LogEventException create(String message, File minidump) throws IOException {
        return new LogEventException((IdeaLoggingEvent)new LoggingEvent(message, minidump));
    }

    private static String getHumanReadableMinidump(File minidump) throws IOException {
        String stackwalkFile = SystemInfo.isWindows ? "minidump_stackwalk.exe" : "minidump_stackwalk";
        File stackwalkPathRel = new File(new File("bin"), stackwalkFile);
        File stackwalkPathAbs = ModulePathManager.getSdkLLDBFile(stackwalkPathRel.getPath());
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(stackwalkPathAbs.getPath());
            commandLine.addParameters(new String[]{"-s", minidump.getAbsolutePath()});
            commandLine.setRedirectErrorStream(true);
            Process process = commandLine.createProcess();
            String humanReadable = StreamUtil.readText((InputStream)process.getInputStream(), (Charset)Charset.defaultCharset());
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                throw new IOException("Unable to extract data from the crash dump file. Process returned " + errorCode);
            }
            return humanReadable;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    private static Attachment createMinidumpAttachment(File minidump) throws IOException {
        byte[] contents = Files.toByteArray((File)minidump);
        String humanReadable = NativeClientCrashException.getHumanReadableMinidump(minidump);
        return new Attachment(minidump.getPath(), contents, humanReadable);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.append("\nThe technical details of the error report found on the \u2018Attachments\u2019\ntab will be sent to Google\u2019s Android team to help identify and fix\nthe problem.  https://www.google.com/policies/privacy/");
    }

    private static class CrashData
    extends LogMessage
    implements ErrorReportCustomizer {
        private final Attachment myAttachment;

        public CrashData(IdeaLoggingEvent aEvent, Attachment attachment) {
            super(aEvent);
            this.myAttachment = attachment;
        }

        @NotNull
        public List<Attachment> getAttachments() {
            List<Attachment> list = Arrays.asList(this.myAttachment);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/crash/NativeClientCrashException$CrashData", "getAttachments"));
            }
            return list;
        }

        public Task.Backgroundable makeReportingTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull ErrorBean bean, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/ndk/run/crash/NativeClientCrashException$CrashData", "makeReportingTask"));
            }
            if (bean == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/android/tools/ndk/run/crash/NativeClientCrashException$CrashData", "makeReportingTask"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/ndk/run/crash/NativeClientCrashException$CrashData", "makeReportingTask"));
            }
            if (errorCallback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorCallback", "com/android/tools/ndk/run/crash/NativeClientCrashException$CrashData", "makeReportingTask"));
            }
            return new NativeClientCrashReportingTask(project, title, canBeCancelled, bean, callback, errorCallback);
        }
    }

    private static class LoggingEvent
    extends IdeaLoggingEvent {
        private final Attachment myAttachment;

        public LoggingEvent(String message, File minidump) throws IOException {
            super(message, (Throwable)new NativeClientCrashException());
            this.myAttachment = NativeClientCrashException.createMinidumpAttachment(minidump);
        }

        @NotNull
        public Object getData() {
            CrashData crashData = new CrashData(this, this.myAttachment);
            if (crashData == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/crash/NativeClientCrashException$LoggingEvent", "getData"));
            }
            return crashData;
        }
    }
}

