/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run;

import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrErrorStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectFramesException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidNativeExecutionStack
extends XExecutionStack {
    @NotNull
    private final AndroidNativeDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;
    private List<XStackFrame> myFrames;
    private volatile XStackFrame myTopFrame;
    private volatile boolean myTopFrameReady;
    private boolean myErrorCollectingFrames;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;

    public AndroidNativeExecutionStack(@NotNull AndroidNativeDebugProcess process, @NotNull DebuggerDriver driver, @NotNull LLThread thread, boolean current, @Nullable CidrSuspensionCause suspensionCause) throws ExecutionException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/android/tools/ndk/run/AndroidNativeExecutionStack", "<init>"));
        }
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeExecutionStack", "<init>"));
        }
        if (thread == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/android/tools/ndk/run/AndroidNativeExecutionStack", "<init>"));
        }
        super(thread.getDisplayName(), current ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadSuspended);
        this.myFrames = null;
        this.myTopFrame = null;
        this.myTopFrameReady = false;
        this.myErrorCollectingFrames = false;
        this.myProcess = process;
        this.myThread = thread;
        this.mySuspensionCause = suspensionCause;
        if (!current) {
            return;
        }
        this.myFrames = this.getStackFrames(driver, true);
    }

    @Nullable
    public XStackFrame getTopFrame() {
        assert (this.myTopFrameReady);
        return this.myTopFrame;
    }

    private void addStackFrames(List<XStackFrame> frames, int from, XExecutionStack.XStackFrameContainer container) {
        if (from < frames.size()) {
            container.addStackFrames(frames.subList(from, frames.size()), false);
        }
    }

    private List<XStackFrame> getStackFrames(@NotNull DebuggerDriver driver, boolean untilValidLineEntry) throws ExecutionException {
        if (driver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeExecutionStack", "getStackFrames"));
        }
        ArrayList<XStackFrame> xFrames = new ArrayList<XStackFrame>();
        try {
            List llFrames = driver.getFrames(this.myThread.getId(), untilValidLineEntry);
            CidrStackFrame prev = null;
            for (LLFrame each : ContainerUtil.reverse((List)llFrames)) {
                CidrStackFrame frame = new CidrStackFrame((CidrDebugProcess)this.myProcess, this.myThread.getId(), each, prev, this.mySuspensionCause);
                xFrames.add((XStackFrame)frame);
                prev = frame;
            }
            Collections.reverse(xFrames);
        }
        catch (DBCannotCollectFramesException e) {
            xFrames.add((XStackFrame)new CidrErrorStackFrame(e.getMessage()));
            this.myErrorCollectingFrames = true;
        }
        if (!this.myTopFrameReady) {
            if (!xFrames.isEmpty()) {
                this.myTopFrame = (XStackFrame)xFrames.get(0);
            }
            this.myTopFrameReady = true;
        }
        return xFrames;
    }

    public void computeStackFrames(final int from, final XExecutionStack.XStackFrameContainer container) {
        int sentFrames;
        int n = sentFrames = this.myFrames != null ? this.myFrames.size() : 0;
        if (sentFrames > 0) {
            this.addStackFrames(this.myFrames, from, container);
        }
        if (this.myErrorCollectingFrames) {
            container.addStackFrames(Collections.emptyList(), true);
            return;
        }
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerCommand(){

            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/android/tools/ndk/run/AndroidNativeExecutionStack$1", "run"));
                }
                List newFrames = AndroidNativeExecutionStack.this.getStackFrames(driver, false);
                AndroidNativeExecutionStack.this.addStackFrames(newFrames, Math.max(from, sentFrames), container);
                container.addStackFrames(Collections.emptyList(), true);
            }
        });
    }

    @Nullable
    public GutterIconRenderer getExecutionLineIconRenderer() {
        if (this.mySuspensionCause == null) {
            return super.getExecutionLineIconRenderer();
        }
        return new GutterIconRenderer(){

            @NotNull
            public Icon getIcon() {
                Icon icon = ((AndroidNativeExecutionStack)AndroidNativeExecutionStack.this).mySuspensionCause.icon;
                if (icon == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/run/AndroidNativeExecutionStack$2", "getIcon"));
                }
                return icon;
            }

            @Nullable
            public String getTooltipText() {
                return AndroidNativeExecutionStack.this.mySuspensionCause.getDisplayString();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                return Comparing.equal((Object)AndroidNativeExecutionStack.this.mySuspensionCause, (Object)((AndroidNativeExecutionStack)((Object)o)).mySuspensionCause);
            }

            public int hashCode() {
                return AndroidNativeExecutionStack.this.mySuspensionCause.hashCode();
            }
        };
    }

    public String toString() {
        return this.myThread.toString();
    }
}

