/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniGotoDeclarationHandler;
import com.android.tools.ndk.jni.JniNameMangler;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JniFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/ndk/jni/JniFindUsagesHandlerFactory", "canFindUsages"));
        }
        if (element instanceof OCDeclarator) {
            OCDeclarator declarator = (OCDeclarator)element;
            String name = declarator.getName();
            return name != null && name.startsWith("Java_");
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getModifierList().hasExplicitModifier("native");
        }
        return false;
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/ndk/jni/JniFindUsagesHandlerFactory", "createFindUsagesHandler"));
        }
        if (element instanceof OCDeclarator) {
            return JniFindUsagesHandlerFactory.findJavaReferences((OCDeclarator)element);
        }
        return JniFindUsagesHandlerFactory.findNativeReferences((PsiMethod)element);
    }

    @Nullable
    private static FindUsagesHandler findNativeReferences(@NotNull PsiMethod element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/ndk/jni/JniFindUsagesHandlerFactory", "findNativeReferences"));
        }
        PsiElement[] targets = JniGotoDeclarationHandler.getGotoDeclarationTargets((PsiElement)element);
        if (targets != null && targets.length > 0) {
            return new MyFindUsagesHandler((PsiElement)element, targets);
        }
        return null;
    }

    @Nullable
    private static FindUsagesHandler findJavaReferences(@NotNull OCDeclarator element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/ndk/jni/JniFindUsagesHandlerFactory", "findJavaReferences"));
        }
        PsiMethod declaration = JniNameMangler.findDeclaration(element);
        if (declaration != null) {
            return new MyFindUsagesHandler((PsiElement)element, new PsiElement[]{declaration});
        }
        return null;
    }

    private static class MyFindUsagesHandler
    extends FindUsagesHandler {
        private final PsiElement[] myAdditionalElements;

        protected MyFindUsagesHandler(@NotNull PsiElement element, PsiElement ... additionalElements) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/ndk/jni/JniFindUsagesHandlerFactory$MyFindUsagesHandler", "<init>"));
            }
            super(element);
            this.myAdditionalElements = additionalElements;
        }

        @NotNull
        public PsiElement[] getSecondaryElements() {
            if (this.myAdditionalElements == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/jni/JniFindUsagesHandlerFactory$MyFindUsagesHandler", "getSecondaryElements"));
            }
            return this.myAdditionalElements;
        }
    }
}

