/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeSettings;
import com.android.builder.model.NativeToolchain;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.google.common.collect.ImmutableList;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.toolchains.DefaultCidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerMacros;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleResolveConfiguration
extends UserDataHolderBase
implements OCResolveConfiguration {
    private static final NotificationGroup EVENT_LOG_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"NDK Compile");
    private static final Logger LOG = Logger.getInstance(ModuleResolveConfiguration.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final NativeToolchain myNativeToolchain;
    @Nullable
    private final NativeLibrary myNativeLibrary;
    @Nullable
    private final NativeArtifact myNativeArtifact;
    @Nullable
    private final NativeSettings myNativeSettings;
    @NotNull
    private final NdkCompilerInfoCache myCompilerInfoCache;
    @NotNull
    private final CompilerSettings myCompilerSettings;
    @NotNull
    private final OCCompilerMacros myCompilerMacros;

    ModuleResolveConfiguration(@NotNull Project project, @NotNull File compilerWorkingDir, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeLibrary nativeLibrary, @NotNull NativeToolchain nativeToolchain) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (compilerWorkingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerWorkingDir", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (compilerInfoCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerInfoCache", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (nativeLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeLibrary", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (nativeToolchain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeToolchain", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        this(project, compilerWorkingDir, compilerInfoCache, nativeToolchain, nativeLibrary, null, null);
    }

    ModuleResolveConfiguration(@NotNull Project project, @NotNull File compilerWorkingDir, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeToolchain nativeToolchain, @NotNull NativeArtifact nativeArtifact, @NotNull NativeSettings nativeSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (compilerWorkingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerWorkingDir", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (compilerInfoCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerInfoCache", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (nativeToolchain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeToolchain", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (nativeArtifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeArtifact", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (nativeSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeSettings", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        this(project, compilerWorkingDir, compilerInfoCache, nativeToolchain, null, nativeArtifact, nativeSettings);
    }

    private ModuleResolveConfiguration(@NotNull Project project, @NotNull File compilerWorkingDir, @NotNull NdkCompilerInfoCache compilerInfoCache, @NotNull NativeToolchain nativeToolchain, @Nullable NativeLibrary nativeLibrary, @Nullable NativeArtifact nativeArtifact, @Nullable NativeSettings nativeSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (compilerWorkingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerWorkingDir", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (compilerInfoCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerInfoCache", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        if (nativeToolchain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeToolchain", "com/android/tools/ndk/ModuleResolveConfiguration", "<init>"));
        }
        this.myProject = project;
        this.myNativeToolchain = nativeToolchain;
        this.myNativeLibrary = nativeLibrary;
        this.myNativeArtifact = nativeArtifact;
        this.myNativeSettings = nativeSettings;
        this.myCompilerInfoCache = compilerInfoCache;
        this.myCompilerSettings = new CompilerSettings(compilerWorkingDir);
        this.myCompilerMacros = new CompilerMacros();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getDisplayName(boolean shorten) {
        if (this.myNativeArtifact != null) {
            String string = shorten ? this.myNativeArtifact.getName() : String.format("Artifact: '%1$s''", this.myNativeArtifact.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getDisplayName"));
            }
            return string;
        }
        String string = shorten ? this.myNativeToolchain.getName() : String.format("Toolchain: '%1$s''", this.myNativeToolchain.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public VirtualFile getPrecompiledHeader() {
        return null;
    }

    @NotNull
    public HeaderRoots getProjectHeadersRoots() {
        HeaderRoots headerRoots = new HeaderRoots(Collections.emptyList());
        if (headerRoots == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getProjectHeadersRoots"));
        }
        return headerRoots;
    }

    @NotNull
    public HeaderRoots getLibraryHeadersRoots(@NotNull OCResolveRootAndConfiguration headerContext) {
        NdkCompilerInfoCache.NdkCompilerInfo compilerInfo;
        if (headerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerContext", "com/android/tools/ndk/ModuleResolveConfiguration", "getLibraryHeadersRoots"));
        }
        OCLanguageKind languageKind = headerContext.getKind();
        VirtualFile sourceFile = headerContext.getRootFile();
        if (languageKind == null) {
            languageKind = this.getLanguageKind(sourceFile);
        }
        if ((compilerInfo = this.getNdkCompilerInfo(languageKind, sourceFile)) != null) {
            HeaderRoots headerRoots = new HeaderRoots(compilerInfo.getHeaderSearchPaths());
            if (headerRoots == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getLibraryHeadersRoots"));
            }
            return headerRoots;
        }
        HeaderRoots headerRoots = new HeaderRoots((List)ImmutableList.of());
        if (headerRoots == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getLibraryHeadersRoots"));
        }
        return headerRoots;
    }

    @Nullable
    private NdkCompilerInfoCache.NdkCompilerInfo getNdkCompilerInfo(OCLanguageKind languageKind, VirtualFile sourceFile) {
        try {
            return this.myCompilerInfoCache.getCompilerInfo(this.myProject, this.myCompilerSettings, languageKind, sourceFile);
        }
        catch (NdkCompilerInfoCache.NdkCompilerInvocationException e) {
            EVENT_LOG_NOTIFICATION.createNotification(e.getMessage(), MessageType.ERROR).notify(this.myProject);
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private OCLanguageKind getLanguageKind(@Nullable VirtualFile sourceFile) {
        OCLanguageKind kind = OCLanguageKindCalculator.tryFileTypeAndExtension((Project)this.myProject, (VirtualFile)sourceFile);
        OCLanguageKind oCLanguageKind = kind != null ? kind : this.getMaximumLanguageKind();
        if (oCLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getLanguageKind"));
        }
        return oCLanguageKind;
    }

    @Nullable
    public OCLanguageKind getDeclaredLanguageKind(@Nullable VirtualFile sourceOrHeaderFile) {
        if (sourceOrHeaderFile == null) {
            return null;
        }
        String fileName = sourceOrHeaderFile.getName();
        if (OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return this.getLanguageKind(sourceOrHeaderFile);
        }
        if (OCFileTypeHelpers.isHeaderFile((String)fileName)) {
            return this.getLanguageKind(this.getSourceFileForHeaderFile(sourceOrHeaderFile));
        }
        return null;
    }

    @Nullable
    private VirtualFile getSourceFileForHeaderFile(@NotNull VirtualFile headerFile) {
        if (headerFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerFile", "com/android/tools/ndk/ModuleResolveConfiguration", "getSourceFileForHeaderFile"));
        }
        ArrayList roots = new ArrayList(OCImportGraph.getAllHeaderRoots((Project)this.myProject, (VirtualFile)headerFile));
        String headerNameWithoutExtension = headerFile.getNameWithoutExtension();
        for (VirtualFile root : roots) {
            if (!root.getNameWithoutExtension().equals(headerNameWithoutExtension)) continue;
            return root;
        }
        return null;
    }

    @NotNull
    public OCLanguageKind getPrecompiledLanguageKind() {
        OCLanguageKind oCLanguageKind = this.getMaximumLanguageKind();
        if (oCLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getPrecompiledLanguageKind"));
        }
        return oCLanguageKind;
    }

    @NotNull
    public OCLanguageKind getMaximumLanguageKind() {
        OCLanguageKind oCLanguageKind = OCLanguageKind.CPP;
        if (oCLanguageKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getMaximumLanguageKind"));
        }
        return oCLanguageKind;
    }

    @NotNull
    public OCCompilerMacros getCompilerMacros() {
        OCCompilerMacros oCCompilerMacros = this.myCompilerMacros;
        if (oCCompilerMacros == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getCompilerMacros"));
        }
        return oCCompilerMacros;
    }

    @NotNull
    public OCCompilerSettings getCompilerSettings() {
        CompilerSettings compilerSettings = this.myCompilerSettings;
        if (compilerSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration", "getCompilerSettings"));
        }
        return compilerSettings;
    }

    @Nullable
    public Object getIndexingCluster() {
        return null;
    }

    public int compareTo(OCResolveConfiguration o) {
        return OCWorkspaceUtil.compareConfigurations((OCResolveConfiguration)this, (OCResolveConfiguration)o);
    }

    @Nullable
    public String getAbiString() {
        return this.myNativeLibrary != null ? this.myNativeLibrary.getAbi() : null;
    }

    private class CompilerMacros
    extends OCCompilerMacros {
        private CompilerMacros() {
        }

        protected void fillFileMacros(@NotNull OCInclusionContext context, @NotNull PsiFile sourceFile) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerMacros", "fillFileMacros"));
            }
            if (sourceFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerMacros", "fillFileMacros"));
            }
            NdkCompilerInfoCache.NdkCompilerInfo compilerInfo = ModuleResolveConfiguration.this.getNdkCompilerInfo(context.getLanguageKind(), OCInclusionContextUtil.getVirtualFile((PsiFile)sourceFile));
            if (compilerInfo == null) {
                return;
            }
            CompilerMacros.fillSubstitutions((OCInclusionContext)context, (String)compilerInfo.getDefines());
            this.enableClangFeatures(context, compilerInfo.getFeatures());
            this.enableClangExtensions(context, compilerInfo.getFeatures());
        }
    }

    private class CompilerSettings
    extends OCCompilerSettings {
        @NotNull
        private final CidrToolEnvironment myToolEnvironment;
        @NotNull
        private final File myWorkingDir;

        CompilerSettings(File workingDir) {
            if (workingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings", "<init>"));
            }
            this.myToolEnvironment = new DefaultCidrToolEnvironment();
            this.myWorkingDir = workingDir;
        }

        @Nullable
        public OCCompilerKind getCompiler(@NotNull OCLanguageKind languageKind) {
            if (languageKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageKind", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings", "getCompiler"));
            }
            return null;
        }

        @Nullable
        public File getCompilerExecutable(@NotNull OCLanguageKind lang) {
            if (lang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings", "getCompilerExecutable"));
            }
            if (lang == OCLanguageKind.C) {
                return ModuleResolveConfiguration.this.myNativeToolchain.getCCompilerExecutable();
            }
            return ModuleResolveConfiguration.this.myNativeToolchain.getCppCompilerExecutable();
        }

        @NotNull
        public File getCompilerWorkingDir() {
            File file = this.myWorkingDir;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings", "getCompilerWorkingDir"));
            }
            return file;
        }

        @NotNull
        public CidrToolEnvironment getEnvironment() {
            CidrToolEnvironment cidrToolEnvironment = this.myToolEnvironment;
            if (cidrToolEnvironment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings", "getEnvironment"));
            }
            return cidrToolEnvironment;
        }

        @NotNull
        public CidrCompilerSwitches getCompilerSwitches(@NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile) {
            if (lang == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lang", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings", "getCompilerSwitches"));
            }
            List compilerFlags = ModuleResolveConfiguration.this.myNativeLibrary != null ? (lang == OCLanguageKind.C ? ModuleResolveConfiguration.this.myNativeLibrary.getCCompilerFlags() : ModuleResolveConfiguration.this.myNativeLibrary.getCppCompilerFlags()) : (ModuleResolveConfiguration.this.myNativeSettings != null ? ModuleResolveConfiguration.this.myNativeSettings.getCompilerFlags() : ImmutableList.of());
            CidrSwitchBuilder builder = new CidrSwitchBuilder();
            Iterator iterator = compilerFlags.iterator();
            while (iterator.hasNext()) {
                String compilerFlag = (String)iterator.next();
                if (compilerFlag.contains(" ")) {
                    if (compilerFlag.contains("\\ ")) {
                        compilerFlag = compilerFlag.replace("\\ ", " ");
                    }
                    compilerFlag = compilerFlag.replace(" ", "\\ ");
                }
                builder.addSingle(compilerFlag);
            }
            CidrCompilerSwitches cidrCompilerSwitches = builder.build();
            if (cidrCompilerSwitches == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/ndk/ModuleResolveConfiguration$CompilerSettings", "getCompilerSwitches"));
            }
            return cidrCompilerSwitches;
        }
    }
}

