/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.ndk.internal;

import com.android.utils.FileUtils;
import com.android.utils.StringHelper;
import java.io.File;
import org.gradle.nativeplatform.NativeBinarySpec;

public class NdkNamingScheme {
    public static File getObjectFilesOutputDirectory(NativeBinarySpec binary, File buildDir, String sourceSetName) {
        return new File(buildDir, String.format("%s/objectFiles/%s/%s", "intermediates", binary.getName(), sourceSetName));
    }

    public static String getTaskName(NativeBinarySpec binary, String verb) {
        return NdkNamingScheme.getTaskName(binary, verb, null);
    }

    public static String getTaskName(NativeBinarySpec binary, String verb, String target) {
        StringBuilder sb = new StringBuilder();
        StringHelper.appendCamelCase((StringBuilder)sb, (String)verb);
        StringHelper.appendCamelCase((StringBuilder)sb, (String)binary.getName());
        StringHelper.appendCamelCase((StringBuilder)sb, (String)target);
        return sb.toString();
    }

    public static String getNdkBuildTaskName(NativeBinarySpec binary) {
        return NdkNamingScheme.getTaskName(binary, "ndkBuild");
    }

    public static String getOutputDirectoryName(String buildType, String productFlavor, String abi) {
        return FileUtils.join((String[])new String[]{"intermediates", "binaries", buildType, productFlavor, "lib", abi});
    }

    public static String getStandaloneOutputDirectoryName(NativeBinarySpec binary) {
        return FileUtils.join((String[])new String[]{"outputs", "native", binary.getBuildType().getName(), binary.getFlavor().getName(), "lib", binary.getTargetPlatform().getName()});
    }

    public static String getOutputDirectoryName(NativeBinarySpec binary) {
        return NdkNamingScheme.getOutputDirectoryName(binary.getBuildType().getName(), binary.getFlavor().getName(), binary.getTargetPlatform().getName());
    }

    public static String getDebugLibraryDirectoryName(String buildType, String productFlavor, String abi) {
        return FileUtils.join((String[])new String[]{"intermediates", "binaries", buildType, productFlavor, "obj", abi});
    }

    public static String getDebugLibraryDirectoryName(NativeBinarySpec binary) {
        return NdkNamingScheme.getDebugLibraryDirectoryName(binary.getBuildType().getName(), binary.getFlavor().getName(), binary.getTargetPlatform().getName());
    }

    public static String getSharedLibraryFileName(String moduleName) {
        return "lib" + moduleName + ".so";
    }

    public static String getStaticLibraryFileName(String moduleName) {
        return "lib" + moduleName + ".a";
    }
}

