/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import java.util.Arrays;

public class IntArray {
    public int[] items;
    public int size;
    public boolean ordered;

    public IntArray() {
        this(true, 16);
    }

    public IntArray(int n) {
        this(true, n);
    }

    public IntArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new int[n];
    }

    public IntArray(IntArray intArray) {
        this.ordered = intArray.ordered;
        this.size = intArray.size;
        this.items = new int[this.size];
        System.arraycopy(intArray.items, 0, this.items, 0, this.size);
    }

    public IntArray(int[] nArray) {
        this(true, nArray);
    }

    public IntArray(boolean bl, int[] nArray) {
        this(bl, nArray.length);
        this.size = nArray.length;
        System.arraycopy(nArray, 0, this.items, 0, this.size);
    }

    public void add(int n) {
        int[] nArray = this.items;
        if (this.size == nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        nArray[this.size++] = n;
    }

    public void addAll(IntArray intArray) {
        this.addAll(intArray, 0, intArray.size);
    }

    public void addAll(IntArray intArray, int n, int n2) {
        if (n + n2 > intArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + intArray.size);
        }
        this.addAll(intArray.items, n, n2);
    }

    public void addAll(int[] nArray) {
        this.addAll(nArray, 0, nArray.length);
    }

    public void addAll(int[] nArray, int n, int n2) {
        int n3 = this.size + n2 - n;
        int[] nArray2 = this.items;
        if (n3 >= nArray2.length) {
            nArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(nArray, n, nArray2, this.size, n2);
        this.size += n2;
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.items[n];
    }

    public void set(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        this.items[n] = n2;
    }

    public void insert(int n, int n2) {
        int[] nArray = this.items;
        if (this.size == nArray.length) {
            nArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(nArray, n, nArray, n + 1, this.size - n);
        } else {
            nArray[this.size] = nArray[n];
        }
        ++this.size;
        nArray[n] = n2;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        int[] nArray = this.items;
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    public boolean contains(int n) {
        int n2 = this.size - 1;
        int[] nArray = this.items;
        while (n2 >= 0) {
            if (nArray[n2--] != n) continue;
            return true;
        }
        return false;
    }

    public int indexOf(int n) {
        int[] nArray = this.items;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(int n) {
        int[] nArray = this.items;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] != n) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public int removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        int[] nArray = this.items;
        int n2 = nArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(nArray, n + 1, nArray, n, this.size - n);
        } else {
            nArray[n] = nArray[this.size];
        }
        return n2;
    }

    public int pop() {
        return this.items[--this.size];
    }

    public int peek() {
        return this.items[this.size - 1];
    }

    public void clear() {
        this.size = 0;
    }

    public void shrink() {
        this.resize(this.size);
    }

    public int[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 >= this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    protected int[] resize(int n) {
        int[] nArray = new int[n];
        int[] nArray2 = this.items;
        System.arraycopy(nArray2, 0, nArray, 0, Math.min(nArray2.length, nArray.length));
        this.items = nArray;
        return nArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            int n4 = this.items[i];
            this.items[i] = this.items[n3];
            this.items[n3] = n4;
        }
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size];
        System.arraycopy(this.items, 0, nArray, 0, this.size);
        return nArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        int[] nArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(nArray[i]);
        }
        return stringBuilder.toString();
    }
}

