/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.InjectedBindingClass;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;
import android.databinding.tool.reflection.TypeUtil;
import java.util.List;

public class InjectedBindingClassMethod
extends ModelMethod {
    private final InjectedBindingClass mContainingClass;
    private final String mName;
    private final String mReturnType;
    private final String mParameter;

    public InjectedBindingClassMethod(InjectedBindingClass containingClass, String name, String returnType, String parameter) {
        this.mContainingClass = containingClass;
        this.mName = name;
        this.mReturnType = returnType;
        this.mParameter = parameter;
    }

    @Override
    public ModelClass getDeclaringClass() {
        return this.mContainingClass;
    }

    @Override
    public ModelClass[] getParameterTypes() {
        if (this.mParameter != null) {
            ModelClass parameterType = ModelAnalyzer.getInstance().findClass(this.mParameter, null);
            return new ModelClass[]{parameterType};
        }
        return new ModelClass[0];
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public ModelClass getReturnType(List<ModelClass> args) {
        ModelClass returnType = ModelAnalyzer.getInstance().findClass(this.mReturnType, null);
        return returnType;
    }

    @Override
    public boolean isVoid() {
        return this.getReturnType().isVoid();
    }

    @Override
    public boolean isPublic() {
        return true;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isBindable() {
        return false;
    }

    @Override
    public int getMinApi() {
        return 0;
    }

    @Override
    public String getJniDescription() {
        return TypeUtil.getInstance().getDescription(this);
    }

    @Override
    public boolean isVarArgs() {
        return false;
    }
}

