/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.api;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.jps.api.TaskFuture;

public class BasicFuture<T>
implements TaskFuture<T> {
    protected final Semaphore mySemaphore = new Semaphore(1);
    private final AtomicBoolean myDone = new AtomicBoolean(false);
    private final AtomicBoolean myCanceledState = new AtomicBoolean(false);

    public BasicFuture() {
        this.mySemaphore.acquireUninterruptibly();
    }

    public void setDone() {
        if (!this.myDone.getAndSet(true)) {
            this.mySemaphore.release();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        if (!this.myCanceledState.getAndSet(true)) {
            try {
                this.performCancel();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    protected void performCancel() throws Exception {
    }

    @Override
    public boolean isCancelled() {
        return this.myCanceledState.get();
    }

    @Override
    public boolean isDone() {
        return this.myDone.get();
    }

    @Override
    public void waitFor() {
        try {
            while (!this.isDone()) {
                if (!this.mySemaphore.tryAcquire(100L, TimeUnit.MILLISECONDS)) continue;
                this.mySemaphore.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean waitFor(long timeout, TimeUnit unit) {
        try {
            if (!this.isDone() && this.mySemaphore.tryAcquire(timeout, unit)) {
                this.mySemaphore.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.waitFor();
        return null;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.waitFor(timeout, unit)) {
            throw new TimeoutException();
        }
        return null;
    }
}

