/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.git;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.gct.idea.elysium.ProjectSelector;
import com.google.gct.idea.git.GcpHttpAuthDataProvider;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneGcpDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(CloneGcpDialog.class);
    public static final String INVALID_FILENAME_CHARS = "[/\\\\?%*:|\"<>]";
    private JPanel myRootPanel;
    private ProjectSelector myRepositoryURL;
    private TextFieldWithBrowseButton myParentDirectory;
    private JTextField myDirectoryName;
    @NotNull
    private String myDefaultDirectoryName;
    @NotNull
    private final Project myProject;

    public CloneGcpDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/idea/git/CloneGcpDialog", "<init>"));
        }
        super(project, true);
        this.myDefaultDirectoryName = "";
        this.myProject = project;
        this.$$$setupUI$$$();
        this.init();
        this.initComponents();
        this.setTitle(GctBundle.message("clonefromgcp.title", new Object[0]));
        this.setOKButtonText(GctBundle.message("clonefromgcp.button", new Object[0]));
    }

    @Nullable
    public String getSourceRepositoryURL() {
        return this.getCurrentUrlText();
    }

    @Nullable
    public String getParentDirectory() {
        return this.myParentDirectory.getText();
    }

    @Nullable
    public String getDirectoryName() {
        return this.myDirectoryName.getText();
    }

    @Nullable
    public String getGCPUserName() {
        CredentialedUser selectedUser = this.myRepositoryURL.getSelectedUser();
        return selectedUser != null ? selectedUser.getEmail() : null;
    }

    private void initComponents() {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GctBundle.message("clonefromgcp.destination.directory.title", new Object[0]));
        fcd.setDescription(GctBundle.message("clonefromgcp.destination.directory.description", new Object[0]));
        fcd.setHideIgnored(false);
        this.myParentDirectory.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(fcd.getTitle(), fcd.getDescription(), (ComponentWithBrowseButton)this.myParentDirectory, this.myProject, fcd, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = this.getComponentText();
                if (text.length() == 0 && (file = CloneGcpDialog.this.myProject.getBaseDir()) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        DocumentAdapter updateOkButtonListener = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CloneGcpDialog.this.updateButtons();
            }
        };
        ((JTextField)this.myParentDirectory.getChildComponent()).getDocument().addDocumentListener((DocumentListener)updateOkButtonListener);
        this.myParentDirectory.setText(ProjectUtil.getBaseDir());
        this.myDirectoryName.getDocument().addDocumentListener((DocumentListener)updateOkButtonListener);
        this.setOKActionEnabled(false);
    }

    protected String getDimensionServiceKey() {
        return "GCPCloneDialog";
    }

    protected String getHelpId() {
        return "reference.VersionControl.Git.CloneRepository";
    }

    private void updateButtons() {
        if (this.myParentDirectory.getText().length() == 0 || this.myDirectoryName.getText().length() == 0) {
            this.setErrorText(null);
            this.setOKActionEnabled(false);
            return;
        }
        File file = new File(this.myParentDirectory.getText(), this.myDirectoryName.getText());
        if (file.exists()) {
            this.setErrorText(GctBundle.message("clonefromgcp.destination.exists.error", file));
            this.setOKActionEnabled(false);
            return;
        }
        if (!file.getParentFile().exists()) {
            this.setErrorText(GctBundle.message("clonefromgcp.parent.missing.error", file.getParent()));
            this.setOKActionEnabled(false);
            return;
        }
        this.setErrorText(null);
        this.setOKActionEnabled(true);
    }

    @Nullable
    private String getCurrentUrlText() {
        CredentialedUser selectedUser = this.myRepositoryURL.getSelectedUser();
        if (selectedUser == null || Strings.isNullOrEmpty((String)this.myRepositoryURL.getText())) {
            return null;
        }
        return GcpHttpAuthDataProvider.getGcpUrl(this.myRepositoryURL.getText());
    }

    private void createUIComponents() {
        this.myRepositoryURL = new ProjectSelector();
        this.myRepositoryURL.setMinimumSize(new Dimension(300, 0));
        this.myRepositoryURL.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (CloneGcpDialog.this.myDefaultDirectoryName.equals(CloneGcpDialog.this.myDirectoryName.getText()) || CloneGcpDialog.this.myDirectoryName.getText().length() == 0) {
                    String projectDescription = CloneGcpDialog.this.myRepositoryURL.getProjectDescription();
                    if (!Strings.isNullOrEmpty((String)projectDescription)) {
                        CloneGcpDialog.this.myDefaultDirectoryName = projectDescription.replaceAll(CloneGcpDialog.INVALID_FILENAME_CHARS, "");
                        CloneGcpDialog.this.myDefaultDirectoryName = CloneGcpDialog.this.myDefaultDirectoryName.replaceAll("\\s", "");
                    } else {
                        CloneGcpDialog.this.myDefaultDirectoryName = "";
                    }
                    CloneGcpDialog.this.myDirectoryName.setText(CloneGcpDialog.this.myDefaultDirectoryName);
                }
                CloneGcpDialog.this.updateButtons();
            }
        });
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myRepositoryURL;
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clonefromgcp.projectid"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 3, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.parent.dir"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParentDirectory = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("com/intellij/dvcs/ui/DvcsBundle").getString("clone.dir.name"));
        jPanel.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        ProjectSelector projectSelector = this.myRepositoryURL;
        jPanel.add((Component)projectSelector, new GridConstraints(0, 1, 1, 3, 0, 3, 2, 2, new Dimension(200, -1), null, null));
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

