/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger.ui;

import com.google.api.services.debugger.Debugger;
import com.google.api.services.debugger.model.Debuggee;
import com.google.api.services.debugger.model.ListDebuggeesResponse;
import com.google.common.base.Strings;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.idea.debugger.CloudDebuggerClient;
import com.google.gct.idea.debugger.ProjectRepositoryState;
import com.google.gct.idea.debugger.ProjectRepositoryValidator;
import com.google.gct.idea.elysium.ProjectSelector;
import com.google.gct.idea.util.GctBundle;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import git4idea.actions.BasicAction;
import git4idea.branch.GitBrancher;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudAttachDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(CloudAttachDialog.class);
    private final Project myProject;
    private final ProjectDebuggeeBinding myWireup;
    private JComboBox myDebuggeeTarget;
    private ProjectSelector myElysiumProjectId;
    private JBLabel myInfoPanel;
    private String myOriginalBranchName;
    private JPanel myPanel;
    private CloudDebugProcessState myProcessResultState;
    private GitRepository mySourceRepository;
    private String myStashMessage;
    private ProjectRepositoryValidator.SyncResult mySyncResult;
    private JBCheckBox mySyncStashCheckbox;
    private JBLabel myWarningLabel;
    private JBLabel myWarningLabel2;

    public CloudAttachDialog(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/idea/debugger/ui/CloudAttachDialog", "<init>"));
        }
        super(project, true);
        this.myStashMessage = null;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.init();
        this.initValidation();
        this.setTitle(GctBundle.getString("clouddebug.attachtitle", new Object[0]));
        this.setOKButtonText(GctBundle.getString("clouddebug.attach", new Object[0]));
        this.mySyncStashCheckbox.setVisible(false);
        this.mySyncStashCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CloudAttachDialog.this.mySyncStashCheckbox.isVisible()) {
                    CloudAttachDialog.this.myWarningLabel.setVisible(!CloudAttachDialog.this.mySyncStashCheckbox.isSelected());
                    CloudAttachDialog.this.myWarningLabel2.setVisible(!CloudAttachDialog.this.mySyncStashCheckbox.isSelected());
                    CloudAttachDialog.this.myInfoPanel.setVisible(CloudAttachDialog.this.mySyncStashCheckbox.isSelected());
                    if (CloudAttachDialog.this.mySyncStashCheckbox.isSelected()) {
                        CloudAttachDialog.this.setOKButtonText(CloudAttachDialog.this.getIsContinued() ? GctBundle.getString("clouddebug.continuesession", new Object[0]) : GctBundle.getString("clouddebug.attach", new Object[0]));
                    } else {
                        CloudAttachDialog.this.setOKButtonText(CloudAttachDialog.this.getIsContinued() ? GctBundle.getString("clouddebug.continueanyway", new Object[0]) : GctBundle.getString("clouddebug.attach.anyway", new Object[0]));
                    }
                }
            }
        });
        this.myWarningLabel.setVisible(false);
        this.myWarningLabel.setFont(new Font(this.myWarningLabel.getFont().getName(), 1, this.myWarningLabel.getFont().getSize() - 1));
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.myWarningLabel2.setVisible(false);
        this.myWarningLabel2.setFont(new Font(this.myWarningLabel2.getFont().getName(), 0, this.myWarningLabel.getFont().getSize() - 1));
        this.myWarningLabel2.setText(GctBundle.getString("clouddebug.sourcedoesnotmatch", new Object[0]));
        this.myInfoPanel.setFont(new Font(this.myWarningLabel2.getFont().getName(), 0, this.myWarningLabel.getFont().getSize() - 1));
        Border paddingBorder = BorderFactory.createEmptyBorder(2, 0, 2, 0);
        this.myInfoPanel.setBorder(paddingBorder);
        Window myWindow = this.getWindow();
        if (myWindow != null) {
            myWindow.setPreferredSize(new Dimension(355, 175));
        }
        BasicAction.saveAll();
        this.myWireup = new ProjectDebuggeeBinding(this.myElysiumProjectId, this.myDebuggeeTarget);
        this.myDebuggeeTarget.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudAttachDialog.this.buildResult();
                CloudAttachDialog.this.checkSyncStashState();
            }
        });
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            if (this.mySyncStashCheckbox.isSelected()) {
                this.syncOrStash();
            } else {
                this.buildResult();
                this.close(0);
            }
        }
    }

    protected ValidationInfo doValidate() {
        if (!GoogleLogin.getInstance().isLoggedIn()) {
            return new ValidationInfo(GctBundle.getString("clouddebug.nologin", new Object[0]));
        }
        if (Strings.isNullOrEmpty((String)this.myElysiumProjectId.getText())) {
            return new ValidationInfo(GctBundle.getString("clouddebug.noprojectid", new Object[0]));
        }
        if (this.myDebuggeeTarget.getSelectedItem() == null) {
            return new ValidationInfo(GctBundle.getString("clouddebug.nomodule", new Object[0]));
        }
        return null;
    }

    @Nullable
    public CloudDebugProcessState getResultState() {
        return this.myProcessResultState;
    }

    public void setInputState(@Nullable CloudDebugProcessState inputState) {
        this.myWireup.setInputState(inputState);
    }

    private void buildResult() {
        this.myProcessResultState = this.myWireup.buildResult(this.myProject);
        ProjectRepositoryState repositoryState = ProjectRepositoryState.fromProcessState(this.myProcessResultState);
        repositoryState.setStashMessage(this.myStashMessage);
        repositoryState.setSourceRepository(this.mySourceRepository);
        repositoryState.setOriginalBranchName(this.myOriginalBranchName);
    }

    private void checkSyncStashState() {
        if (this.myProcessResultState == null) {
            LOG.error("unexpected result state during a check sync stash state");
            return;
        }
        this.mySyncResult = new ProjectRepositoryValidator(this.myProcessResultState).checkSyncStashState();
        if (this.mySyncResult.needsStash() && this.mySyncResult.needsSync()) {
            this.setOKButtonText(this.getIsContinued() ? "Continue Session" : GctBundle.getString("clouddebug.attach", new Object[0]));
            this.mySyncStashCheckbox.setVisible(true);
            assert (this.mySyncResult.getTargetSyncSHA() != null);
            this.mySyncStashCheckbox.setText("Stash local changes and Sync to " + this.mySyncResult.getTargetSyncSHA().substring(0, 7));
            this.mySyncStashCheckbox.setSelected(true);
            this.myWarningLabel.setVisible(false);
            this.myWarningLabel2.setVisible(false);
            this.myInfoPanel.setVisible(true);
        } else if (this.mySyncResult.needsStash()) {
            this.setOKButtonText(this.getIsContinued() ? "Continue Session" : GctBundle.getString("clouddebug.attach", new Object[0]));
            this.mySyncStashCheckbox.setVisible(true);
            this.mySyncStashCheckbox.setText(GctBundle.getString("clouddebug.stashbuttontext", new Object[0]));
            this.mySyncStashCheckbox.setSelected(true);
            this.myWarningLabel.setVisible(false);
            this.myWarningLabel2.setVisible(false);
            this.myInfoPanel.setVisible(true);
        } else if (this.mySyncResult.needsSync()) {
            this.setOKButtonText(this.getIsContinued() ? "Continue Session" : GctBundle.getString("clouddebug.attach", new Object[0]));
            this.mySyncStashCheckbox.setVisible(true);
            assert (this.mySyncResult.getTargetSyncSHA() != null);
            this.mySyncStashCheckbox.setText("Sync to " + this.mySyncResult.getTargetSyncSHA().substring(0, 7));
            this.mySyncStashCheckbox.setSelected(true);
            this.myWarningLabel.setVisible(false);
            this.myWarningLabel2.setVisible(false);
            this.myInfoPanel.setVisible(true);
        } else if (!this.mySyncResult.isDeterminable()) {
            this.setOKButtonText(this.getIsContinued() ? "Continue Anyway" : GctBundle.getString("clouddebug.attach.anyway", new Object[0]));
            this.myWarningLabel.setVisible(true);
            this.myWarningLabel2.setVisible(true);
            this.myInfoPanel.setVisible(true);
            this.myWarningLabel2.setText("Could not verify that current source matches module.");
        } else {
            this.setOKButtonText(this.getIsContinued() ? "Continue Session" : GctBundle.getString("clouddebug.attach", new Object[0]));
            this.mySyncStashCheckbox.setVisible(false);
            this.myWarningLabel.setVisible(false);
            this.myWarningLabel2.setVisible(false);
            this.myInfoPanel.setVisible(true);
        }
    }

    private boolean getIsContinued() {
        CloudDebugProcessState state = this.myWireup.getInputState();
        return state != null && state.getCurrentServerBreakpointList().size() > 0;
    }

    private void populateFields() {
        this.myElysiumProjectId.setText("");
    }

    private void refreshAndClose() {
        this.buildResult();
        this.close(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stash() {
        if (this.mySyncResult.getTargetRepository() == null) {
            LOG.error("unexpected null local repro in call to stash");
            return false;
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        if (changeListManager.isFreezedWithNotification("Can not stash changes now")) {
            return false;
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, this.mySourceRepository.getRoot(), GitCommand.STASH);
        handler.addParameters(new String[]{"save"});
        handler.addParameters(new String[]{"--keep-index"});
        String date = DateFormat.getDateTimeInstance(3, 3).format(new Date());
        this.myStashMessage = "Cloud Debugger saved changes from branch " + this.myOriginalBranchName + " at " + date;
        handler.addParameters(new String[]{this.myStashMessage});
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)this.myProject);
        try {
            GitHandlerUtil.doSynchronously((GitLineHandler)handler, (String)GitBundle.getString((String)"stashing.title"), (String)handler.printableCommandLine());
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)this.myProject, (AccessToken)token);
        }
        return true;
    }

    private void syncOrStash() {
        BasicAction.saveAll();
        this.mySourceRepository = this.mySyncResult.getTargetRepository();
        if (this.mySyncResult.needsStash() || this.mySyncResult.needsSync()) {
            this.myOriginalBranchName = this.mySourceRepository.getCurrentBranch() != null ? this.mySourceRepository.getCurrentBranch().getName() : this.mySourceRepository.getCurrentRevision();
        }
        if (this.mySyncResult.needsStash() && !this.stash()) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)this.mySyncResult.getTargetSyncSHA())) {
            GitBrancher brancher = (GitBrancher)ServiceManager.getService((Project)this.myProject, GitBrancher.class);
            if (this.mySourceRepository == null) {
                LOG.error("unexpected null source repo with a target SHA.");
                return;
            }
            assert (this.mySyncResult.getTargetSyncSHA() != null);
            brancher.checkout(this.mySyncResult.getTargetSyncSHA(), false, Collections.singletonList(this.mySourceRepository), new Runnable(){

                @Override
                public void run() {
                    CloudAttachDialog.this.refreshAndClose();
                }
            });
        } else {
            this.refreshAndClose();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel2;
        JBLabel jBLabel3;
        JComboBox jComboBox;
        ProjectSelector projectSelector;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), 2, 2, false, false));
        jPanel.setPreferredSize(new Dimension(275, 135));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.projectlabel"));
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.module"));
        jBLabel5.setInheritsPopupMenu(true);
        jPanel.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myElysiumProjectId = projectSelector = new ProjectSelector();
        jPanel.add((Component)projectSelector, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDebuggeeTarget = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myWarningLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.warninglabel"));
        Font font = jBLabel3.getFont();
        jBLabel3.setFont(new Font(font.getName(), 1, font.getSize()));
        jBLabel3.setVerticalAlignment(0);
        jBLabel3.setForeground(new Color(-65536));
        jBLabel3.setVerticalTextPosition(0);
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 6, 0, 0, 0, null, null, null));
        this.myWarningLabel2 = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.sourcedoesnotmatch"));
        jBLabel2.setVerticalAlignment(0);
        jBLabel2.setVerticalTextPosition(0);
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 1, 1, 1, 10, 0, 0, 0, null, null, null));
        this.mySyncStashCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Sync and Stash");
        jBCheckBox.setMnemonic('Y');
        jBCheckBox.setDisplayedMnemonicIndex(1);
        jBCheckBox.setHorizontalAlignment(10);
        jBCheckBox.setSelected(true);
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 2, 2, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInfoPanel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/CloudToolsBundle").getString("clouddebug.readonly"));
        jBLabel.setVerticalAlignment(0);
        jBLabel.setVerticalTextPosition(0);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jBLabel5.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static class ProjectDebuggeeBinding {
        private static final Logger LOG = Logger.getInstance(ProjectDebuggeeBinding.class);
        private final JComboBox myDebugeeTarget;
        private final ProjectSelector myElysiumProjectId;
        private Debugger myCloudDebuggerClient;
        private CredentialedUser myCredentialedUser;
        private CloudDebugProcessState myInputState;

        public ProjectDebuggeeBinding(@NotNull ProjectSelector elysiumProjectId, @NotNull JComboBox debugeeTarget) {
            if (elysiumProjectId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elysiumProjectId", "com/google/gct/idea/debugger/ui/CloudAttachDialog$ProjectDebuggeeBinding", "<init>"));
            }
            if (debugeeTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugeeTarget", "com/google/gct/idea/debugger/ui/CloudAttachDialog$ProjectDebuggeeBinding", "<init>"));
            }
            this.myCloudDebuggerClient = null;
            this.myCredentialedUser = null;
            this.myElysiumProjectId = elysiumProjectId;
            this.myDebugeeTarget = debugeeTarget;
            this.myElysiumProjectId.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    ProjectDebuggeeBinding.this.refreshDebugTargetList();
                }
            });
            this.myElysiumProjectId.addModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    ProjectDebuggeeBinding.this.refreshDebugTargetList();
                }
            });
        }

        @NotNull
        public CloudDebugProcessState buildResult(Project project) {
            Long number = this.myElysiumProjectId.getProjectNumber();
            String projectNumberString = number != null ? number.toString() : null;
            DebugTarget selectedItem = (DebugTarget)this.myDebugeeTarget.getSelectedItem();
            String savedDebuggeeId = selectedItem != null ? selectedItem.getId() : null;
            String savedProjectDescription = this.myElysiumProjectId.getText();
            CloudDebugProcessState cloudDebugProcessState = new CloudDebugProcessState(this.myCredentialedUser != null ? this.myCredentialedUser.getEmail() : null, savedDebuggeeId, savedProjectDescription, projectNumberString, project);
            if (cloudDebugProcessState == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/debugger/ui/CloudAttachDialog$ProjectDebuggeeBinding", "buildResult"));
            }
            return cloudDebugProcessState;
        }

        @Nullable
        public Debugger getCloudDebuggerClient() {
            CredentialedUser credentialedUser = this.myElysiumProjectId.getSelectedUser();
            if (this.myCredentialedUser == credentialedUser) {
                return this.myCloudDebuggerClient;
            }
            this.myCredentialedUser = credentialedUser;
            this.myCloudDebuggerClient = this.myCredentialedUser != null ? CloudDebuggerClient.getCloudDebuggerClient(this.myCredentialedUser.getEmail()) : null;
            return this.myCloudDebuggerClient;
        }

        @Nullable
        public CloudDebugProcessState getInputState() {
            return this.myInputState;
        }

        public void setInputState(@Nullable CloudDebugProcessState inputState) {
            this.myInputState = inputState;
            if (this.myInputState != null) {
                this.myElysiumProjectId.setText(this.myInputState.getProjectName());
            }
        }

        private void refreshDebugTargetList() {
            try {
                this.myDebugeeTarget.removeAllItems();
                DebugTarget targetSelection = null;
                if (this.myElysiumProjectId.getProjectNumber() != null && this.getCloudDebuggerClient() != null) {
                    ListDebuggeesResponse debuggees = (ListDebuggeesResponse)this.getCloudDebuggerClient().debuggees().list().setProject(this.myElysiumProjectId.getProjectNumber().toString()).execute();
                    if (debuggees != null && debuggees.getDebuggees() != null) {
                        for (Debuggee debuggee : debuggees.getDebuggees()) {
                            DebugTarget item = new DebugTarget(debuggee, this.myElysiumProjectId.getText());
                            if (this.myInputState != null && !Strings.isNullOrEmpty((String)this.myInputState.getDebuggeeId())) {
                                assert (this.myInputState.getDebuggeeId() != null);
                                if (this.myInputState.getDebuggeeId().equals(item.getId())) {
                                    targetSelection = item;
                                }
                            }
                            this.myDebugeeTarget.addItem(item);
                        }
                    }
                    if (targetSelection != null) {
                        this.myDebugeeTarget.setSelectedItem(targetSelection);
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("Error listing debuggees from Cloud Debugger API", (Throwable)ex);
            }
        }

        public static class DebugTarget {
            private final Debuggee myDebuggee;
            private String myDescription;

            public DebugTarget(@NotNull Debuggee debuggee, @NotNull String projectName) {
                if (debuggee == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggee", "com/google/gct/idea/debugger/ui/CloudAttachDialog$ProjectDebuggeeBinding$DebugTarget", "<init>"));
                }
                if (projectName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/google/gct/idea/debugger/ui/CloudAttachDialog$ProjectDebuggeeBinding$DebugTarget", "<init>"));
                }
                this.myDebuggee = debuggee;
                this.myDescription = this.myDebuggee.getDescription();
                if (this.myDescription != null && !Strings.isNullOrEmpty((String)projectName) && this.myDescription.startsWith(projectName + "-")) {
                    this.myDescription = this.myDescription.substring(projectName.length() + 1);
                }
            }

            public String getId() {
                return this.myDebuggee.getId();
            }

            public String toString() {
                return this.myDescription;
            }
        }
    }
}

