/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.intellij.openapi.util.Key;
import com.intellij.util.xmlb.annotations.Transient;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectRepositoryState {
    private static final Key<ProjectRepositoryState> REPO_KEY = Key.create((String)"com.google.gct.idea.debugger.ProjectRepositoryState");
    private String myOriginalBranchName;
    private GitRepository mySourceRepository;
    private String myStashMessage;

    private ProjectRepositoryState() {
    }

    @NotNull
    public static ProjectRepositoryState fromProcessState(@NotNull CloudDebugProcessState processState) {
        if (processState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processState", "com/google/gct/idea/debugger/ProjectRepositoryState", "fromProcessState"));
        }
        ProjectRepositoryState repoState = (ProjectRepositoryState)processState.getUserData(REPO_KEY);
        if (repoState == null) {
            repoState = new ProjectRepositoryState();
            processState.putUserData(REPO_KEY, repoState);
        }
        ProjectRepositoryState projectRepositoryState = repoState;
        if (projectRepositoryState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/debugger/ProjectRepositoryState", "fromProcessState"));
        }
        return projectRepositoryState;
    }

    public void clearForNextSession() {
        this.setStashMessage(null);
    }

    @Transient
    @Nullable
    protected String getOriginalBranchName() {
        return this.myOriginalBranchName;
    }

    @Transient
    public void setOriginalBranchName(@Nullable String originalBranchName) {
        this.myOriginalBranchName = originalBranchName;
    }

    @Transient
    @Nullable
    protected GitRepository getSourceRepository() {
        return this.mySourceRepository;
    }

    @Transient
    public void setSourceRepository(@Nullable GitRepository sourceRepository) {
        this.mySourceRepository = sourceRepository;
    }

    @Transient
    @Nullable
    protected String getStashMessage() {
        return this.myStashMessage;
    }

    @Transient
    public void setStashMessage(@Nullable String stashMessage) {
        this.myStashMessage = stashMessage;
    }

    protected boolean hasSourceRepository() {
        return this.getSourceRepository() != null;
    }
}

