/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.validation;

import com.google.gct.idea.appengine.util.EndpointBundle;
import com.google.gct.idea.appengine.util.EndpointUtilities;
import com.google.gct.idea.appengine.validation.EndpointInspectionBase;
import com.google.gct.idea.appengine.validation.EndpointPsiElementVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorInspection
extends EndpointInspectionBase {
    @Nullable
    public String getStaticDescription() {
        return EndpointBundle.message("constructor.description", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EndpointBundle.message("constructor.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/ConstructorInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = EndpointBundle.message("constructor.short.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/ConstructorInspection", "getShortName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/google/gct/idea/appengine/validation/ConstructorInspection", "buildVisitor"));
        }
        EndpointPsiElementVisitor endpointPsiElementVisitor = new EndpointPsiElementVisitor(){

            public void visitClass(PsiClass psiClass) {
                if (!EndpointUtilities.isEndpointClass((PsiElement)psiClass)) {
                    return;
                }
                PsiMethod[] allConstructors = psiClass.getConstructors();
                if (allConstructors.length == 0) {
                    return;
                }
                for (PsiMethod aConstructor : allConstructors) {
                    if (!EndpointUtilities.isPublicNullaryConstructor(aConstructor)) continue;
                    return;
                }
                holder.registerProblem((PsiElement)psiClass, "Each class that is within an API must have a public nullary constructor.", new LocalQuickFix[]{new MyQuickFix(psiClass)});
            }
        };
        if (endpointPsiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/ConstructorInspection", "buildVisitor"));
        }
        return endpointPsiElementVisitor;
    }

    public class MyQuickFix
    implements LocalQuickFix {
        private final PsiClass psiClass;

        public MyQuickFix(PsiClass psiClass) {
            this.psiClass = psiClass;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName() + ": Add nullary constructor";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/ConstructorInspection$MyQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = ConstructorInspection.this.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/idea/appengine/validation/ConstructorInspection$MyQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/idea/appengine/validation/ConstructorInspection$MyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/google/gct/idea/appengine/validation/ConstructorInspection$MyQuickFix", "applyFix"));
            }
            for (PsiMethod aConstructor : this.psiClass.getConstructors()) {
                if (!EndpointUtilities.isPublicNullaryConstructor(aConstructor)) continue;
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiMethod newConstructor = factory.createMethodFromText("public " + this.psiClass.getName() + "() { }", (PsiElement)this.psiClass);
            PsiMethod[] psiMethods = this.psiClass.getMethods();
            PsiMethod firstMethod = psiMethods.length == 0 ? null : psiMethods[0];
            this.psiClass.addBefore((PsiElement)newConstructor, (PsiElement)firstMethod);
        }
    }
}

