/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.deploy;

import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleInvoker;
import com.google.common.base.Strings;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.appengine.sdk.AppEngineSdk;
import com.google.gct.studio.deploy.UserAgentStrings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineBuilder;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.HttpConfigurable;
import java.awt.EventQueue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AppEngineUpdater {
    private static final Logger LOG = Logger.getInstance((String)"#com.google.gct.idea.deploy.AppEngineUpdater");
    private final Project myProject;
    private final Module myModule;
    private final String myExplodedWarPath;
    private final String mySdkPath;
    private final String myClientSecret;
    private final String myClientId;
    private final String myRefreshToken;
    private final String myVersion;
    private final String myAppEngineProject;

    AppEngineUpdater(Project project, Module module, String sdkPath, String explodedWarPath, String appEngineProject, String version, String clientSecret, String clientId, String refreshToken) {
        this.myProject = project;
        this.myModule = module;
        this.mySdkPath = sdkPath;
        this.myExplodedWarPath = explodedWarPath;
        this.myClientSecret = clientSecret;
        this.myClientId = clientId;
        this.myRefreshToken = refreshToken;
        this.myVersion = version;
        this.myAppEngineProject = appEngineProject;
    }

    void startUploading() {
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myModule.getProject(), "Deploying application", true, null){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/google/gct/studio/deploy/AppEngineUpdater$1", "run"));
                }
                AppEngineUpdater.this.compileAndUpload();
            }
        });
    }

    private void compileAndUpload() {
        final GradleInvoker invoker = GradleInvoker.getInstance((Project)this.myProject);
        GradleInvoker.AfterGradleInvocationTask deployAfter = new GradleInvoker.AfterGradleInvocationTask(){

            public void execute(@NotNull GradleInvocationResult result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/gct/studio/deploy/AppEngineUpdater$2", "execute"));
                }
                invoker.removeAfterGradleInvocationTask((GradleInvoker.AfterGradleInvocationTask)this);
                if (result.isBuildSuccessful()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AppEngineUpdater.this.startUploadingProcess();
                        }
                    });
                } else {
                    LOG.warn("unable to upload the module because it did not build successfully.");
                }
            }
        };
        invoker.addAfterGradleInvocationTask(deployAfter);
        invoker.assemble(new Module[]{this.myModule}, GradleInvoker.TestCompileType.NONE);
    }

    private void startUploadingProcess() {
        Process process;
        GeneralCommandLine commandLine;
        try {
            JavaParameters parameters = new JavaParameters();
            parameters.configureByModule(this.myModule, 1);
            parameters.setMainClass("com.google.appengine.tools.admin.AppCfg");
            AppEngineSdk mySdk = new AppEngineSdk(this.mySdkPath);
            if (mySdk.getToolsApiJarFile() == null) {
                Messages.showErrorDialog((String)"Cannot start uploading: The tools sdk jar could not be located.", (String)"Error");
                return;
            }
            parameters.getClassPath().add(mySdk.getToolsApiJarFile().getAbsolutePath());
            List list = HttpConfigurable.getJvmPropertiesList((boolean)false, null);
            ParametersList vmParametersList = parameters.getVMParametersList();
            if (!list.isEmpty()) {
                for (KeyValue value : list) {
                    vmParametersList.defineProperty((String)value.getKey(), (String)value.getValue());
                }
            }
            vmParametersList.defineProperty(UserAgentStrings.USER_AGENT_KEY, UserAgentStrings.ANDROID_STUDIO);
            ParametersList programParameters = parameters.getProgramParametersList();
            programParameters.add("--application=" + this.myAppEngineProject);
            if (!Strings.isNullOrEmpty((String)this.myVersion)) {
                programParameters.add("--version=" + this.myVersion);
            }
            programParameters.add("--oauth2");
            programParameters.add("--oauth2_client_secret=" + this.myClientSecret);
            programParameters.add("--oauth2_client_id=" + this.myClientId);
            programParameters.add("--oauth2_refresh_token=" + this.myRefreshToken);
            programParameters.add("update");
            programParameters.add(FileUtil.toSystemDependentName((String)this.myExplodedWarPath));
            commandLine = CommandLineBuilder.createFromJavaParameters((SimpleJavaParameters)parameters);
            process = commandLine.createProcess();
        }
        catch (ExecutionException e) {
            final String message = e.getMessage();
            LOG.error("Cannot start uploading: " + message);
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Messages.showErrorDialog((String)("Cannot start uploading: " + message), (String)"Error");
                    }
                });
            } else {
                Messages.showErrorDialog((String)("Cannot start uploading: " + message), (String)"Error");
            }
            return;
        }
        UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "appengine.update", "upload.app", null);
        FilteredOSProcessHandler processHandler = new FilteredOSProcessHandler(process, commandLine.getCommandLineString(), new String[]{this.myRefreshToken, this.myClientSecret, this.myClientId});
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        ConsoleView console = TextConsoleBuilderFactory.getInstance().createBuilder(this.myModule.getProject()).getConsole();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)this.myModule.getProject()).create("Deploy", "Deploy to AppEngine", "Deploy Application", (Disposable)this.myModule.getProject());
        DefaultActionGroup group = new DefaultActionGroup();
        ui.getOptions().setLeftToolbar((ActionGroup)group, "unknown");
        ui.addContent(ui.createContent("upload", console.getComponent(), "Deploy Application", null, console.getPreferredFocusableComponent()));
        console.attachToProcess((ProcessHandler)processHandler);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor((ExecutionConsole)console, (ProcessHandler)processHandler, ui.getComponent(), "Deploy to AppEngine");
        group.add(ActionManager.getInstance().getAction("Stop"));
        group.add((AnAction)new CloseAction(executor, contentDescriptor, this.myModule.getProject()));
        ExecutionManager.getInstance((Project)this.myModule.getProject()).getContentManager().showRunContent(executor, contentDescriptor);
        processHandler.startNotify();
    }

    private class FilteredOSProcessHandler
    extends OSProcessHandler {
        String[] tokensToFilter;

        FilteredOSProcessHandler(@Nullable Process process, String commandLine, String[] filteredTokens) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/google/gct/studio/deploy/AppEngineUpdater$FilteredOSProcessHandler", "<init>"));
            }
            super(process, commandLine);
            this.tokensToFilter = filteredTokens;
        }

        public void notifyTextAvailable(String text, Key outputType) {
            String newText = text;
            if (this.tokensToFilter != null) {
                for (String token : this.tokensToFilter) {
                    newText = newText.replace(token, "*****");
                }
            }
            super.notifyTextAvailable(newText, outputType);
        }
    }
}

