/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.wizard;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CloudTemplateUtils {
    private static final String TEMPLATES_DIR = "templates";
    private static final String CLIENT_TEMPLATES_DIR = "clientTemplates";
    private static final String HELLO_WORLD = "HelloWorld";
    private static final String HELLO_ENDPOINTS = "HelloEndpoints";
    private static final String GCM_ENDPOINTS = "GcmEndpoints";
    private static final Logger LOG = Logger.getInstance(CloudTemplateUtils.class);
    static final List<String> LOCAL_ENDPOINTS_TEMPLATES = ImmutableList.of((Object)"HelloEndpoints", (Object)"GcmEndpoints");
    private static final List<String> LOCAL_TEMPLATES = ImmutableList.of((Object)"HelloEndpoints", (Object)"GcmEndpoints", (Object)"HelloWorld");

    @NotNull
    public static List<TemplateInfo> getTemplates() {
        LOG.info("Populating built-in App Engine templates...");
        List<TemplateInfo> list = CloudTemplateUtils.getTemplates(LOCAL_TEMPLATES);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/wizard/CloudTemplateUtils", "getTemplates"));
        }
        return list;
    }

    @NotNull
    private static List<TemplateInfo> getTemplates(List<String> templateDirectories) {
        List<TemplateInfo> list = CloudTemplateUtils.populateTemplates(CloudTemplateUtils.findTemplatesDirInPluginJar(TEMPLATES_DIR), templateDirectories);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/wizard/CloudTemplateUtils", "getTemplates"));
        }
        return list;
    }

    @Nullable
    public static TemplateInfo getTemplate(String templateDirectory) {
        List<TemplateInfo> templateInfoList = CloudTemplateUtils.getTemplates((List<String>)ImmutableList.of((Object)templateDirectory));
        return templateInfoList.size() == 1 ? templateInfoList.get(0) : null;
    }

    @NotNull
    private static List<TemplateInfo> populateTemplates(@NotNull File root, List<String> templateDirectories) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/google/gct/studio/appengine/wizard/CloudTemplateUtils", "populateTemplates"));
        }
        ImmutableList.Builder templatesBuilder = ImmutableList.builder();
        if (root.exists()) {
            for (String template : templateDirectories) {
                File file = new File(root, template);
                if (file.exists() && file.isDirectory() && new File(file, "template.xml").exists()) {
                    TemplateMetadata templateMetadata = TemplateManager.getInstance().getTemplateMetadata(file);
                    assert (templateMetadata != null);
                    templatesBuilder.add((Object)new TemplateInfo(file, templateMetadata));
                    continue;
                }
                LOG.error("Template is corrupt or missing : " + template);
            }
        } else {
            LOG.error("Failed to find templates directory at \"" + root + "\", perhaps your cloud tools plugin is corrupt?");
        }
        ImmutableList immutableList = templatesBuilder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/wizard/CloudTemplateUtils", "populateTemplates"));
        }
        return immutableList;
    }

    static Template getClientModuleTemplate(String templateName) {
        File templateFile = new File(CloudTemplateUtils.findTemplatesDirInPluginJar(CLIENT_TEMPLATES_DIR), templateName);
        Preconditions.checkState((boolean)templateFile.exists(), (Object)("Failed to find client template " + templateName));
        return Template.createFromPath((File)templateFile);
    }

    private static File findTemplatesDirInPluginJar(String name) {
        File jarPath = new File(PathUtil.getJarPathForClass(CloudTemplateUtils.class));
        if (jarPath.isFile()) {
            jarPath = jarPath.getParentFile();
        }
        return new File(jarPath, name);
    }

    private CloudTemplateUtils() {
    }

    public static class TemplateInfo {
        private final File myFile;
        private final TemplateMetadata myMetadata;

        public TemplateInfo(File templateFile, TemplateMetadata templateMetadata) {
            this.myFile = templateFile;
            this.myMetadata = templateMetadata;
        }

        public File getFile() {
            return this.myFile;
        }

        public TemplateMetadata getMetadata() {
            return this.myMetadata;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("file", (Object)this.myFile).add("title", (Object)this.myMetadata.getTitle()).toString();
        }
    }
}

