/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.sdk;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class AppEngineSdk {
    public static final Logger LOG = Logger.getInstance(AppEngineSdk.class);
    private static final String TOOLS_API_JAR_PATH = "/lib/appengine-tools-api.jar";
    private static final String AGENT_JAR_PATH = "/lib/agent/appengine-agent.jar";
    private static final String OVERRIDES_JAR_PATH = "/lib/override/appengine-dev-jdk-overrides.jar";
    private static final String APPENIGNE_WEB_XML_XSD = "/docs/appengine-web.xsd";
    public static final String DEV_APPSERVER_CLASS = "com.google.appengine.tools.development.DevAppServerMain";
    private final String mySdkPath;

    public AppEngineSdk(String sdkPath) {
        this.mySdkPath = sdkPath;
    }

    public boolean canRunDevAppServer() {
        return this.getToolsApiJarFile() != null;
    }

    @Nullable
    public File getSdkFile(String filePath) {
        String fullJarPath = this.mySdkPath + filePath;
        File sdkJar = new File(FileUtil.toSystemDependentName((String)fullJarPath));
        if (sdkJar.exists()) {
            return sdkJar;
        }
        return null;
    }

    @Nullable
    public File getToolsApiJarFile() {
        return this.getSdkFile(TOOLS_API_JAR_PATH);
    }

    @Nullable
    public File getXmlDescriptorFile() {
        return this.getSdkFile(APPENIGNE_WEB_XML_XSD);
    }

    public void addServerVmParams(ParametersList vmParams) {
        File agentJar = this.getSdkFile(AGENT_JAR_PATH);
        if (agentJar != null) {
            vmParams.add("-javaagent:" + agentJar.getAbsolutePath());
        } else {
            LOG.warn("App Engine SDK Agent jar not found : /lib/agent/appengine-agent.jar");
        }
        File overridesJar = this.getSdkFile(OVERRIDES_JAR_PATH);
        if (overridesJar != null) {
            vmParams.add("-Xbootclasspath/p:" + overridesJar.getAbsolutePath());
        } else {
            LOG.warn("App Engine SDK Overrides JAR not found /lib/override/appengine-dev-jdk-overrides.jar");
        }
    }
}

