/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.studio.appengine.gradle.service;

import com.google.common.collect.Maps;
import com.google.gct.login.stats.UsageTrackerService;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.studio.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.studio.appengine.gradle.project.IdeaAppEngineProject;
import com.google.gct.studio.appengine.run.AppEngineRunConfiguration;
import com.google.gct.studio.appengine.run.AppEngineRunConfigurationType;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineGradleProjectDataService
extends AbstractProjectDataService<IdeaAppEngineProject, Void> {
    private static final Logger LOG = Logger.getInstance(AppEngineGradleProjectDataService.class);
    @NotNull
    public static final Key<IdeaAppEngineProject> IDE_APP_ENGINE_PROJECT = Key.create(IdeaAppEngineProject.class, (int)(ProjectKeys.PROJECT.getProcessingWeight() + 25));
    private NotificationGroup myLoggingNotification;

    @NotNull
    public Key<IdeaAppEngineProject> getTargetDataKey() {
        Key<IdeaAppEngineProject> key = IDE_APP_ENGINE_PROJECT;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(final @NotNull Collection<DataNode<IdeaAppEngineProject>> toImport, @Nullable ProjectData projectData, @NotNull Project project, final @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "importData"));
        }
        if (toImport.isEmpty()) {
            return;
        }
        RunResult result = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                Map importModulesMap = AppEngineGradleProjectDataService.indexByModuleName(toImport);
                for (Module module : modelsProvider.getModules()) {
                    if (!importModulesMap.containsKey(module.getName())) continue;
                    AppEngineGradleFacet facet = AppEngineGradleProjectDataService.addAppEngineGradleFacet((IdeaAppEngineProject)importModulesMap.get(module.getName()), module);
                    AppEngineGradleProjectDataService.addAppEngineRunConfiguration(module, facet);
                    UsageTrackerService.getInstance().trackEvent("com.google.cloud.tools", "appengine.gradle.import", null, null);
                }
            }
        }.execute();
        Throwable error = result.getThrowable();
        if (error != null) {
            LOG.warn("Failed to set up App Engine Gradle Modules");
            this.syncFailed(project, error.getMessage());
        }
    }

    public void syncFailed(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "syncFailed"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "syncFailed"));
        }
        String logMsg = "Gradle sync failed";
        if (StringUtil.isNotEmpty((String)message)) {
            logMsg = logMsg + String.format(": %1$s", message);
        }
        this.addToEventLog(project, logMsg, MessageType.ERROR);
    }

    private void addToEventLog(@NotNull Project project, @NotNull String message, @NotNull MessageType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "addToEventLog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "addToEventLog"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "addToEventLog"));
        }
        this.getLoggingNotification().createNotification(message, type).notify(project);
    }

    private synchronized NotificationGroup getLoggingNotification() {
        if (this.myLoggingNotification == null) {
            NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)"Gradle sync");
            this.myLoggingNotification = registeredGroup != null ? registeredGroup : NotificationGroup.logOnlyGroup((String)"Gradle sync");
        }
        return this.myLoggingNotification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static AppEngineGradleFacet addAppEngineGradleFacet(IdeaAppEngineProject ideaAppEngineProject, Module appEngineModule) {
        FacetManager facetManager = FacetManager.getInstance((Module)appEngineModule);
        ModifiableFacetModel model = facetManager.createModifiableModel();
        AppEngineGradleFacet facet = AppEngineGradleFacet.getInstance(appEngineModule);
        if (facet == null) {
            try {
                facet = (AppEngineGradleFacet)facetManager.createFacet(AppEngineGradleFacet.getFacetType(), "App Engine Gradle", null);
                model.addFacet((Facet)facet);
            }
            finally {
                model.commit();
            }
        }
        if (facet != null) {
            ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().APPENGINE_SDKROOT = ideaAppEngineProject.getDelegate().getAppEngineSdkRoot();
            ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().HTTP_ADDRESS = ideaAppEngineProject.getDelegate().getHttpAddress();
            ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().HTTP_PORT = ideaAppEngineProject.getDelegate().getHttpPort();
            ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().JVM_FLAGS.clear();
            for (String flag : ideaAppEngineProject.getDelegate().getJvmFlags()) {
                ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().JVM_FLAGS.add(flag);
            }
            ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().WAR_DIR = ideaAppEngineProject.getDelegate().getWarDir().getAbsolutePath();
            ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().WEB_APP_DIR = ideaAppEngineProject.getDelegate().getWebAppDir().getAbsolutePath();
            ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState().DISABLE_UPDATE_CHECK = ideaAppEngineProject.getDelegate().isDisableUpdateCheck();
        }
        AppEngineGradleFacet appEngineGradleFacet = facet;
        if (appEngineGradleFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "addAppEngineGradleFacet"));
        }
        return appEngineGradleFacet;
    }

    private static void addAppEngineRunConfiguration(@NotNull Module appEngineModule, @NotNull AppEngineGradleFacet facet) {
        Object configuration2;
        if (appEngineModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appEngineModule", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "addAppEngineRunConfiguration"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "addAppEngineRunConfiguration"));
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)appEngineModule.getProject());
        for (Object configuration2 : runManager.getAllConfigurationsList()) {
            if (!configuration2.getName().equals(appEngineModule.getName())) continue;
            return;
        }
        RunnerAndConfigurationSettings settings = runManager.createRunConfiguration(appEngineModule.getName(), AppEngineRunConfigurationType.getInstance().getFactory());
        settings.setSingleton(true);
        configuration2 = (AppEngineRunConfiguration)settings.getConfiguration();
        configuration2.setModule(appEngineModule);
        ((AppEngineRunConfiguration)((Object)configuration2)).setSyncWithGradle(true);
        runManager.addConfiguration(settings, false);
    }

    @NotNull
    private static Map<String, IdeaAppEngineProject> indexByModuleName(@NotNull Collection<DataNode<IdeaAppEngineProject>> dataNodes) {
        if (dataNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataNodes", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "indexByModuleName"));
        }
        HashMap index = Maps.newHashMap();
        for (DataNode<IdeaAppEngineProject> d : dataNodes) {
            IdeaAppEngineProject appEngineProject = (IdeaAppEngineProject)d.getData();
            index.put(appEngineProject.getModuleName(), appEngineProject);
        }
        HashMap hashMap = index;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/studio/appengine/gradle/service/AppEngineGradleProjectDataService", "indexByModuleName"));
        }
        return hashMap;
    }
}

