/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsViewer;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.runner.ProxyFilters;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.config.AbstractProperty;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingUIActionsHandler
extends GoogleCloudTestResultsViewer.SMEventsAdapter {
    private final TestConsoleProperties myConsoleProperties;

    public GoogleCloudTestingUIActionsHandler(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    @Override
    public void onTestNodeAdded(GoogleCloudTestResultsViewer sender, GoogleCloudTestProxy test) {
        if (TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties)) {
            // empty if block
        }
    }

    @Override
    public void onTestingFinished(GoogleCloudTestResultsViewer sender) {
        AbstractTestProxy firstFailure;
        List<GoogleCloudTestProxy> allTests;
        AbstractTestProxy firstError;
        Object firstDefect;
        GoogleCloudTestProxy testsRootNode = sender.getTestsRootNode();
        if (TestConsoleProperties.SELECT_FIRST_DEFECT.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties) && (firstDefect = (firstError = ProxyFilters.ERROR_LEAF.detectIn(allTests = testsRootNode.getAllTests())) != null ? firstError : ((firstFailure = ProxyFilters.FAILURE_LEAF.detectIn(allTests)) != null ? firstFailure : null)) != null) {
            sender.selectAndNotify((AbstractTestProxy)firstDefect);
        }
    }

    @Override
    public void onSelected(@Nullable GoogleCloudTestProxy selectedTestProxy, @NotNull GoogleCloudTestResultsViewer viewer, final @NotNull TestFrameworkRunningModel model) {
        if (viewer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewer", "com/google/gct/testing/results/GoogleCloudTestingUIActionsHandler", "onSelected"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/google/gct/testing/results/GoogleCloudTestingUIActionsHandler", "onSelected"));
        }
        SMRunnerUtil.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ScrollToTestSourceAction.isScrollEnabled((TestFrameworkRunningModel)model)) {
                    OpenSourceUtil.openSourcesFrom((DataProvider)model.getTreeView(), (boolean)false);
                }
            }
        }, (ModalityState)ModalityState.NON_MODAL);
    }
}

