/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingBasedToSMTRunnerEventsConvertor
extends GoogleCloudTestEventsProcessor {
    private static final Logger LOG = Logger.getInstance((String)GoogleCloudTestingBasedToSMTRunnerEventsConvertor.class.getName());
    private final TIntObjectHashMap<Node> myNodeByIdMap;
    private final Set<Node> myRunningTestNodes;
    private final List<GoogleCloudTestEventsListener> myEventsListeners;
    private final GoogleCloudTestProxy.GoogleCloudRootTestProxy myTestsRootProxy;
    private final Node myTestsRootNode;
    private final String myTestFrameworkName;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator;
    private TestProxyPrinterProvider myTestProxyPrinterProvider;

    public GoogleCloudTestingBasedToSMTRunnerEventsConvertor(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRootProxy, @NotNull String testFrameworkName) {
        if (testsRootProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testsRootProxy", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "<init>"));
        }
        if (testFrameworkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFrameworkName", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "<init>"));
        }
        this.myNodeByIdMap = new TIntObjectHashMap();
        this.myRunningTestNodes = ContainerUtil.newHashSet();
        this.myEventsListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIsTestingFinished = false;
        this.myLocator = null;
        this.myTestProxyPrinterProvider = null;
        this.myTestsRootProxy = testsRootProxy;
        this.myTestsRootNode = new Node(0, null, testsRootProxy);
        this.myTestFrameworkName = testFrameworkName;
        this.myNodeByIdMap.put(this.myTestsRootNode.getId(), (Object)this.myTestsRootNode);
    }

    @Override
    public void setLocator(@NotNull SMTestLocator customLocator) {
        if (customLocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customLocator", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "setLocator"));
        }
        this.myLocator = customLocator;
    }

    @Override
    public void addEventsListener(@NotNull GoogleCloudTestEventsListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "addEventsListener"));
        }
        this.myEventsListeners.add(listener);
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootNode.setState(State.RUNNING);
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setStarted();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestingStarted(true);
            }
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setTestsReporterAttached();
            }
        });
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                if (GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished) {
                    return;
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myIsTestingFinished = true;
                boolean completeTree = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.isTreeComplete();
                if (completeTree) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setFinished();
                } else {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myTestsRootProxy.setTerminated();
                }
                if (!GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty()) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Unexpected running nodes: " + GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes);
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestingFinished();
            }
        });
    }

    private boolean isTreeComplete() {
        if (!this.myRunningTestNodes.isEmpty()) {
            return false;
        }
        List<? extends GoogleCloudTestProxy> children = this.myTestsRootProxy.getChildren();
        for (GoogleCloudTestProxy googleCloudTestProxy : children) {
            if (googleCloudTestProxy.isFinal() && !googleCloudTestProxy.wasTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        if (printerProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printerProvider", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "setPrinterProvider"));
        }
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(final @NotNull GoogleCloudTestStartedEvent testStartedEvent) {
        if (testStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testStartedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onTestStarted"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.doStartNode(testStartedEvent, false);
            }
        });
    }

    @Override
    public void onSuiteStarted(final @NotNull TestSuiteStartedEvent suiteStartedEvent) {
        if (suiteStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteStartedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onSuiteStarted"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.doStartNode((BaseStartedNodeEvent)suiteStartedEvent, true);
            }
        });
    }

    private void doStartNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        if (startedNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodeEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "doStartNode"));
        }
        Node node = this.findNode((TreeNodeEvent)startedNodeEvent);
        if (node != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        Node parentNode = this.findValidParentNode(startedNodeEvent);
        if (parentNode == null) {
            return;
        }
        if (!this.validateNodeId((TreeNodeEvent)startedNodeEvent)) {
            return;
        }
        String nodeName = startedNodeEvent.getName();
        GoogleCloudTestProxy childProxy = new GoogleCloudTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), true);
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        node = new Node(startedNodeEvent.getId(), parentNode, childProxy);
        this.myNodeByIdMap.put(startedNodeEvent.getId(), (Object)node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    @Nullable
    private Node findValidParentNode(@NotNull BaseStartedNodeEvent startedNodeEvent) {
        if (startedNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startedNodeEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "findValidParentNode"));
        }
        int parentId = startedNodeEvent.getParentId();
        if (parentId < 0) {
            this.logProblem("Parent node id should be non-negative: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = (Node)this.myNodeByIdMap.get(startedNodeEvent.getParentId());
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(final @NotNull GoogleCloudTestFinishedEvent testFinishedEvent) {
        if (testFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFinishedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onTestFinished"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)testFinishedEvent);
                if (node != null) {
                    GoogleCloudTestProxy testProxy = node.getProxy();
                    testProxy.setDuration(testFinishedEvent.getDuration());
                    testProxy.setFinished();
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestFinished(testProxy);
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Override
    public void onSuiteFinished(final @NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        if (suiteFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteFinishedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onSuiteFinished"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)suiteFinishedEvent);
                if (node != null) {
                    GoogleCloudTestProxy suiteProxy = node.getProxy();
                    suiteProxy.setFinished();
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnSuiteFinished(suiteProxy);
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FINISHED);
                }
            }
        });
    }

    @Override
    public void onSetTestRunId(@NotNull SetTestRunIdEvent setTestRunIdEvent) {
        if (setTestRunIdEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setTestRunIdEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onSetTestRunId"));
        }
    }

    @Override
    public void onSetActiveCloudMatrix(@NotNull SetActiveCloudMatrixEvent setActiveCloudMatrixEvent) {
        if (setActiveCloudMatrixEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setActiveCloudMatrixEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onSetActiveCloudMatrix"));
        }
    }

    @Override
    public void onConfigurationStarted(@NotNull TestConfigurationStartedEvent configurationStartedEvent) {
        if (configurationStartedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationStartedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onConfigurationStarted"));
        }
    }

    @Override
    public void onConfigurationProgress(@NotNull TestConfigurationProgressEvent configurationProgressEvent) {
        if (configurationProgressEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationProgressEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onConfigurationProgress"));
        }
    }

    @Override
    public void onConfigurationScheduled(@NotNull TestConfigurationScheduledEvent configurationScheduledEvent) {
        if (configurationScheduledEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationScheduledEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onConfigurationScheduled"));
        }
    }

    @Override
    public void onConfigurationStopped(@NotNull TestConfigurationStoppedEvent configurationStoppedEvent) {
        if (configurationStoppedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationStoppedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onConfigurationStopped"));
        }
    }

    @Override
    public void onConfigurationFinished(@NotNull TestConfigurationFinishedEvent configurationFinishedEvent) {
        if (configurationFinishedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationFinishedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onConfigurationFinished"));
        }
    }

    @Nullable
    private Node findNodeToTerminate(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "findNodeToTerminate"));
        }
        Node node = this.findNode(treeNodeEvent);
        if (node == null) {
            this.logProblem("Trying to finish not existent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(final @NotNull String text, final Key outputType) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onUncapturedOutput"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                GoogleCloudTestProxy activeProxy = activeNode.getProxy();
                if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                    activeProxy.addStdErr(text, true);
                } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                    activeProxy.addSystemOutput(text);
                } else {
                    activeProxy.addStdOutput(text, outputType, true);
                }
            }
        });
    }

    @Override
    public void onError(final @NotNull String localizedMessage, final @Nullable String stackTrace, final boolean isCritical) {
        if (localizedMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localizedMessage", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onError"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node activeNode = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findActiveNode();
                GoogleCloudTestProxy activeProxy = activeNode.getProxy();
                activeProxy.addError(localizedMessage, stackTrace, isCritical);
            }
        });
    }

    @Override
    public void onCustomProgressTestsCategory(final @Nullable String categoryName, final int testCount) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestsCategory(categoryName, testCount);
            }
        });
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestStarted();
            }
        });
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnCustomProgressTestFailed();
            }
        });
    }

    @Override
    public void onTestFailure(final @NotNull GoogleCloudTestFailedEvent testFailedEvent) {
        if (testFailedEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFailedEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onTestFailure"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)testFailedEvent);
                if (node == null) {
                    return;
                }
                GoogleCloudTestProxy testProxy = node.getProxy();
                String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
                String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
                String failureMessage = testFailedEvent.getLocalizedFailureMessage();
                String stackTrace = testFailedEvent.getStacktrace();
                if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                    testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText);
                } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                    testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
                } else {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\n" + "Actual:\n" + comparisonFailureActualText);
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestFailed(testProxy);
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.FAILED);
            }
        });
    }

    @Override
    public void onTestIgnored(final @NotNull GoogleCloudTestIgnoredEvent testIgnoredEvent) {
        if (testIgnoredEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testIgnoredEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onTestIgnored"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNodeToTerminate((TreeNodeEvent)testIgnoredEvent);
                if (node != null) {
                    GoogleCloudTestProxy testProxy = node.getProxy();
                    testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestIgnored(testProxy);
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.terminateNode(node, State.IGNORED);
                }
            }
        });
    }

    @Override
    public void onTestOutput(final @NotNull GoogleCloudTestOutputEvent testOutputEvent) {
        if (testOutputEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testOutputEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "onTestOutput"));
        }
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Node node = GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.findNode((TreeNodeEvent)testOutputEvent);
                if (node == null) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Test wasn't started! But " + (Object)((Object)testOutputEvent) + "!");
                    return;
                }
                GoogleCloudTestProxy testProxy = node.getProxy();
                if (testOutputEvent.isStdOut()) {
                    testProxy.addStdOutput(testOutputEvent.getText(), ProcessOutputTypes.STDOUT, true);
                } else {
                    testProxy.addStdErr(testOutputEvent.getText(), true);
                }
            }
        });
    }

    @Override
    public void onTestsCountInSuite(final int count) {
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.fireOnTestsCountInSuite(count);
            }
        });
    }

    private boolean validateNodeId(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "validateNodeId"));
        }
        int nodeId = treeNodeEvent.getId();
        if (nodeId <= 0) {
            this.logProblem("Node id should be positive: " + treeNodeEvent + ".", true);
            return false;
        }
        return true;
    }

    @Nullable
    private Node findNode(@NotNull TreeNodeEvent treeNodeEvent) {
        if (treeNodeEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeNodeEvent", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "findNode"));
        }
        if (!this.validateNodeId(treeNodeEvent)) {
            return null;
        }
        return (Node)this.myNodeByIdMap.get(treeNodeEvent.getId());
    }

    private void fireOnTestingStarted(boolean printTestingStartedTime) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingStarted(this.myTestsRootProxy, printTestingStartedTime);
        }
    }

    private void fireOnTestingFinished() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestingFinished(this.myTestsRootProxy);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestsCountInSuite(count);
        }
    }

    private void fireOnTestStarted(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestStarted(test);
        }
    }

    private void fireOnTestFinished(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFinished(test);
        }
    }

    private void fireOnTestFailed(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestFailed(test);
        }
    }

    private void fireOnTestIgnored(GoogleCloudTestProxy test) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onTestIgnored(test);
        }
    }

    private void fireOnSuiteStarted(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteStarted(suite);
        }
    }

    private void fireOnSuiteFinished(GoogleCloudTestProxy suite) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onSuiteFinished(suite);
        }
    }

    private void fireOnCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestsCategory(categoryName, testCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        for (GoogleCloudTestEventsListener listener : this.myEventsListeners) {
            listener.onCustomProgressTestFailed();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(new Runnable(){

            @Override
            public void run() {
                Application application;
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myEventsListeners.clear();
                if (!(GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                    GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.logProblem("Not all events were processed!");
                }
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myRunningTestNodes.clear();
                GoogleCloudTestingBasedToSMTRunnerEventsConvertor.this.myNodeByIdMap.clear();
            }
        });
    }

    private void setNodeAndAncestorsRunning(@NotNull Node lowestNode) {
        if (lowestNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowestNode", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "setNodeAndAncestorsRunning"));
        }
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING);
            GoogleCloudTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(@NotNull Node node, @NotNull State terminateState) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "terminateNode"));
        }
        if (terminateState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminateState", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "terminateNode"));
        }
        node.setState(terminateState);
        this.myRunningTestNodes.remove(node);
    }

    @NotNull
    private Node findActiveNode() {
        if (this.myRunningTestNodes.isEmpty()) {
            Node node = this.myTestsRootNode;
            if (node == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "findActiveNode"));
            }
            return node;
        }
        Node node = this.myRunningTestNodes.iterator().next();
        if (node == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "findActiveNode"));
        }
        return node;
    }

    private void logProblem(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "logProblem"));
        }
        this.logProblem(msg, SMTestRunnerConnectionUtil.isInDebugMode());
    }

    private void logProblem(@NotNull String msg, boolean throwError) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor", "logProblem"));
        }
        String text = "[" + this.myTestFrameworkName + "] " + msg;
        if (throwError) {
            LOG.error(text);
        } else {
            LOG.warn(text);
        }
    }

    private static class Node {
        private final int myId;
        private final Node myParentNode;
        private final GoogleCloudTestProxy myProxy;
        private State myState;

        Node(int id, @Nullable Node parentNode, @NotNull GoogleCloudTestProxy proxy) {
            if (proxy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor$Node", "<init>"));
            }
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        public int getId() {
            return this.myId;
        }

        @Nullable
        public Node getParentNode() {
            return this.myParentNode;
        }

        @NotNull
        public GoogleCloudTestProxy getProxy() {
            GoogleCloudTestProxy googleCloudTestProxy = this.myProxy;
            if (googleCloudTestProxy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor$Node", "getProxy"));
            }
            return googleCloudTestProxy;
        }

        @NotNull
        public State getState() {
            State state = this.myState;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor$Node", "getState"));
            }
            return state;
        }

        public void setState(@NotNull State newState) {
            if (newState == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newState", "com/google/gct/testing/results/GoogleCloudTestingBasedToSMTRunnerEventsConvertor$Node", "setState"));
            }
            boolean accepted = false;
            if (this.myState == State.NOT_RUNNING || this.myState == State.RUNNING) {
                boolean bl = accepted = this.myState.ordinal() < newState.ordinal();
            }
            if (!accepted) {
                throw new RuntimeException("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString());
            }
            this.myState = newState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId;
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? String.valueOf(this.myParentNode.getId()) : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

