/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.config;

import com.google.gct.testing.config.GsutilConfigurable;
import com.google.gct.testing.config.GsutilSettings;
import com.intellij.execution.ExecutableValidator;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.annotations.NotNull;

public class GsutilExecutableValidator
extends ExecutableValidator {
    private final Project project;
    private final GsutilConfigurable gsutilConfigurable;

    public GsutilExecutableValidator(@NotNull Project project, @NotNull GsutilConfigurable gsutilConfigurable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/testing/config/GsutilExecutableValidator", "<init>"));
        }
        if (gsutilConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gsutilConfigurable", "com/google/gct/testing/config/GsutilExecutableValidator", "<init>"));
        }
        super(project, "Can't start GSUtil! ", "Looks like the path to gsutil executable is not valid.");
        this.project = project;
        this.gsutilConfigurable = gsutilConfigurable;
    }

    protected String getCurrentExecutable() {
        return GsutilSettings.getGsutilExecutable(this.project);
    }

    @NotNull
    protected String getConfigurableDisplayName() {
        String string = this.gsutilConfigurable.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/config/GsutilExecutableValidator", "getConfigurableDisplayName"));
        }
        return string;
    }

    public boolean isExecutableValid(@NotNull String executable) {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "com/google/gct/testing/config/GsutilExecutableValidator", "isExecutableValid"));
        }
        try {
            GeneralCommandLine commandLine = new GeneralCommandLine();
            commandLine.setExePath(executable);
            CapturingProcessHandler handler = new CapturingProcessHandler(commandLine.createProcess(), CharsetToolkit.getDefaultSystemCharset());
            ProcessOutput result = handler.runProcess(60000);
            return !result.isTimeout() && result.getExitCode() == 0;
        }
        catch (Throwable ignored) {
            return false;
        }
    }
}

