/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetPickerDialog;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ShowChooserTargetProvider;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.google.api.client.util.Maps;
import com.google.gct.testing.CloudOptionEnablementChecker;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.android.CloudMatrixTestRunningState;
import com.google.gct.testing.android.CloudTargetUtil;
import com.google.gct.testing.android.CloudTestMatrixTargetConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudTestMatrixTargetProvider
extends DeployTargetProvider {
    @NotNull
    public String getId() {
        if ("CLOUD_DEVICE_MATRIX" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudTestMatrixTargetProvider", "getId"));
        }
        return "CLOUD_DEVICE_MATRIX";
    }

    @NotNull
    public String getDisplayName() {
        if ("Cloud Test Lab Device Matrix" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudTestMatrixTargetProvider", "getDisplayName"));
        }
        return "Cloud Test Lab Device Matrix";
    }

    @NotNull
    public DeployTargetState createState() {
        State state = new State();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudTestMatrixTargetProvider", "createState"));
        }
        return state;
    }

    public DeployTargetConfigurable createConfigurable(@NotNull Project project, Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/google/gct/testing/android/CloudTestMatrixTargetProvider", "createConfigurable"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/google/gct/testing/android/CloudTestMatrixTargetProvider", "createConfigurable"));
        }
        return new CloudTestMatrixTargetConfigurable(project, parentDisposable, context);
    }

    public boolean showInDevicePicker() {
        return true;
    }

    public boolean isApplicable(boolean isTestConfig) {
        return isTestConfig && CloudOptionEnablementChecker.isCloudTestingEnabled();
    }

    public DeployTarget getDeployTarget() {
        return new DeployTarget(){

            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$1", "hasCustomRunProfileState"));
                }
                return !(executor instanceof DefaultDebugExecutor);
            }

            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
                if (executor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$1", "getRunProfileState"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$1", "getRunProfileState"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$1", "getRunProfileState"));
                }
                RunProfile runProfile = env.getRunProfile();
                if (!(runProfile instanceof AndroidTestRunConfiguration)) {
                    return null;
                }
                AndroidTestRunConfiguration runConfiguration = (AndroidTestRunConfiguration)runProfile;
                AndroidFacet facet = AndroidFacet.getInstance((Module)((JavaRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule());
                State cloudTargetState = (State)state;
                return new CloudMatrixTestRunningState(env, facet, runConfiguration, cloudTargetState.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID, cloudTargetState.SELECTED_CLOUD_MATRIX_PROJECT_ID);
            }

            @Nullable
            public DeviceFutures getDevices(@NotNull DeployTargetState state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$1", "getDevices"));
                }
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$1", "getDevices"));
                }
                if (deviceCount == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceCount", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$1", "getDevices"));
                }
                List deployTargetProviders = Collections.emptyList();
                HashMap deployTargetStates = Maps.newHashMap();
                deployTargetStates.put(ShowChooserTargetProvider.ID, new ShowChooserTargetProvider.State());
                DeployTargetPickerDialog dialog = new DeployTargetPickerDialog(runConfigId, facet, deviceCount, deployTargetProviders, (Map)deployTargetStates);
                if (dialog.showAndGet()) {
                    return dialog.getSelectedDeployTarget().getDevices(state, facet, deviceCount, debug, runConfigId);
                }
                return null;
            }
        };
    }

    public static final class State
    extends DeployTargetState {
        public int SELECTED_CLOUD_MATRIX_CONFIGURATION_ID = -1;
        public String SELECTED_CLOUD_MATRIX_PROJECT_ID = "";

        @NotNull
        public List<ValidationError> validate(@NotNull AndroidFacet facet) {
            if (facet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$State", "validate"));
            }
            List<ValidationError> list = CloudTargetUtil.validate(facet, CloudConfiguration.Kind.MATRIX, this.SELECTED_CLOUD_MATRIX_PROJECT_ID, this.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudTestMatrixTargetProvider$State", "validate"));
            }
            return list;
        }
    }
}

