/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.testing.AndroidTestRunConfiguration;
import com.google.gct.testing.CloudConfigurationHelper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudMatrixTestRunningState
implements RunProfileState {
    @NotNull
    private final ExecutionEnvironment myEnvironment;
    @NotNull
    private final AndroidFacet myFacet;
    private final int myMatrixConfigurationId;
    @NotNull
    private final String myCloudProjectId;
    @NotNull
    private final AndroidTestRunConfiguration myConfiguration;
    @NotNull
    private final ProcessHandler myProcessHandler;

    public CloudMatrixTestRunningState(@NotNull ExecutionEnvironment environment, @NotNull AndroidFacet facet, @NotNull AndroidTestRunConfiguration configuration, int matrixConfigurationId, @NotNull String cloudProjectId) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/google/gct/testing/android/CloudMatrixTestRunningState", "<init>"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/google/gct/testing/android/CloudMatrixTestRunningState", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/google/gct/testing/android/CloudMatrixTestRunningState", "<init>"));
        }
        if (cloudProjectId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cloudProjectId", "com/google/gct/testing/android/CloudMatrixTestRunningState", "<init>"));
        }
        this.myProcessHandler = new DefaultDebugProcessHandler();
        this.myEnvironment = environment;
        this.myFacet = facet;
        this.myConfiguration = configuration;
        this.myMatrixConfigurationId = matrixConfigurationId;
        this.myCloudProjectId = cloudProjectId;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/google/gct/testing/android/CloudMatrixTestRunningState", "execute"));
        }
        AndroidProcessText.attach((ProcessHandler)this.myProcessHandler);
        return CloudConfigurationHelper.executeCloudMatrixTests(this.myMatrixConfigurationId, this.myCloudProjectId, this, executor);
    }

    @NotNull
    public ExecutionEnvironment getEnvironment() {
        ExecutionEnvironment executionEnvironment = this.myEnvironment;
        if (executionEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudMatrixTestRunningState", "getEnvironment"));
        }
        return executionEnvironment;
    }

    @NotNull
    public AndroidFacet getFacet() {
        AndroidFacet androidFacet = this.myFacet;
        if (androidFacet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudMatrixTestRunningState", "getFacet"));
        }
        return androidFacet;
    }

    @NotNull
    public AndroidTestRunConfiguration getConfiguration() {
        AndroidTestRunConfiguration androidTestRunConfiguration = this.myConfiguration;
        if (androidTestRunConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudMatrixTestRunningState", "getConfiguration"));
        }
        return androidTestRunConfiguration;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/testing/android/CloudMatrixTestRunningState", "getProcessHandler"));
        }
        return processHandler;
    }
}

