/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.util.Maps;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Objects;
import com.google.api.services.storage.model.StorageObject;
import com.google.api.services.testing.model.AndroidDevice;
import com.google.api.services.testing.model.TestExecution;
import com.google.api.services.testing.model.TestMatrix;
import com.google.api.services.testing.model.ToolResultsExecution;
import com.google.api.services.testing.model.ToolResultsStep;
import com.google.api.services.toolresults.model.Step;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gct.testing.BucketFileMetadata;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ConfigurationInstance;
import com.google.gct.testing.ConfigurationResult;
import com.google.gct.testing.launcher.CloudAuthenticator;
import com.google.gct.testing.results.IGoogleCloudTestRunListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CloudResultsLoader {
    public static final String INFRASTRUCTURE_FAILURE_PREFIX = "Infrastructure Failure:";
    private static final long MAX_SCREENSHOT_DOWNLOAD_SIZE = 0x20000000L;
    private static final Function<StorageObject, BucketFileMetadata> TO_BUCKET_FILE = new Function<StorageObject, BucketFileMetadata>(){

        public BucketFileMetadata apply(StorageObject input) {
            return new BucketFileMetadata(input.getName());
        }
    };
    private static final Function<BucketFileMetadata, String> TO_COMPLETED_CONFIGURATION_OR_NULL = new Function<BucketFileMetadata, String>(){

        public String apply(BucketFileMetadata input) {
            if (input.getType() == BucketFileMetadata.Type.DONE) {
                return input.getEncodedConfigurationInstance();
            }
            return null;
        }
    };
    private boolean newDataReceived = false;
    private final Function<BucketFileMetadata, BucketFileMetadata> UPDATE_CONFIGURATION_PROGRESS = new Function<BucketFileMetadata, BucketFileMetadata>(){

        public BucketFileMetadata apply(BucketFileMetadata file) {
            Optional<byte[]> optionalBytes;
            if (file.getType() == BucketFileMetadata.Type.PROGRESS && (optionalBytes = CloudResultsLoader.getFileBytes(CloudResultsLoader.this.bucketName, file)).isPresent()) {
                String progressLine = new String((byte[])optionalBytes.get());
                String encodedConfigurationInstance = file.getEncodedConfigurationInstance();
                List previousProgress = CloudResultsLoader.this.getPreviousProgress(encodedConfigurationInstance);
                if (!previousProgress.contains(progressLine)) {
                    CloudResultsLoader.this.newDataReceived = true;
                    previousProgress.add(progressLine);
                    CloudResultsLoader.this.testRunListener.testConfigurationProgress(ConfigurationInstance.parseFromEncodedString(encodedConfigurationInstance).getResultsViewerDisplayString(), progressLine);
                }
            }
            return file;
        }
    };
    private final String cloudProjectId;
    private final IGoogleCloudTestRunListener testRunListener;
    private final ProcessHandler processHandler;
    private final String bucketName;
    private final String testMatrixId;
    private final Set<String> allConfigurationInstances = new HashSet<String>();
    private final Set<String> finishedConfigurationInstances = new HashSet<String>();
    private long loadedScreenshotSize = 0L;
    private int consecutivePollFailuresCount = 0;
    private boolean webLinkReported = false;
    private final Map<String, List<String>> configurationProgress = Maps.newHashMap();

    public CloudResultsLoader(String cloudProjectId, IGoogleCloudTestRunListener testRunListener, ProcessHandler processHandler, String bucketName, TestMatrix testMatrix) {
        this.cloudProjectId = cloudProjectId;
        this.testRunListener = testRunListener;
        this.processHandler = processHandler;
        this.bucketName = bucketName;
        if (testMatrix != null) {
            this.testMatrixId = testMatrix.getTestMatrixId();
            for (TestExecution testExecution : testMatrix.getTestExecutions()) {
                this.allConfigurationInstances.add(this.getEncodedConfigurationNameForTestExecution(testExecution));
            }
        } else {
            this.testMatrixId = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<byte[]> getFileBytes(String bucketName, BucketFileMetadata fileMetadata) {
        int chunkSize = 2000000;
        int currentStart = 0;
        byte[] bytes = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            do {
                Storage.Objects.Get getObject = CloudAuthenticator.getStorage().objects().get(bucketName, fileMetadata.getPath());
                getObject.getMediaHttpDownloader().setDirectDownloadEnabled(true);
                getObject.setRequestHeaders(new HttpHeaders().setRange(String.format("bytes=%d-%d", currentStart, currentStart + chunkSize - 1)));
                getObject.executeMediaAndDownloadTo((OutputStream)out);
            } while (out.size() == (currentStart += chunkSize));
            bytes = out.toByteArray();
        }
        catch (Exception e) {
            System.err.println("Failed to load a cloud file: " + fileMetadata.getName());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Optional.fromNullable(bytes);
    }

    public boolean updateResults(Map<String, ConfigurationResult> results) {
        this.newDataReceived = false;
        try {
            if (this.testMatrixId == null) {
                Storage.Objects.List objects = CloudAuthenticator.getStorage().objects().list(this.bucketName);
                List storageObjects = ((Objects)objects.execute()).getItems();
                Iterable files = Iterables.transform((Iterable)storageObjects, (Function)Functions.compose(this.UPDATE_CONFIGURATION_PROGRESS, TO_BUCKET_FILE));
                HashSet finishedConfigurations = Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)files, TO_COMPLETED_CONFIGURATION_OR_NULL), (Predicate)Predicates.notNull()));
                for (BucketFileMetadata file : files) {
                    if (file.getType() != BucketFileMetadata.Type.PROGRESS) continue;
                    String encodedConfigurationInstance = file.getEncodedConfigurationInstance();
                    ConfigurationResult result = this.getOrCreateConfigurationResult(encodedConfigurationInstance, results);
                    result.setComplete(finishedConfigurations.contains(encodedConfigurationInstance));
                    result.setInfrastructureFailure(CloudResultsLoader.isInfrastructureFailure(this.getPreviousProgress(encodedConfigurationInstance)));
                }
            } else {
                this.updateResultsFromApi(results);
            }
            this.loadResultFiles(results);
            this.loadScreenshots(results);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed updating the results from the bucket!", e);
        }
        return this.newDataReceived;
    }

    private void updateResultsFromApi(Map<String, ConfigurationResult> results) {
        TestMatrix testMatrix = null;
        try {
            testMatrix = (TestMatrix)CloudAuthenticator.getTest().projects().testMatrices().get(this.cloudProjectId, this.testMatrixId).execute();
        }
        catch (Exception e) {
            if (this.consecutivePollFailuresCount == 2) {
                for (String configurationInstance : this.allConfigurationInstances) {
                    if (this.finishedConfigurationInstances.contains(configurationInstance)) continue;
                    ConfigurationResult result = this.getOrCreateConfigurationResult(configurationInstance, results);
                    result.setInfrastructureFailure(true);
                    this.finishedConfigurationInstances.add(configurationInstance);
                }
                CloudTestingUtils.showErrorMessage(null, "Error retrieving matrix test results", "Failed to retrieve results of a cloud test matrix!\nException while updating results for test matrix " + this.testMatrixId + "\n\n" + e.getMessage());
            }
            ++this.consecutivePollFailuresCount;
        }
        if (testMatrix != null) {
            this.updateResultsFromTestMatrix(results, testMatrix);
            this.consecutivePollFailuresCount = 0;
        }
    }

    private void updateResultsFromTestMatrix(Map<String, ConfigurationResult> results, @NotNull TestMatrix testMatrix) {
        if (testMatrix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testMatrix", "com/google/gct/testing/CloudResultsLoader", "updateResultsFromTestMatrix"));
        }
        String testMatrixState = testMatrix.getState();
        if (testMatrixState.equals("VALIDATING")) {
            return;
        }
        if (!this.webLinkReported) {
            this.webLinkReported = true;
            if (!testMatrixState.equals("INVALID")) {
                this.processHandler.notifyTextAvailable("You can also view test results, along with other runs against this app, on the web:\n" + this.getWebResultsLink(testMatrix) + " \n\n\n", ProcessOutputTypes.STDOUT);
                this.testRunListener.setActiveCloudMatrix();
            }
        }
        for (TestExecution testExecution : testMatrix.getTestExecutions()) {
            this.updateResultsFromTestExecution(results, testExecution);
        }
    }

    private void updateResultsFromTestExecution(Map<String, ConfigurationResult> results, TestExecution testExecution) {
        String encodedConfigurationInstance = this.getEncodedConfigurationNameForTestExecution(testExecution);
        if (this.finishedConfigurationInstances.contains(encodedConfigurationInstance)) {
            return;
        }
        String testExecutionState = testExecution.getState();
        if (testExecutionState.equals("UNSUPPORTED_ENVIRONMENT")) {
            this.handleTriggeringError(results, encodedConfigurationInstance, "Incompatible device/OS combination");
        } else if (testExecutionState.equals("INCOMPATIBLE_ENVIRONMENT")) {
            this.handleTriggeringError(results, encodedConfigurationInstance, "Application does not support the specified OS version");
        } else if (testExecutionState.equals("INVALID")) {
            this.handleTriggeringError(results, encodedConfigurationInstance, "The provided APK is invalid");
        } else if (testExecutionState.equals("INCOMPATIBLE_ARCHITECTURE")) {
            this.handleTriggeringError(results, encodedConfigurationInstance, "Application does not support the specified device architecture");
        } else if (!testExecutionState.equals("PENDING")) {
            List progressMessages;
            List<String> previousProgress;
            if (testExecutionState.equals("ERROR")) {
                String newProgress = "Infrastructure Failure: " + testExecution.getTestDetails().getErrorMessage();
                previousProgress = this.getPreviousProgress(encodedConfigurationInstance);
                if (previousProgress.isEmpty() || !previousProgress.get(previousProgress.size() - 1).endsWith(newProgress)) {
                    this.reportNewProgress(encodedConfigurationInstance, newProgress);
                }
            } else if (testExecutionState.equals("RUNNING") && (progressMessages = testExecution.getTestDetails().getProgressMessages()) != null && (previousProgress = this.getPreviousProgress(encodedConfigurationInstance)).size() < progressMessages.size()) {
                for (int i = previousProgress.size(); i < progressMessages.size(); ++i) {
                    this.reportNewProgress(encodedConfigurationInstance, (String)progressMessages.get(i));
                }
            }
            ConfigurationResult result = this.getOrCreateConfigurationResult(encodedConfigurationInstance, results);
            if (testExecutionState.equals("FINISHED")) {
                result.setComplete(true);
                ToolResultsStep toolResultsStep = testExecution.getToolResultsStep();
                try {
                    Step step = (Step)CloudAuthenticator.getToolresults().projects().histories().executions().steps().get(toolResultsStep.getProjectId(), toolResultsStep.getHistoryId(), toolResultsStep.getExecutionId(), toolResultsStep.getStepId()).execute();
                    result.setTestDuration(step.getTestExecutionStep().getTestTiming().getTestProcessDuration().getSeconds() * 1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            result.setInfrastructureFailure(CloudResultsLoader.isInfrastructureFailure(this.getPreviousProgress(encodedConfigurationInstance)));
            if (result.isNoProgressExpected()) {
                this.finishedConfigurationInstances.add(encodedConfigurationInstance);
            }
        }
    }

    private void handleTriggeringError(Map<String, ConfigurationResult> results, String encodedConfigurationInstance, String errorMessage) {
        this.reportNewProgress(encodedConfigurationInstance, "Skipped triggering the test execution: " + errorMessage);
        ConfigurationResult result = this.getOrCreateConfigurationResult(encodedConfigurationInstance, results);
        result.setTriggeringError(true);
        this.finishedConfigurationInstances.add(encodedConfigurationInstance);
    }

    private String getWebResultsLink(@NotNull TestMatrix testMatrix) {
        if (testMatrix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testMatrix", "com/google/gct/testing/CloudResultsLoader", "getWebResultsLink"));
        }
        ToolResultsExecution toolResultsExecution = testMatrix.getResultStorage().getToolResultsExecution();
        if (toolResultsExecution == null) {
            return "";
        }
        return "https://console.developers.google.com/project/" + this.cloudProjectId + "/testlab/mobile/histories/" + toolResultsExecution.getHistoryId() + "/executions/" + toolResultsExecution.getExecutionId() + "?source=android-studio";
    }

    private String getEncodedConfigurationNameForTestExecution(TestExecution testExecution) {
        AndroidDevice androidDevice = testExecution.getEnvironment().getAndroidDevice();
        return androidDevice.getAndroidModelId() + "-" + androidDevice.getAndroidVersionId() + "-" + androidDevice.getLocale() + "-" + androidDevice.getOrientation();
    }

    private void reportNewProgress(String encodedConfigurationInstance, String newProgress) {
        this.newDataReceived = true;
        this.getPreviousProgress(encodedConfigurationInstance).add(newProgress);
        this.testRunListener.testConfigurationProgress(ConfigurationInstance.parseFromEncodedString(encodedConfigurationInstance).getResultsViewerDisplayString(), newProgress);
    }

    private ConfigurationResult getOrCreateConfigurationResult(String encodedConfigurationInstance, Map<String, ConfigurationResult> results) {
        ConfigurationResult result = results.get(encodedConfigurationInstance);
        if (result == null) {
            result = new ConfigurationResult(encodedConfigurationInstance, this.bucketName);
            results.put(encodedConfigurationInstance, result);
        }
        return result;
    }

    private static boolean isInfrastructureFailure(List<String> progressMessages) {
        if (progressMessages.isEmpty()) {
            return false;
        }
        return progressMessages.get(progressMessages.size() - 1).startsWith(INFRASTRUCTURE_FAILURE_PREFIX);
    }

    private List<String> getPreviousProgress(String encodedConfigurationInstance) {
        List<String> progressMessages = this.configurationProgress.get(encodedConfigurationInstance);
        if (progressMessages == null) {
            progressMessages = new LinkedList<String>();
            this.configurationProgress.put(encodedConfigurationInstance, progressMessages);
        }
        return progressMessages;
    }

    private void loadResultFiles(Map<String, ConfigurationResult> results) {
        try {
            Storage.Objects.List objects = CloudAuthenticator.getStorage().objects().list(this.bucketName);
            List storageObjects = ((Objects)objects.execute()).getItems();
            Iterable files = Iterables.transform((Iterable)storageObjects, TO_BUCKET_FILE);
            for (BucketFileMetadata file : files) {
                Optional<String> optionalResult;
                String encodedConfigurationInstance;
                ConfigurationResult configurationResult;
                if (file.getType() != BucketFileMetadata.Type.RESULT || (configurationResult = results.get(encodedConfigurationInstance = file.getEncodedConfigurationInstance())) == null || configurationResult.hasResult() || !(optionalResult = this.toOptionalString(CloudResultsLoader.getFileBytes(this.bucketName, file))).isPresent() || !file.hasEncodedConfigurationInstance()) continue;
                this.newDataReceived = true;
                configurationResult.setResult((String)optionalResult.get());
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void loadScreenshots(Map<String, ConfigurationResult> results) {
        if (this.loadedScreenshotSize > 0x20000000L) {
            return;
        }
        List storageObjects = null;
        try {
            Storage.Objects.List objects = CloudAuthenticator.getStorage().objects().list(this.bucketName);
            storageObjects = ((Objects)objects.execute()).getItems();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve bucket objects: ", e);
        }
        if (storageObjects == null) {
            return;
        }
        Iterable files = Iterables.transform((Iterable)storageObjects, TO_BUCKET_FILE);
        for (BucketFileMetadata file : files) {
            ConfigurationResult result;
            if (file.getType() != BucketFileMetadata.Type.SCREENSHOT || this.isIgnoredScreenshot(file) || (result = results.get(file.getEncodedConfigurationInstance())) == null || result.getScreenshotMetadata().get(file.getName()) != null) continue;
            result.addScreenshotMetadata(file.getName(), file);
            this.newDataReceived = true;
        }
    }

    private boolean isIgnoredScreenshot(BucketFileMetadata file) {
        return file.getPath().contains("/flipbook/") || file.getName().startsWith("TestRunner-prepareVirtualDevice-beforeunlock-") || file.getName().startsWith("TestRunner-prepareVirtualDevice-afterunlock-");
    }

    private Optional<String> toOptionalString(Optional<byte[]> optionalBytes) {
        return optionalBytes.isPresent() ? Optional.of((Object)new String((byte[])optionalBytes.get())) : Optional.absent();
    }
}

