/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.CloudPersistentConfiguration;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.dimension.ApiDimension;
import com.google.gct.testing.dimension.CloudConfigurationDimension;
import com.google.gct.testing.dimension.CloudTestingType;
import com.google.gct.testing.dimension.ConfigurationChangeEvent;
import com.google.gct.testing.dimension.ConfigurationChangeListener;
import com.google.gct.testing.dimension.DeviceDimension;
import com.google.gct.testing.dimension.LanguageDimension;
import com.google.gct.testing.dimension.OrientationDimension;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;

public class CloudConfigurationImpl
extends CloudConfiguration {
    public static final int DEFAULT_MATRIX_CONFIGURATION_ID = Integer.MAX_VALUE;
    public static final int DEFAULT_DEVICE_CONFIGURATION_ID = 0x7FFFFFFE;
    private static int nextAvailableID = 1;
    private int id;
    private String name;
    private CloudConfiguration.Kind kind;
    private Icon icon;
    private final AndroidFacet facet;
    private boolean isEditable;
    private final Set<ConfigurationChangeListener> changeListeners = new HashSet<ConfigurationChangeListener>();
    DeviceDimension deviceDimension;
    ApiDimension apiDimension;
    LanguageDimension languageDimension;
    OrientationDimension orientationDimension;

    public CloudConfigurationImpl(int id, String name, CloudConfiguration.Kind kind, Icon icon, AndroidFacet facet) {
        if (!this.isPredefinedId(id) && id >= nextAvailableID) {
            nextAvailableID = id + 1;
        }
        this.id = id;
        this.name = name;
        this.kind = kind;
        this.icon = icon;
        this.facet = facet;
        this.isEditable = true;
        this.createDimensions();
    }

    private boolean isPredefinedId(int id) {
        return id == Integer.MAX_VALUE || id == 0x7FFFFFFE;
    }

    public CloudConfigurationImpl(String name, CloudConfiguration.Kind kind, Icon icon, AndroidFacet facet) {
        this(nextAvailableID++, name, kind, icon, facet);
    }

    @VisibleForTesting
    CloudConfigurationImpl(String name, CloudConfiguration.Kind kind, int minSdkVersion, List<String> locales) {
        this.id = nextAvailableID++;
        this.name = name;
        this.kind = kind;
        this.facet = null;
        this.isEditable = true;
        this.deviceDimension = new DeviceDimension(this);
        this.apiDimension = new ApiDimension(this, minSdkVersion);
        this.languageDimension = new LanguageDimension(this, locales);
        this.orientationDimension = new OrientationDimension(this);
    }

    public CloudConfigurationImpl(AndroidFacet facet, CloudConfiguration.Kind kind) {
        this.id = nextAvailableID++;
        this.name = "Unnamed";
        this.kind = kind;
        this.icon = CloudConfigurationHelper.DEFAULT_ICON;
        this.facet = facet;
        this.isEditable = true;
        this.createDimensions();
    }

    private void createDimensions() {
        this.deviceDimension = new DeviceDimension(this);
        this.apiDimension = new ApiDimension(this, this.facet);
        this.languageDimension = new LanguageDimension(this, this.facet);
        this.orientationDimension = new OrientationDimension(this);
    }

    public String getName() {
        return this.name;
    }

    public CloudConfiguration.Kind getKind() {
        return this.kind;
    }

    private int getHash() {
        return (this.name + FluentIterable.from(this.getDimensions()).transform((Function)new Function<CloudConfigurationDimension, String>(){

            public String apply(CloudConfigurationDimension dimension) {
                return CloudConfigurationImpl.this.getStringRepresentation(dimension);
            }
        }).toString()).hashCode();
    }

    private String getStringRepresentation(CloudConfigurationDimension dimension) {
        StringBuffer sb = new StringBuffer();
        sb.append(dimension.getId());
        for (CloudTestingType type : dimension.getEnabledTypes()) {
            sb.append(type.getId());
        }
        return sb.toString();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        int deviceConfigurationCount = this.getDeviceConfigurationCount();
        if (this.kind != CloudConfiguration.Kind.SINGLE_DEVICE) {
            return this.name + " (" + deviceConfigurationCount + ")";
        }
        if (deviceConfigurationCount > 0) {
            return this.name;
        }
        return this.name + " (not configured)";
    }

    public void setName(String name) {
        this.name = name;
        for (ConfigurationChangeListener changeListener : this.changeListeners) {
            changeListener.configurationChanged(new ConfigurationChangeEvent(this));
        }
    }

    public List<CloudConfigurationDimension> getDimensions() {
        return ImmutableList.of((Object)this.deviceDimension, (Object)this.apiDimension, (Object)this.languageDimension, (Object)this.orientationDimension);
    }

    public ApiDimension getApiDimension() {
        return this.apiDimension;
    }

    public LanguageDimension getLanguageDimension() {
        return this.languageDimension;
    }

    public DeviceDimension getDeviceDimension() {
        return this.deviceDimension;
    }

    public OrientationDimension getOrientationDimension() {
        return this.orientationDimension;
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean removeConfigurationChangeListener(ConfigurationChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public void dimensionChanged(CloudConfigurationDimension dimension) {
        for (ConfigurationChangeListener changeListener : this.changeListeners) {
            changeListener.configurationChanged(new ConfigurationChangeEvent(this));
        }
    }

    @Override
    public int getDeviceConfigurationCount() {
        int product = 1;
        for (CloudConfigurationDimension dimension : this.getDimensions()) {
            product *= dimension.getEnabledTypes().size();
        }
        return product;
    }

    public int countCombinationsCollapsingOrientation() {
        int product = 1;
        for (CloudConfigurationDimension dimension : this.getDimensions()) {
            if (dimension instanceof OrientationDimension) {
                product *= Math.min(dimension.getEnabledTypes().size(), 1);
                continue;
            }
            product *= dimension.getEnabledTypes().size();
        }
        return product;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public void setNonEditable() {
        this.isEditable = false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String prepareMatrixTestRequest() {
        Preconditions.checkState((this.getDeviceConfigurationCount() > 0 ? 1 : 0) != 0, (Object)"There should be at least one combination in a matrix test request!");
        StringBuffer bf = new StringBuffer();
        boolean firstDim = true;
        for (CloudConfigurationDimension dimension : this.getDimensions()) {
            if (!firstDim) {
                bf.append(" && ");
            }
            firstDim = false;
            StringBuffer dimensionRequest = this.prepareDimensionRequest(dimension);
            if (dimension.getEnabledTypes().size() > 1) {
                bf.append("(").append(dimensionRequest).append(")");
                continue;
            }
            bf.append(dimensionRequest);
        }
        return bf.toString();
    }

    public List<String> computeConfigurationInstances(String delimiter) {
        LinkedList<String> configurationInstances = new LinkedList<String>();
        this.computeConfigurationInstancesRecursively(delimiter, "", 0, configurationInstances);
        return configurationInstances;
    }

    private void computeConfigurationInstancesRecursively(String delimiter, String partialConfigurationInstance, int dimensionIndex, List<String> configurationInstances) {
        if (dimensionIndex >= this.getDimensions().size()) {
            configurationInstances.add(partialConfigurationInstance);
            return;
        }
        String separator = dimensionIndex == 0 ? "" : delimiter;
        for (CloudTestingType type : this.getDimensions().get(dimensionIndex).getEnabledTypes()) {
            String typeName = " | ".equals(delimiter) ? type.getResultsViewerDisplayName() : type.getId();
            this.computeConfigurationInstancesRecursively(delimiter, partialConfigurationInstance + separator + typeName, dimensionIndex + 1, configurationInstances);
        }
    }

    private StringBuffer prepareDimensionRequest(CloudConfigurationDimension dimension) {
        StringBuffer bf = new StringBuffer();
        boolean firstType = true;
        for (CloudTestingType type : dimension.getEnabledTypes()) {
            if (!firstType) {
                bf.append(" || ");
            }
            firstType = false;
            bf.append(dimension.getId() + "=='" + type.getId() + "'");
        }
        return bf;
    }

    public CloudConfigurationImpl clone() {
        return this.copy(null);
    }

    public CloudConfigurationImpl copy(String prefix) {
        CloudConfigurationImpl newConfiguration = prefix == null ? new CloudConfigurationImpl(this.id, this.name, this.kind, this.icon, this.facet) : new CloudConfigurationImpl(prefix + this.name, this.kind, this.icon, this.facet);
        newConfiguration.deviceDimension.enableAll((Iterable<CloudTestingType>)this.deviceDimension.getEnabledTypes());
        newConfiguration.apiDimension.enableAll((Iterable<CloudTestingType>)this.apiDimension.getEnabledTypes());
        newConfiguration.languageDimension.enableAll((Iterable<CloudTestingType>)this.languageDimension.getEnabledTypes());
        newConfiguration.orientationDimension.enableAll((Iterable<CloudTestingType>)this.orientationDimension.getEnabledTypes());
        return newConfiguration;
    }

    public CloudPersistentConfiguration getPersistentConfiguration() {
        CloudPersistentConfiguration persistentConfiguration = new CloudPersistentConfiguration();
        persistentConfiguration.id = this.id;
        persistentConfiguration.name = this.name;
        persistentConfiguration.kind = this.kind;
        persistentConfiguration.devices = this.getEnabledTypes(this.deviceDimension);
        persistentConfiguration.apiLevels = this.getEnabledTypes(this.apiDimension);
        persistentConfiguration.languages = this.getEnabledTypes(this.languageDimension);
        persistentConfiguration.orientations = this.getEnabledTypes(this.orientationDimension);
        return persistentConfiguration;
    }

    private List<String> getEnabledTypes(CloudConfigurationDimension dimension) {
        LinkedList<String> enabledTypes = new LinkedList<String>();
        for (CloudTestingType type : dimension.getEnabledTypes()) {
            enabledTypes.add(type.getId());
        }
        return enabledTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudConfigurationImpl that = (CloudConfigurationImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }
}

