/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.Variant;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Project;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExternalAnnotationRepository {
    public static final String SDK_ANNOTATIONS_PATH = "platform-tools/api/annotations.zip";
    public static final String FN_ANNOTATIONS_XML = "annotations.xml";
    private static final boolean DEBUG = false;
    private static ExternalAnnotationRepository sSingleton;
    private final List<AnnotationsDatabase> mDatabases;
    private static final Pattern XML_SIGNATURE;

    private ExternalAnnotationRepository(List<AnnotationsDatabase> databases) {
        this.mDatabases = databases;
    }

    public static synchronized ExternalAnnotationRepository get(LintClient client) {
        if (sSingleton == null) {
            String path;
            HashSet seen = Sets.newHashSet();
            Collection projects = client.getKnownProjects();
            ArrayList files = Lists.newArrayListWithExpectedSize((int)2);
            for (Project project : projects) {
                if (!project.isGradleProject()) continue;
                Variant variant = project.getCurrentVariant();
                AndroidProject model = project.getGradleProjectModel();
                if (model == null || variant == null) continue;
                Dependencies dependencies = variant.getMainArtifact().getDependencies();
                for (AndroidLibrary library : dependencies.getLibraries()) {
                    ExternalAnnotationRepository.addLibraries(files, library, seen);
                }
            }
            File sdkAnnotations = client.findResource(SDK_ANNOTATIONS_PATH);
            if (sdkAnnotations == null && (path = System.getenv("SDK_ANNOTATIONS")) != null && !(sdkAnnotations = new File(path)).exists()) {
                sdkAnnotations = null;
            }
            if (sdkAnnotations != null) {
                files.add(sdkAnnotations);
            }
            sSingleton = ExternalAnnotationRepository.create(client, files);
        }
        return sSingleton;
    }

    static synchronized ExternalAnnotationRepository create(LintClient client, List<File> files) {
        ArrayList databases = Lists.newArrayListWithExpectedSize((int)files.size());
        for (File file : files) {
            try {
                AnnotationsDatabase database = ExternalAnnotationRepository.getDatabase(file);
                if (database == null) continue;
                databases.add(database);
            }
            catch (IOException ioe) {
                if (client != null) {
                    client.log((Throwable)ioe, "Could not read %1$s", new Object[]{file.getPath()});
                    continue;
                }
                ioe.printStackTrace();
            }
        }
        ExternalAnnotationRepository manager = new ExternalAnnotationRepository(databases);
        return manager;
    }

    private static void addLibraries(List<File> result, AndroidLibrary library, Set<AndroidLibrary> seen) {
        if (seen.contains(library)) {
            return;
        }
        seen.add(library);
        File zip = new File(library.getResFolder().getParent(), "annotations.zip");
        if (zip.exists()) {
            result.add(zip);
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            ExternalAnnotationRepository.addLibraries(result, dependency, seen);
        }
    }

    private static AnnotationsDatabase getDatabase(LintClient client, File file) {
        try {
            return file.isFile() ? new AnnotationsDatabase(file) : null;
        }
        catch (IOException ioe) {
            client.log((Throwable)ioe, "Could not read %1$s", new Object[]{file.getPath()});
            return null;
        }
    }

    static AnnotationsDatabase getDatabase(File file) throws IOException {
        return file.exists() ? new AnnotationsDatabase(file) : null;
    }

    private static AnnotationsDatabase getDatabase(LintClient client, AndroidLibrary library) {
        File zip = new File(library.getResFolder().getParent(), "annotations.zip");
        return ExternalAnnotationRepository.getDatabase(client, zip);
    }

    public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedMethod method, String type) {
        for (AnnotationsDatabase database : this.mDatabases) {
            JavaParser.ResolvedAnnotation annotation = database.getAnnotation(method, type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public Collection<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedMethod method) {
        for (AnnotationsDatabase database : this.mDatabases) {
            List<JavaParser.ResolvedAnnotation> annotations = database.getAnnotations(method);
            if (annotations == null) continue;
            return annotations;
        }
        return null;
    }

    public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedMethod method, int parameterIndex, String type) {
        for (AnnotationsDatabase database : this.mDatabases) {
            JavaParser.ResolvedAnnotation annotation = database.getAnnotation(method, parameterIndex, type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public Collection<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedMethod method, int parameterIndex) {
        for (AnnotationsDatabase database : this.mDatabases) {
            Collection<JavaParser.ResolvedAnnotation> annotations = database.getAnnotations(method, parameterIndex);
            if (annotations == null) continue;
            return annotations;
        }
        return null;
    }

    public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedClass cls, String type) {
        for (AnnotationsDatabase database : this.mDatabases) {
            JavaParser.ResolvedAnnotation annotation = database.getAnnotation(cls, type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public Collection<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedClass cls) {
        for (AnnotationsDatabase database : this.mDatabases) {
            List<JavaParser.ResolvedAnnotation> annotations = database.getAnnotations(cls);
            if (annotations == null) continue;
            return annotations;
        }
        return null;
    }

    public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedField field, String type) {
        for (AnnotationsDatabase database : this.mDatabases) {
            JavaParser.ResolvedAnnotation annotation = database.getAnnotation(field, type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public Collection<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedField field) {
        for (AnnotationsDatabase database : this.mDatabases) {
            List<JavaParser.ResolvedAnnotation> annotations = database.getAnnotations(field);
            if (annotations == null) continue;
            return annotations;
        }
        return null;
    }

    public Collection<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedAnnotation cls) {
        for (AnnotationsDatabase database : this.mDatabases) {
            List<JavaParser.ResolvedAnnotation> annotations = database.getAnnotations(cls);
            if (annotations == null) continue;
            return annotations;
        }
        return null;
    }

    public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedPackage pkg, String type) {
        for (AnnotationsDatabase database : this.mDatabases) {
            JavaParser.ResolvedAnnotation annotation = database.getAnnotation(pkg, type);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public Collection<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedPackage pkg) {
        for (AnnotationsDatabase database : this.mDatabases) {
            List<JavaParser.ResolvedAnnotation> annotations = database.getAnnotations(pkg);
            if (annotations == null) continue;
            return annotations;
        }
        return null;
    }

    private static List<Element> getChildren(Element element) {
        NodeList itemList = element.getChildNodes();
        int length = itemList.getLength();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> result = new ArrayList<Element>(Math.max(5, length / 2 + 1));
        for (int i = 0; i < length; ++i) {
            Node node = itemList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    private static String fixParameterString(String parameters) {
        return parameters.replace("  ", " ").replace(", ", ",");
    }

    static synchronized void set(ExternalAnnotationRepository singleton) {
        sSingleton = singleton;
    }

    static {
        XML_SIGNATURE = Pattern.compile("(\\S+) (\\S+|((.*)\\s+)?(\\S+)\\((.*)\\)( \\d+)?)");
    }

    private static class ResolvedExternalField
    extends JavaParser.ResolvedField {
        private final String mSignature;

        public ResolvedExternalField(String signature) {
            this.mSignature = signature;
            assert (this.mSignature.indexOf(32) == -1) : '\"' + this.mSignature + '\"';
        }

        public String getName() {
            return this.mSignature.substring(this.mSignature.lastIndexOf(46) + 1);
        }

        public String getSignature() {
            return this.mSignature;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ResolvedExternalField) {
                return this.mSignature.equals(((ResolvedExternalField)((Object)obj)).mSignature);
            }
            if (obj instanceof JavaParser.ResolvedField) {
                JavaParser.ResolvedField field = (JavaParser.ResolvedField)obj;
                if (this.mSignature.endsWith(field.getName())) {
                    JavaParser.ResolvedClass containingClass = field.getContainingClass();
                    String signature = containingClass != null ? containingClass.getSignature() + "." + field.getName() : field.getName();
                    return this.mSignature.equals(signature);
                }
                return false;
            }
            return false;
        }

        public int hashCode() {
            return this.mSignature.hashCode();
        }

        public int getModifiers() {
            return 0;
        }

        public boolean matches(String name) {
            return this.mSignature.equals(name);
        }

        public JavaParser.TypeDescriptor getType() {
            return new JavaParser.DefaultTypeDescriptor(this.mSignature);
        }

        public JavaParser.ResolvedClass getContainingClass() {
            return null;
        }

        public String getContainingClassName() {
            return this.mSignature.substring(0, this.mSignature.lastIndexOf(46));
        }

        public Object getValue() {
            return null;
        }

        public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
            return Collections.emptyList();
        }
    }

    static class AnnotationsDatabase {
        private Map<String, ClassInfo> mClassMap = Maps.newHashMapWithExpectedSize((int)800);
        private Map<String, ResolvedExternalAnnotation> mMarkerAnnotations = Maps.newHashMapWithExpectedSize((int)30);

        AnnotationsDatabase(File file) throws IOException {
            String path = file.getPath();
            if (path.endsWith(".jar") || path.endsWith("annotations.zip")) {
                this.initializeFromJar(file);
            } else {
                assert (file.isDirectory()) : file;
                this.initializeFromDirectory(file);
            }
        }

        public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedMethod method, String type) {
            MethodInfo m = this.findMethod(method);
            if (m == null) {
                return null;
            }
            if (m.annotations != null) {
                for (JavaParser.ResolvedAnnotation annotation : m.annotations) {
                    if (!type.equals(annotation.getSignature())) continue;
                    return annotation;
                }
            }
            return null;
        }

        public List<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedMethod method) {
            MethodInfo m = this.findMethod(method);
            if (m == null) {
                return null;
            }
            return m.annotations;
        }

        public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedMethod method, int parameterIndex, String type) {
            Collection annotations;
            MethodInfo m = this.findMethod(method);
            if (m == null) {
                return null;
            }
            if (m.parameterAnnotations != null && (annotations = m.parameterAnnotations.get((Object)parameterIndex)) != null) {
                for (JavaParser.ResolvedAnnotation annotation : annotations) {
                    if (!type.equals(annotation.getSignature())) continue;
                    return annotation;
                }
            }
            return null;
        }

        public Collection<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedMethod method, int parameterIndex) {
            MethodInfo m = this.findMethod(method);
            if (m == null) {
                return null;
            }
            if (m.parameterAnnotations != null) {
                return m.parameterAnnotations.get((Object)parameterIndex);
            }
            return null;
        }

        public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedClass cls, String type) {
            ClassInfo c = this.findClass(cls);
            if (c == null) {
                return null;
            }
            if (c.annotations != null) {
                for (JavaParser.ResolvedAnnotation annotation : c.annotations) {
                    if (!type.equals(annotation.getSignature())) continue;
                    return annotation;
                }
            }
            return null;
        }

        public List<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedClass cls) {
            ClassInfo c = this.findClass(cls);
            if (c == null) {
                return null;
            }
            return c.annotations;
        }

        public List<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedAnnotation cls) {
            ClassInfo c = this.findClass(cls);
            if (c == null) {
                return null;
            }
            return c.annotations;
        }

        public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedPackage pkg, String type) {
            ClassInfo c = this.findPackage(pkg);
            if (c == null) {
                return null;
            }
            if (c.annotations != null) {
                for (JavaParser.ResolvedAnnotation annotation : c.annotations) {
                    if (!type.equals(annotation.getSignature())) continue;
                    return annotation;
                }
            }
            return null;
        }

        public List<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedPackage pkg) {
            ClassInfo c = this.findPackage(pkg);
            if (c == null) {
                return null;
            }
            return c.annotations;
        }

        public JavaParser.ResolvedAnnotation getAnnotation(JavaParser.ResolvedField field, String type) {
            FieldInfo f = this.findField(field);
            if (f == null) {
                return null;
            }
            if (f.annotations != null) {
                for (JavaParser.ResolvedAnnotation annotation : f.annotations) {
                    if (!type.equals(annotation.getSignature())) continue;
                    return annotation;
                }
            }
            return null;
        }

        public List<JavaParser.ResolvedAnnotation> getAnnotations(JavaParser.ResolvedField field) {
            FieldInfo f = this.findField(field);
            if (f == null) {
                return null;
            }
            return f.annotations;
        }

        private void initializeFromDirectory(File file) throws IOException {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        this.initializeFromDirectory(f);
                    }
                }
            } else if (file.getPath().endsWith(ExternalAnnotationRepository.FN_ANNOTATIONS_XML)) {
                String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
                this.initializePackage(xml, file.getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeFromJar(File file) throws IOException {
            JarInputStream zis = null;
            try {
                FileInputStream fis = new FileInputStream(file);
                zis = new JarInputStream(fis);
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(".xml")) {
                        byte[] bytes = ByteStreams.toByteArray((InputStream)zis);
                        String xml = new String(bytes, Charsets.UTF_8);
                        this.initializePackage(xml, entry.getName());
                    }
                    entry = zis.getNextEntry();
                }
            }
            catch (Throwable throwable) {
                try {
                    Closeables.close(zis, (boolean)true);
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                Closeables.close((Closeable)zis, (boolean)true);
            }
            catch (IOException iOException) {}
        }

        private void initializePackage(String xml, String path) throws IOException {
            try {
                Document document = XmlUtils.parseDocument((String)xml, (boolean)false);
                Element root = document.getDocumentElement();
                String rootTag = root.getTagName();
                assert (rootTag.equals("root")) : rootTag;
                for (Element item : LintUtils.getChildren((Node)root)) {
                    String signature = item.getAttribute("name");
                    if (signature == null || signature.equals("null")) continue;
                    signature = XmlUtils.fromXmlAttributeValue((String)signature);
                    Matcher matcher = XML_SIGNATURE.matcher(signature);
                    if (matcher.matches()) {
                        String containingClass = matcher.group(1);
                        if (containingClass == null) {
                            throw new IOException("Could not find class for " + signature);
                        }
                        String methodName = matcher.group(5);
                        if (methodName != null) {
                            String type = matcher.group(4);
                            boolean isConstructor = type == null;
                            String parameters = matcher.group(6);
                            this.mergeMethodOrParameter(item, matcher, containingClass, methodName, isConstructor, parameters);
                            continue;
                        }
                        String fieldName = matcher.group(2);
                        this.mergeField(item, containingClass, fieldName);
                        continue;
                    }
                    if (signature.indexOf(32) == -1 && signature.indexOf(46) != -1) {
                        this.mergeClass(item, signature);
                        continue;
                    }
                    throw new IOException("No merge match for signature " + signature);
                }
            }
            catch (Exception e) {
                throw new IOException("Could not parse XML from " + path);
            }
        }

        private ClassInfo findClass(JavaParser.ResolvedClass cls) {
            return this.mClassMap.get(cls.getName());
        }

        private ClassInfo findClass(JavaParser.ResolvedAnnotation cls) {
            return this.mClassMap.get(cls.getName());
        }

        private ClassInfo findPackage(JavaParser.ResolvedPackage pkg) {
            return this.mClassMap.get(pkg.getName() + ".package-info");
        }

        private MethodInfo findMethod(JavaParser.ResolvedMethod method) {
            ClassInfo c = this.findClass(method.getContainingClass());
            if (c == null) {
                return null;
            }
            if (c.methods == null) {
                return null;
            }
            Collection methods = c.methods.get((Object)method.getName());
            if (methods == null) {
                return null;
            }
            boolean constructor = method.isConstructor();
            for (MethodInfo m : methods) {
                if (constructor != m.constructor) continue;
                String signature = m.parameters;
                int index = 0;
                boolean matches = true;
                int n = method.getArgumentCount();
                for (int i = 0; i < n; ++i) {
                    String parameterType = method.getArgumentType(i).getSignature();
                    int length = parameterType.indexOf(60);
                    if (length == -1) {
                        length = parameterType.length();
                    }
                    if (!(signature.regionMatches(false, index, parameterType, 0, length) || length > 3 && index > 3 && (parameterType.charAt(length - 1) == '.' || signature.length() >= index + length && signature.charAt(index + length - 1) == '.') && AnnotationsDatabase.isVarArgsMatch(signature, index, parameterType, length))) {
                        matches = false;
                        break;
                    }
                    index += length;
                    if (i < n - 1) {
                        if (index == signature.length()) {
                            matches = false;
                            break;
                        }
                        if (signature.charAt(index) == '<') {
                            int balance = 1;
                            int max = signature.length();
                            for (int j = index + 1; j < max; ++j) {
                                char ch = signature.charAt(j);
                                if (ch == '<') {
                                    ++balance;
                                    continue;
                                }
                                if (ch != '>' || --balance != 0) continue;
                                index = j + 1;
                                break;
                            }
                            if (balance > 0) {
                                matches = false;
                                break;
                            }
                        } else if (signature.charAt(index) != ',') {
                            matches = false;
                            break;
                        }
                    }
                    ++index;
                }
                if (!matches) continue;
                return m;
            }
            return null;
        }

        private static boolean isVarArgsMatch(String signature, int index, String parameterType, int length) {
            return parameterType.regionMatches(false, length - 3, "...", 0, 3) && signature.regionMatches(false, index + length - 3, "[]", 0, 2) && parameterType.regionMatches(false, 0, signature, index, length - 3) || parameterType.regionMatches(false, length - 2, "[]", 0, 2) && signature.regionMatches(false, index + length - 2, "...", 0, 3) && parameterType.regionMatches(false, 0, signature, index, length - 2);
        }

        private FieldInfo findField(JavaParser.ResolvedField field) {
            JavaParser.ResolvedClass containingClass = field.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            ClassInfo c = this.findClass(containingClass);
            if (c == null) {
                return null;
            }
            if (c.fields == null) {
                return null;
            }
            return c.fields.get(field.getName());
        }

        private MethodInfo createMethod(String containingClass, String methodName, boolean constructor, String parameters) {
            Collection methods;
            ClassInfo cls = this.createClass(containingClass);
            if (cls.methods != null && (methods = cls.methods.get((Object)methodName)) != null) {
                for (MethodInfo method : methods) {
                    if (!parameters.equals(method.parameters) || constructor != method.constructor) continue;
                    return method;
                }
            }
            MethodInfo method = new MethodInfo();
            method.parameters = parameters;
            method.constructor = constructor;
            if (cls.methods == null) {
                cls.methods = ArrayListMultimap.create();
            }
            cls.methods.put((Object)methodName, (Object)method);
            return method;
        }

        private ClassInfo createClass(String containingClass) {
            ClassInfo cls = this.mClassMap.get(containingClass);
            if (cls == null) {
                cls = new ClassInfo();
                this.mClassMap.put(containingClass, cls);
            }
            return cls;
        }

        private FieldInfo createField(String containingClass, String fieldName) {
            FieldInfo field;
            ClassInfo cls = this.createClass(containingClass);
            if (cls.fields != null && (field = cls.fields.get(fieldName)) != null) {
                return field;
            }
            field = new FieldInfo();
            if (cls.fields == null) {
                cls.fields = Maps.newHashMap();
            }
            cls.fields.put(fieldName, field);
            return field;
        }

        private void mergeMethodOrParameter(Element item, Matcher matcher, String containingClass, String methodName, boolean constructor, String parameters) {
            parameters = ExternalAnnotationRepository.fixParameterString(parameters);
            MethodInfo method = this.createMethod(containingClass, methodName, constructor, parameters);
            List<JavaParser.ResolvedAnnotation> annotations = this.createAnnotations(item);
            String argNum = matcher.group(7);
            if (argNum != null) {
                argNum = argNum.trim();
                int parameter = Integer.parseInt(argNum);
                if (method.parameterAnnotations == null) {
                    int parameterCount = 4;
                    method.parameterAnnotations = ArrayListMultimap.create((int)parameterCount, (int)annotations.size());
                }
                for (JavaParser.ResolvedAnnotation annotation : annotations) {
                    method.parameterAnnotations.put((Object)parameter, (Object)annotation);
                }
            } else {
                if (method.annotations == null) {
                    method.annotations = Lists.newArrayListWithExpectedSize((int)annotations.size());
                }
                method.annotations.addAll(annotations);
            }
        }

        private void mergeField(Element item, String containingClass, String fieldName) {
            FieldInfo field = this.createField(containingClass, fieldName);
            List<JavaParser.ResolvedAnnotation> annotations = this.createAnnotations(item);
            if (field.annotations == null) {
                field.annotations = Lists.newArrayListWithExpectedSize((int)annotations.size());
            }
            field.annotations.addAll(annotations);
        }

        private void mergeClass(Element item, String containingClass) {
            ClassInfo cls = this.createClass(containingClass);
            List<JavaParser.ResolvedAnnotation> annotations = this.createAnnotations(item);
            if (cls.annotations == null) {
                cls.annotations = Lists.newArrayListWithExpectedSize((int)annotations.size());
            }
            cls.annotations.addAll(annotations);
        }

        private List<JavaParser.ResolvedAnnotation> createAnnotations(Element itemElement) {
            List children = ExternalAnnotationRepository.getChildren(itemElement);
            ArrayList result = Lists.newArrayListWithExpectedSize((int)children.size());
            for (Element annotationElement : children) {
                JavaParser.ResolvedAnnotation annotation = this.createAnnotation(annotationElement);
                result.add(annotation);
            }
            return result;
        }

        private JavaParser.ResolvedAnnotation createAnnotation(Element annotationElement) {
            String tagName = annotationElement.getTagName();
            assert (tagName.equals("annotation")) : tagName;
            String name = annotationElement.getAttribute("name");
            assert (name != null && !name.isEmpty());
            ResolvedExternalAnnotation annotation = this.mMarkerAnnotations.get(name);
            if (annotation != null) {
                return annotation;
            }
            annotation = new ResolvedExternalAnnotation(name);
            List valueElements = ExternalAnnotationRepository.getChildren(annotationElement);
            if (valueElements.isEmpty() && !name.startsWith("android.support.annotation.RequiresPermission") && !name.equals("android.support.annotation.CheckResult")) {
                this.mMarkerAnnotations.put(name, annotation);
                return annotation;
            }
            for (Element valueElement : valueElements) {
                Object[] value;
                String valueName;
                block20: {
                    if (!valueElement.getTagName().equals("val")) continue;
                    valueName = valueElement.getAttribute("name");
                    String valueString = valueElement.getAttribute("val");
                    if (valueName.isEmpty() || valueString.isEmpty()) continue;
                    if (valueString.equals("true")) {
                        value = true;
                    } else if (valueString.equals("false")) {
                        value = false;
                    } else if (valueString.startsWith("\"") && valueString.endsWith("\"") && valueString.length() >= 2) {
                        value = valueString.substring(1, valueString.length() - 1);
                    } else if (valueString.startsWith("{") && valueString.endsWith("}")) {
                        String listString = valueString.substring(1, valueString.length() - 1);
                        boolean allStrings = true;
                        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
                        ArrayList result = Lists.newArrayList();
                        for (String reference : splitter.split((CharSequence)listString)) {
                            if (reference.startsWith("\"")) {
                                result.add(reference.substring(1, reference.length() - 1));
                                continue;
                            }
                            result.add(new ResolvedExternalField(reference));
                            allStrings = false;
                        }
                        value = allStrings ? result.toArray(new String[result.size()]) : result.toArray();
                    } else if (Character.isDigit(valueString.charAt(0))) {
                        try {
                            if (valueString.contains(".")) {
                                value = Double.parseDouble(valueString);
                                break block20;
                            }
                            value = Long.parseLong(valueString);
                        }
                        catch (NumberFormatException nufe) {
                            value = valueString;
                        }
                    } else {
                        value = valueString;
                    }
                }
                annotation.addValue(new JavaParser.ResolvedAnnotation.Value(valueName, (Object)value));
            }
            return annotation;
        }

        private static class ResolvedExternalAnnotation
        extends JavaParser.ResolvedAnnotation {
            private String mSignature;
            private List<JavaParser.ResolvedAnnotation.Value> mValues;

            public ResolvedExternalAnnotation(String signature) {
                this.mSignature = signature;
            }

            void addValue(JavaParser.ResolvedAnnotation.Value value) {
                if (this.mValues == null) {
                    this.mValues = Lists.newArrayList();
                }
                this.mValues.add(value);
            }

            public String getName() {
                return this.mSignature;
            }

            public String getSignature() {
                return this.mSignature;
            }

            public int getModifiers() {
                return 1;
            }

            public Iterable<JavaParser.ResolvedAnnotation> getAnnotations() {
                return Collections.emptyList();
            }

            public boolean matches(String name) {
                return this.mSignature.equals(name);
            }

            public JavaParser.TypeDescriptor getType() {
                return new JavaParser.DefaultTypeDescriptor(this.mSignature);
            }

            public JavaParser.ResolvedClass getClassType() {
                return null;
            }

            public List<JavaParser.ResolvedAnnotation.Value> getValues() {
                return this.mValues == null ? Collections.emptyList() : this.mValues;
            }
        }
    }

    private static class FieldInfo {
        public List<JavaParser.ResolvedAnnotation> annotations;

        private FieldInfo() {
        }
    }

    private static class MethodInfo {
        public String parameters;
        public boolean constructor;
        public List<JavaParser.ResolvedAnnotation> annotations;
        public Multimap<Integer, JavaParser.ResolvedAnnotation> parameterAnnotations;

        private MethodInfo() {
        }
    }

    private static class ClassInfo {
        public List<JavaParser.ResolvedAnnotation> annotations;
        public Multimap<String, MethodInfo> methods;
        public Map<String, FieldInfo> fields;

        private ClassInfo() {
        }
    }
}

