/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gdt.eclipse.login.common.OAuthData;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleLoginPrefs {
    private static final String DELIMITER = " ";
    private static final String PREFERENCES_PATH = "/com/google/gct/login";
    private static final String OAUTH_DATA_EMAIL_KEY = "credentials_email";
    private static final String OAUTH_DATA_REFRESH_TOKEN_KEY = "credentials_refresh_token";
    private static final String ICON_ONLY_KEY = "icon_only";
    private static final String LOGOUT_ON_EXIT_KEY = "logout_on_exit";
    private static final String OAUTH_SCOPES_KEY = "oauth_scopes";
    private static final String USERS = "all_users";
    private static final String ACTIVE_USER = "active_user";
    public static final Logger LOG = Logger.getInstance(GoogleLoginPrefs.class);

    public static void saveOAuthData(OAuthData credentials) {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        String userEmail = credentials.getStoredEmail();
        prefs.put(GoogleLoginPrefs.getCustomUserKey(OAUTH_DATA_REFRESH_TOKEN_KEY, userEmail), credentials.getRefreshToken());
        Joiner joiner = Joiner.on((String)DELIMITER);
        prefs.put(GoogleLoginPrefs.getCustomUserKey(OAUTH_SCOPES_KEY, userEmail), joiner.join((Iterable)credentials.getStoredScopes()));
        String storedEmail = credentials.getStoredEmail();
        if (storedEmail != null) {
            prefs.put(GoogleLoginPrefs.getCustomUserKey(OAUTH_DATA_EMAIL_KEY, userEmail), storedEmail);
        }
        GoogleLoginPrefs.addUser(credentials.getStoredEmail());
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    public static OAuthData loadOAuthData() {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        String refreshToken = prefs.get(GoogleLoginPrefs.getCustomUserKey(OAUTH_DATA_REFRESH_TOKEN_KEY), null);
        String storedEmail = prefs.get(GoogleLoginPrefs.getCustomUserKey(OAUTH_DATA_EMAIL_KEY), null);
        String storedScopesString = prefs.get(GoogleLoginPrefs.getCustomUserKey(OAUTH_SCOPES_KEY), "");
        TreeSet<String> storedScopes = new TreeSet<String>();
        for (String scope : storedScopesString.split(DELIMITER)) {
            storedScopes.add(scope);
        }
        return new OAuthData(null, refreshToken, storedEmail, storedScopes, 0L);
    }

    public static void clearStoredOAuthData() {
        CredentialedUser activeUser = GoogleLogin.getInstance().getActiveUser();
        if (activeUser == null) {
            return;
        }
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        prefs.remove(GoogleLoginPrefs.getCustomUserKey(OAUTH_DATA_REFRESH_TOKEN_KEY));
        prefs.remove(GoogleLoginPrefs.getCustomUserKey(OAUTH_DATA_EMAIL_KEY));
        prefs.remove(GoogleLoginPrefs.getCustomUserKey(OAUTH_SCOPES_KEY));
        GoogleLoginPrefs.removeUser(prefs, activeUser.getEmail());
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    public static void saveIconOnlyPref(boolean logoutOnExit) {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        prefs.putBoolean(GoogleLoginPrefs.getCustomUserKey(ICON_ONLY_KEY), logoutOnExit);
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    public static boolean getLogoutOnExitPref() {
        return GoogleLoginPrefs.getPrefs().getBoolean(GoogleLoginPrefs.getCustomUserKey(LOGOUT_ON_EXIT_KEY), false);
    }

    public static void saveLogoutOnExitPref(boolean logoutOnExit) {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        prefs.putBoolean(GoogleLoginPrefs.getCustomUserKey(LOGOUT_ON_EXIT_KEY), logoutOnExit);
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    @NotNull
    public static List<String> getStoredUsers() {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        String allUsersString = prefs.get(USERS, "");
        ArrayList<String> allUsers = new ArrayList<String>();
        if (allUsersString.isEmpty()) {
            ArrayList<String> arrayList = allUsers;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/login/GoogleLoginPrefs", "getStoredUsers"));
            }
            return arrayList;
        }
        Splitter splitter = Splitter.on((String)DELIMITER).omitEmptyStrings();
        for (String aUser : splitter.split((CharSequence)allUsersString)) {
            allUsers.add(aUser);
        }
        ArrayList<String> arrayList = allUsers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/google/gct/login/GoogleLoginPrefs", "getStoredUsers"));
        }
        return arrayList;
    }

    public static void saveActiveUser(@NotNull String user) {
        if (user == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "user", "com/google/gct/login/GoogleLoginPrefs", "saveActiveUser"));
        }
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        prefs.put(ACTIVE_USER, user);
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    public static void removeActiveUser() {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        prefs.remove(ACTIVE_USER);
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    public static void removeAllUsers() {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        prefs.remove(USERS);
        prefs.remove(ACTIVE_USER);
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    @Nullable
    public static String getActiveUser() {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        String activeUser = prefs.get(ACTIVE_USER, null);
        if (activeUser == null || activeUser.isEmpty()) {
            return null;
        }
        return activeUser;
    }

    @VisibleForTesting
    public static String getPreferencesPath() {
        return PREFERENCES_PATH;
    }

    private static void flushPrefs(Preferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            LOG.error("Could not flush preferences while saving login credentials", (Throwable)e);
        }
    }

    private static Preferences getPrefs() {
        return Preferences.userRoot().node(PREFERENCES_PATH);
    }

    private static String getCustomUserKey(String key) {
        CredentialedUser activeUser = GoogleLogin.getInstance().getActiveUser();
        if (activeUser == null) {
            return key;
        }
        return key + "_" + activeUser.getEmail();
    }

    private static String getCustomUserKey(String key, String userEmail) {
        if (userEmail == null) {
            return key;
        }
        return key + "_" + userEmail;
    }

    private static void addUser(String user) {
        Preferences prefs = GoogleLoginPrefs.getPrefs();
        String allUsersString = prefs.get(USERS, null);
        if (allUsersString == null) {
            prefs.put(USERS, user);
            return;
        }
        ArrayList<String> allUsers = new ArrayList<String>();
        Splitter splitter = Splitter.on((String)DELIMITER).omitEmptyStrings();
        for (String scope : splitter.split((CharSequence)allUsersString)) {
            allUsers.add(scope);
        }
        if (allUsers.contains(user)) {
            return;
        }
        Joiner joiner = Joiner.on((String)DELIMITER);
        prefs.put(USERS, joiner.join((Object)allUsersString, (Object)user, new Object[0]));
        GoogleLoginPrefs.flushPrefs(prefs);
    }

    private static void removeUser(Preferences prefs, String user) {
        String allUsersString = prefs.get(USERS, "");
        ArrayList allUsers = Lists.newArrayList();
        for (String scope : allUsersString.split(DELIMITER)) {
            allUsers.add(scope);
        }
        allUsers.remove(user);
        Joiner joiner = Joiner.on((String)DELIMITER);
        prefs.put(USERS, joiner.join((Iterable)allUsers));
    }
}

