/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryWriter;
import proguard.io.Finisher;

public class CascadingDataEntryWriter
implements DataEntryWriter {
    private DataEntryWriter dataEntryWriter1;
    private DataEntryWriter dataEntryWriter2;

    public CascadingDataEntryWriter(DataEntryWriter dataEntryWriter1, DataEntryWriter dataEntryWriter2) {
        this.dataEntryWriter1 = dataEntryWriter1;
        this.dataEntryWriter2 = dataEntryWriter2;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        return this.dataEntryWriter1.createDirectory(dataEntry) || this.dataEntryWriter2.createDirectory(dataEntry);
    }

    public OutputStream getOutputStream(DataEntry dataEntry) throws IOException {
        return this.getOutputStream(dataEntry, null);
    }

    public OutputStream getOutputStream(DataEntry dataEntry, Finisher finisher) throws IOException {
        OutputStream outputStream = this.dataEntryWriter1.getOutputStream(dataEntry, finisher);
        return outputStream != null ? outputStream : this.dataEntryWriter2.getOutputStream(dataEntry, finisher);
    }

    public void close() throws IOException {
        this.dataEntryWriter1.close();
        this.dataEntryWriter2.close();
        this.dataEntryWriter1 = null;
        this.dataEntryWriter2 = null;
    }
}

