/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.protocol.auth;

import com.glavsoft.exceptions.CryptoException;
import com.glavsoft.exceptions.FatalException;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.protocol.Protocol;
import com.glavsoft.rfb.protocol.auth.AuthHandler;
import com.glavsoft.rfb.protocol.auth.SecurityType;
import com.glavsoft.transport.Transport;
import com.glavsoft.utils.Strings;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class VncAuthentication
extends AuthHandler {
    @Override
    public SecurityType getType() {
        return SecurityType.VNC_AUTHENTICATION;
    }

    @Override
    public Transport authenticate(Transport transport, Protocol protocol) throws TransportException, FatalException {
        byte[] challenge = transport.readBytes(16);
        String password = protocol.getPasswordRetriever().getPassword();
        if (null == password) {
            password = "";
        }
        byte[] key = new byte[8];
        System.arraycopy(Strings.getBytesWithCharset(password, Transport.ISO_8859_1), 0, key, 0, Math.min(key.length, Strings.getBytesWithCharset(password, Transport.ISO_8859_1).length));
        transport.write(this.encrypt(challenge, key)).flush();
        return transport;
    }

    public byte[] encrypt(byte[] challenge, byte[] key) throws CryptoException {
        try {
            DESKeySpec desKeySpec = new DESKeySpec(this.mirrorBits(key));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
            SecretKey secretKey = keyFactory.generateSecret(desKeySpec);
            Cipher desCipher = Cipher.getInstance("DES/ECB/NoPadding");
            desCipher.init(1, secretKey);
            return desCipher.doFinal(challenge);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("Cannot encrypt challenge", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoException("Cannot encrypt challenge", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoException("Cannot encrypt challenge", e);
        }
        catch (BadPaddingException e) {
            throw new CryptoException("Cannot encrypt challenge", e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException("Cannot encrypt challenge", e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException("Cannot encrypt challenge", e);
        }
    }

    private byte[] mirrorBits(byte[] k) {
        byte[] key = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byte s = k[i];
            s = (byte)(s >> 1 & 0x55 | s << 1 & 0xAA);
            s = (byte)(s >> 2 & 0x33 | s << 2 & 0xCC);
            key[i] = s = (byte)(s >> 4 & 0xF | s << 4 & 0xF0);
        }
        return key;
    }
}

