/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.encoding.decoder;

import com.glavsoft.drawing.Renderer;
import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.encoding.decoder.ByteBuffer;
import com.glavsoft.rfb.encoding.decoder.Decoder;
import com.glavsoft.rfb.encoding.decoder.FramebufferUpdateRectangle;
import com.glavsoft.rfb.encoding.decoder.RawDecoder;
import com.glavsoft.transport.Transport;
import java.io.ByteArrayInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ZlibDecoder
extends Decoder {
    private Inflater decoder;

    @Override
    public void decode(Transport transport, Renderer renderer, FramebufferUpdateRectangle rect) throws TransportException {
        int zippedLength = (int)transport.readUInt32();
        if (0 == zippedLength) {
            return;
        }
        int length = rect.width * rect.height * renderer.getBytesPerPixel();
        byte[] bytes = this.unzip(transport, zippedLength, length);
        Transport unzippedReader = new Transport(new ByteArrayInputStream(bytes, zippedLength, length));
        RawDecoder.getInstance().decode(unzippedReader, renderer, rect);
    }

    protected byte[] unzip(Transport transport, int zippedLength, int length) throws TransportException {
        byte[] bytes = ByteBuffer.getInstance().getBuffer(zippedLength + length);
        transport.readBytes(bytes, 0, zippedLength);
        if (null == this.decoder) {
            this.decoder = new Inflater();
        }
        this.decoder.setInput(bytes, 0, zippedLength);
        try {
            this.decoder.inflate(bytes, zippedLength, length);
        }
        catch (DataFormatException e) {
            throw new TransportException("cannot inflate Zlib data", e);
        }
        return bytes;
    }

    @Override
    public void reset() {
        this.decoder = null;
    }
}

